/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.util.Util;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.VirtualizationConfigurationUtils;
import org.openslx.virtualization.configuration.VirtualizationConfigurationVmwareFileFormat;
import org.openslx.virtualization.hardware.ConfigurationGroups;
import org.openslx.virtualization.hardware.VirtOptionValue;
import org.openslx.virtualization.virtualizer.VirtualizerVmware;

public class VirtualizationConfigurationVmware
extends VirtualizationConfiguration {
    public static final String FILE_NAME_EXTENSION = "vmx";
    private static final Logger LOGGER = LogManager.getLogger(VirtualizationConfigurationVmware.class);
    private static final Pattern HDD_PATTERN = Pattern.compile("^(ide\\d|scsi\\d|sata\\d|nvme\\d):?(\\d?)\\.(.*)", 2);
    private static final Pattern STATELESS_WHITELIST_PATTERN;
    private static final Pattern PRIVACY_BLACKLIST_PATTERN;
    private final VirtualizationConfigurationVmwareFileFormat config;

    public VirtualizationConfigurationVmware(List<OperatingSystem> osList, File file) throws IOException, VirtualizationConfigurationException {
        super(new VirtualizerVmware(), osList);
        this.config = new VirtualizationConfigurationVmwareFileFormat(file);
        this.init();
    }

    public VirtualizationConfigurationVmware(List<OperatingSystem> osList, byte[] vmxContent, int length) throws VirtualizationConfigurationException {
        super(new VirtualizerVmware(), osList);
        this.config = new VirtualizationConfigurationVmwareFileFormat(vmxContent, length);
        this.init();
    }

    private void init() {
        HashMap<String, Controller> disks = new HashMap<String, Controller>();
        for (Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry> entry : this.config.entrySet()) {
            this.handleLoadEntry(entry, disks);
        }
        if (this.isSetAndTrue("ehci.present") && !this.isSetAndTrue("usb.present")) {
            this.addFiltered("usb.present", "TRUE");
        }
        if (this.config.get("#SLX_HDD_BUS") != null) {
            try {
                this.hdds.add(new VirtualizationConfiguration.HardDisk(this.config.get("#SLX_HDD_CHIP"), VirtualizationConfiguration.DriveBusType.valueOf(this.config.get("#SLX_HDD_BUS")), "empty"));
            }
            catch (Exception e) {
                LOGGER.debug("Error adding HDD object when parsing #SLX_HDD_BUS. Meta-data will be incorrect.", (Throwable)e);
            }
            return;
        }
        for (Map.Entry cEntry : disks.entrySet()) {
            Controller controller = (Controller)cEntry.getValue();
            String controllerType = (String)cEntry.getKey();
            if (!controller.present) continue;
            for (Map.Entry<String, Device> dEntry : controller.devices.entrySet()) {
                String deviceId = dEntry.getKey();
                Device device = dEntry.getValue();
                if (!device.present || device.deviceType != null && !device.deviceType.toLowerCase().endsWith("disk")) continue;
                VirtualizationConfiguration.DriveBusType bus = null;
                if (controllerType.startsWith("ide")) {
                    bus = VirtualizationConfiguration.DriveBusType.IDE;
                } else if (controllerType.startsWith("scsi")) {
                    bus = VirtualizationConfiguration.DriveBusType.SCSI;
                } else if (controllerType.startsWith("sata")) {
                    bus = VirtualizationConfiguration.DriveBusType.SATA;
                } else if (controllerType.startsWith("nvme")) {
                    bus = VirtualizationConfiguration.DriveBusType.NVME;
                }
                this.hdds.add(new VirtualizationConfiguration.HardDisk(controller.virtualDev, bus, device.filename));
                this.removeEntriesStartingWith(controllerType + ":" + deviceId + ".");
            }
        }
        this.isMachineSnapshot = false;
        if (!this.hdds.isEmpty()) {
            VirtualizationConfiguration.HardDisk hdd = (VirtualizationConfiguration.HardDisk)this.hdds.get(0);
            this.addFiltered("#SLX_HDD_BUS", hdd.bus.toString());
            if (hdd.chipsetDriver != null) {
                this.addFiltered("#SLX_HDD_CHIP", hdd.chipsetDriver);
            }
        }
    }

    private void removeEntriesStartingWith(String start) {
        Iterator<Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry>> it = this.config.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry> entry = it.next();
            if (!entry.getKey().startsWith(start)) continue;
            it.remove();
        }
    }

    private void addFiltered(String key, String value) {
        this.config.set(key, value);
    }

    private boolean isSetAndTrue(String key) {
        String value = this.config.get(key);
        return value != null && value.equalsIgnoreCase("true");
    }

    private void handleLoadEntry(Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry> entry, Map<String, Controller> disks) {
        String lowerKey = entry.getKey().toLowerCase();
        String value = entry.getValue().getValue();
        if (lowerKey.equals("guestos")) {
            this.setOs(value);
            return;
        }
        if (lowerKey.equals("displayname")) {
            this.displayName = value;
            return;
        }
        Matcher hdd = HDD_PATTERN.matcher(entry.getKey());
        if (hdd.find()) {
            this.handleHddEntry(disks, hdd.group(1).toLowerCase(), hdd.group(2), hdd.group(3), value);
        }
    }

    private void handleHddEntry(Map<String, Controller> disks, String controllerStr, String deviceStr, String property, String value) {
        Controller controller = disks.get(controllerStr);
        if (controller == null) {
            controller = new Controller();
            disks.put(controllerStr, controller);
        }
        if (deviceStr == null || deviceStr.isEmpty()) {
            if (property.equalsIgnoreCase("present")) {
                controller.present = Boolean.parseBoolean(value);
            } else if (property.equalsIgnoreCase("virtualDev")) {
                controller.virtualDev = value;
            }
            return;
        }
        Device device = controller.devices.get(deviceStr);
        if (device == null) {
            device = new Device();
            controller.devices.put(deviceStr, device);
        }
        if (property.equalsIgnoreCase("deviceType")) {
            device.deviceType = value;
        } else if (property.equalsIgnoreCase("filename")) {
            device.filename = value;
        } else if (property.equalsIgnoreCase("present")) {
            device.present = Boolean.parseBoolean(value);
        }
    }

    @Override
    public boolean addEmptyHddTemplate() {
        return this.addHddTemplate("%VM_DISK_PATH%", "%VM_DISK_MODE%", "%VM_DISK_REDOLOGDIR%");
    }

    @Override
    public boolean addHddTemplate(File diskImage, String hddMode, String redoDir) {
        return this.addHddTemplate(diskImage.getName(), hddMode, redoDir);
    }

    @Override
    public boolean addHddTemplate(String diskImagePath, String hddMode, String redoDir) {
        String prefix;
        if (diskImagePath.isEmpty()) {
            LOGGER.error("Empty disk image path given!");
            return false;
        }
        if (this.hdds.isEmpty()) {
            LOGGER.warn("No HDDs found in configuration");
            return false;
        }
        VirtualizationConfiguration.HardDisk hdd = (VirtualizationConfiguration.HardDisk)this.hdds.get(0);
        String chipset = hdd.chipsetDriver;
        switch (hdd.bus) {
            case SATA: {
                prefix = "scsi0";
                chipset = "lsisas1068";
                break;
            }
            case IDE: 
            case SCSI: 
            case NVME: {
                prefix = hdd.bus.name().toLowerCase() + "0";
                break;
            }
            default: {
                LOGGER.warn("Unknown HDD bus type: " + hdd.bus.toString());
                return false;
            }
        }
        this.addFiltered(prefix + ".present", "TRUE");
        if (chipset != null) {
            this.addFiltered(prefix + ".virtualDev", chipset);
        }
        this.addFiltered(prefix + ":0.present", "TRUE");
        this.addFiltered(prefix + ":0.deviceType", "disk");
        this.addFiltered(prefix + ":0.fileName", diskImagePath);
        if (hddMode != null) {
            this.addFiltered(prefix + ":0.mode", hddMode);
            this.addFiltered(prefix + ":0.redo", "");
            this.addFiltered(prefix + ":0.redoLogDir", redoDir);
        }
        this.config.remove("#SLX_HDD_BUS");
        this.config.remove("#SLX_HDD_CHIP");
        return true;
    }

    @Override
    public boolean addDefaultNat() {
        this.addFiltered("ethernet0.present", "TRUE");
        this.addFiltered("ethernet0.connectionType", "nat");
        return true;
    }

    @Override
    public boolean addEthernet(VirtualizationConfiguration.EtherType type) {
        boolean ret = false;
        int index = 0;
        while (this.config.get("ethernet" + index + ".present") != null) {
            ++index;
        }
        switch (type) {
            case NAT: {
                ret = this.addEthernet(index, EthernetType.NAT);
                break;
            }
            case BRIDGED: {
                ret = this.addEthernet(index, EthernetType.BRIDGED);
                break;
            }
            case HOST_ONLY: {
                ret = this.addEthernet(index, EthernetType.HOST_ONLY);
                break;
            }
        }
        return ret;
    }

    public boolean addEthernet(int index, EthernetType type) {
        String dev;
        String ether = "ethernet" + index;
        this.addFiltered(ether + ".present", "TRUE");
        this.addFiltered(ether + ".connectionType", "custom");
        this.addFiltered(ether + ".vnet", type.vmnet);
        if (this.config.get(ether + ".virtualDev") == null && (dev = this.config.get("ethernet0.virtualDev")) != null) {
            this.addFiltered(ether + ".virtualDev", dev);
        }
        return true;
    }

    @Override
    public void addFloppy(int index, String image, boolean readOnly) {
        String pre = "floppy" + index;
        this.addFiltered(pre + ".present", "TRUE");
        if (image == null) {
            this.addFiltered(pre + ".startConnected", "FALSE");
            this.addFiltered(pre + ".fileType", "device");
            this.config.remove(pre + ".fileName");
            this.config.remove(pre + ".readonly");
            this.addFiltered(pre + ".autodetect", "TRUE");
        } else {
            this.addFiltered(pre + ".startConnected", "TRUE");
            this.addFiltered(pre + ".fileType", "file");
            this.addFiltered(pre + ".fileName", image);
            this.addFiltered(pre + ".readonly", VirtualizationConfigurationVmware.vmBoolean(readOnly));
            this.config.remove(pre + ".autodetect");
        }
    }

    @Override
    public boolean addCdrom(String image) {
        for (String port : new String[]{"ide0:0", "ide0:1", "ide1:0", "ide1:1", "scsi0:1"}) {
            if (this.isSetAndTrue(port + ".present")) continue;
            this.addFiltered(port + ".present", "TRUE");
            if (image == null) {
                this.addFiltered(port + ".autodetect", "TRUE");
                this.addFiltered(port + ".deviceType", "cdrom-raw");
                this.config.remove(port + ".fileName");
            } else {
                this.config.remove(port + ".autodetect");
                this.addFiltered(port + ".deviceType", "cdrom-image");
                this.addFiltered(port + ".fileName", image);
            }
            return true;
        }
        return false;
    }

    private static String vmBoolean(boolean var) {
        return Boolean.toString(var).toUpperCase();
    }

    private static String vmInteger(int val) {
        return Integer.toString(val);
    }

    @Override
    public void transformNonPersistent() throws VirtualizationConfigurationException {
        Iterator<Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry>> it = this.config.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry> elem = it.next();
            if (STATELESS_WHITELIST_PATTERN.matcher(elem.getKey()).find()) continue;
            it.remove();
        }
        this.addFiltered("suspend.disabled", "TRUE");
    }

    @Override
    public void transformEditable() throws VirtualizationConfigurationException {
        this.addFiltered("gui.applyHostDisplayScalingToGuest", "FALSE");
        List<VirtualizationConfiguration.ConfigurableOptionGroup> groups = this.getConfigurableOptions();
        for (VirtualizationConfiguration.ConfigurableOptionGroup group : groups) {
            if (group.groupIdentifier != ConfigurationGroups.USB_SPEED) continue;
            int currentSpeed = 0;
            VirtOptionValue twoPointOh = null;
            for (VirtOptionValue option : group.availableOptions) {
                int s = Util.parseInt(option.getId(), 0);
                if (option.isActive() && s > currentSpeed) {
                    currentSpeed = s;
                }
                if (s != 2) continue;
                twoPointOh = option;
            }
            if (currentSpeed >= 3 || twoPointOh == null) continue;
            twoPointOh.apply();
        }
    }

    @Override
    public void transformPrivacy() throws VirtualizationConfigurationException {
        Iterator<Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry>> it = this.config.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, VirtualizationConfigurationVmwareFileFormat.ConfigEntry> elem = it.next();
            String key = elem.getKey();
            String value = elem.getValue().getValue();
            if (key.endsWith(".fileName") && !value.startsWith("-") && (value.contains(".") || value.contains("/") || value.contains("\\"))) {
                it.remove();
                continue;
            }
            if (!PRIVACY_BLACKLIST_PATTERN.matcher(key).find()) continue;
            it.remove();
        }
    }

    @Override
    public boolean addDisplayName(String name) {
        this.addFiltered("displayName", name);
        return true;
    }

    @Override
    public boolean addRam(int mem) {
        this.addFiltered("memsize", Integer.toString(mem));
        return true;
    }

    @Override
    public void setOs(String vendorOsId) {
        this.addFiltered("guestOS", vendorOsId);
        OperatingSystem os = VirtualizationConfigurationUtils.getOsOfVirtualizerFromList(this.osList, "vmware", vendorOsId);
        this.setOs(os);
    }

    @Override
    public byte[] getConfigurationAsByteArray() {
        return this.config.toString().getBytes(StandardCharsets.UTF_8);
    }

    public String getValue(String key) {
        return this.config.get(key);
    }

    @Override
    public void setVirtualizerVersion(Version type) {
        this.addFiltered("virtualHW.version", VirtualizationConfigurationVmware.vmInteger(type.getMajor()));
    }

    @Override
    public Version getVirtualizerVersion() {
        short major = Integer.valueOf(Util.parseInt(this.config.get("virtualHW.version"), -1)).shortValue();
        return Version.getInstanceByMajorFromVersions(major, this.getVirtualizer().getSupportedVersions());
    }

    @Override
    public boolean addCpuCoreCount(int numCores) {
        this.addFiltered("numvcpus", VirtualizationConfigurationVmware.vmInteger(numCores));
        return true;
    }

    @Override
    public void registerVirtualHW() {
        ArrayList<VirtOptionValue> list = new ArrayList<VirtOptionValue>();
        list.add(new VmWareSoundCardModelNone("None"));
        list.add(new VmWareSoundCardModel("", "(default)"));
        list.add(new VmWareSoundCardModel("sb16", "Sound Blaster 16"));
        list.add(new VmWareSoundCardModel("es1371", "ES 1371"));
        list.add(new VmWareSoundCardModel("hdaudio", "Intel Integrated HD Audio"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.SOUND_CARD_MODEL, list));
        list = new ArrayList();
        list.add(new VmWareAccel3D("FALSE", "2D"));
        list.add(new VmWareAccel3D("TRUE", "3D"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.GFX_TYPE, list));
        list = new ArrayList();
        list.add(new VmwareNicModel(0, "", "(default)"));
        list.add(new VmwareNicModel(0, "vlance", "AMD PCnet32"));
        list.add(new VmwareNicModel(0, "e1000", "Intel E1000 (PCI)"));
        list.add(new VmwareNicModel(0, "e1000e", "Intel E1000e (PCI-Express)"));
        list.add(new VmwareNicModel(0, "vmxnet", "VMXnet"));
        list.add(new VmwareNicModel(0, "vmxnet3", "VMXnet 3"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.NIC_MODEL, list));
        list = new ArrayList();
        list.add(new VmWareUsbSpeed(0, "None"));
        list.add(new VmWareUsbSpeed(1, "USB 1.1"));
        list.add(new VmWareUsbSpeed(2, "USB 2.0"));
        list.add(new VmWareUsbSpeed(3, "USB 3.0"));
        this.configurableOptions.add(new VirtualizationConfiguration.ConfigurableOptionGroup(ConfigurationGroups.USB_SPEED, list));
    }

    @Override
    public String getFileNameExtension() {
        return FILE_NAME_EXTENSION;
    }

    @Override
    public void validate() throws VirtualizationConfigurationException {
    }

    @Override
    public void disableUsb() {
        new VmWareUsbSpeed(0, "None").apply();
    }

    @Override
    public String getSuspendedFile() {
        return this.config.get("checkpoint.vmState");
    }

    static {
        CharSequence[] list1 = new String[]{"^guestos", "^uuid\\.bios", "^config\\.version", "^ehci[.:]", "^mks\\.enable3d", "^virtualhw\\.", "^sound[.:]", "\\.pcislotnumber$", "^pcibridge", "\\.virtualdev$", "^tools\\.syncTime$", "^time\\.synchronize", "^bios\\.bootDelay", "^rtc\\.", "^xhci[.:]", "^usb_xhci[.:]", "\\.deviceType$", "\\.port$", "\\.parent$", "^usb[.:]", "^firmware", "^hpet", "^vm\\.genid", "^svga\\.graphicsMemoryKB$"};
        STATELESS_WHITELIST_PATTERN = Pattern.compile(String.join((CharSequence)"|", list1), 2);
        CharSequence[] list2 = new String[]{"^displayname$", "^extendedconfigfile$", "^gui\\.", "^nvram$", "^memsize$"};
        PRIVACY_BLACKLIST_PATTERN = Pattern.compile(String.join((CharSequence)"|", list2), 2);
    }

    class VmWareUsbSpeed
    extends VirtOptionValue {
        private final String[] SPEED;
        private final int speed;

        public VmWareUsbSpeed(int speed, String displayName) {
            super(Integer.toString(speed), displayName);
            this.SPEED = new String[]{null, "usb", "ehci", "usb_xhci"};
            this.speed = speed;
        }

        @Override
        public void apply() {
            for (int i = 1; i < this.SPEED.length; ++i) {
                String key = this.SPEED[i] + ".present";
                if (i <= this.speed) {
                    VirtualizationConfigurationVmware.this.addFiltered(key, "TRUE");
                    continue;
                }
                VirtualizationConfigurationVmware.this.config.remove(key);
            }
            if (this.speed > 0 && this.speed < 3) {
                VirtualizationConfigurationVmware.this.addFiltered("usb.mangleUsb3Speed", "TRUE");
            }
        }

        @Override
        public boolean isActive() {
            int max = 0;
            for (int i = 1; i < this.SPEED.length; ++i) {
                if (!VirtualizationConfigurationVmware.this.isSetAndTrue(this.SPEED[i] + ".present")) continue;
                max = i;
            }
            return this.speed == max;
        }
    }

    class VmwareNicModel
    extends VirtOptionValue {
        private final int cardIndex;

        public VmwareNicModel(int cardIndex, String id, String displayName) {
            super(id, displayName);
            this.cardIndex = cardIndex;
        }

        @Override
        public void apply() {
            if (Util.isEmptyString(this.id)) {
                VirtualizationConfigurationVmware.this.config.remove("ethernet" + this.cardIndex + ".virtualDev");
            } else {
                VirtualizationConfigurationVmware.this.addFiltered("ethernet" + this.cardIndex + ".virtualDev", this.id);
            }
        }

        @Override
        public boolean isActive() {
            String temp = VirtualizationConfigurationVmware.this.config.get("ethernet" + this.cardIndex + ".virtualDev");
            if (temp == null) {
                return Util.isEmptyString(this.id);
            }
            return temp.equals(this.id);
        }
    }

    class VmWareAccel3D
    extends VirtOptionValue {
        public VmWareAccel3D(String id, String displayName) {
            super(id, displayName);
        }

        @Override
        public void apply() {
            VirtualizationConfigurationVmware.this.addFiltered("mks.enable3d", this.id);
        }

        @Override
        public boolean isActive() {
            return Boolean.parseBoolean(this.id) == VirtualizationConfigurationVmware.this.isSetAndTrue("mks.enable3d");
        }
    }

    class VmWareSoundCardModel
    extends VirtOptionValue {
        public VmWareSoundCardModel(String id, String displayName) {
            super(id, displayName);
        }

        @Override
        public void apply() {
            VirtualizationConfigurationVmware.this.addFiltered("sound.present", VirtualizationConfigurationVmware.vmBoolean(true));
            VirtualizationConfigurationVmware.this.addFiltered("sound.autodetect", VirtualizationConfigurationVmware.vmBoolean(true));
            VirtualizationConfigurationVmware.this.addFiltered("sound.virtualDev", this.id);
        }

        @Override
        public boolean isActive() {
            return VirtualizationConfigurationVmware.this.isSetAndTrue("sound.present") && VirtualizationConfigurationVmware.this.isSetAndTrue("sound.autodetect") && this.id.equals(VirtualizationConfigurationVmware.this.config.get("sound.virtualDev"));
        }
    }

    class VmWareSoundCardModelNone
    extends VirtOptionValue {
        public VmWareSoundCardModelNone(String displayName) {
            super("none", displayName);
        }

        @Override
        public void apply() {
            VirtualizationConfigurationVmware.this.addFiltered("sound.present", VirtualizationConfigurationVmware.vmBoolean(false));
            VirtualizationConfigurationVmware.this.addFiltered("sound.autodetect", VirtualizationConfigurationVmware.vmBoolean(false));
            VirtualizationConfigurationVmware.this.config.remove("sound.virtualDev");
        }

        @Override
        public boolean isActive() {
            return !VirtualizationConfigurationVmware.this.isSetAndTrue("sound.present");
        }
    }

    class VmwareNoSoundCard
    extends VirtOptionValue {
        public VmwareNoSoundCard(String displayName) {
            super("", displayName);
        }

        @Override
        public void apply() {
            VirtualizationConfigurationVmware.this.addFiltered("sound.present", VirtualizationConfigurationVmware.vmBoolean(false));
            VirtualizationConfigurationVmware.this.config.remove("sound.virtualDev");
        }

        @Override
        public boolean isActive() {
            return !VirtualizationConfigurationVmware.this.isSetAndTrue("sound.present");
        }
    }

    private static class Controller {
        public boolean present = true;
        public String virtualDev = null;
        Map<String, Device> devices = new HashMap<String, Device>();

        private Controller() {
        }

        public String toString() {
            return this.virtualDev + " is (present: " + this.present + "): " + this.devices.toString();
        }
    }

    private static class Device {
        public boolean present = false;
        public String deviceType = null;
        public String filename = null;

        private Device() {
        }

        public String toString() {
            return this.filename + " is " + this.deviceType + " (present: " + this.present + ")";
        }
    }

    public static enum EthernetType {
        NAT("vmnet1"),
        BRIDGED("vmnet0"),
        HOST_ONLY("vmnet2");

        public final String vmnet;

        private EthernetType(String vnet) {
            this.vmnet = vnet;
        }
    }
}

