/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.thrift.TEnum;
import org.openslx.virtualization.configuration.container.ContainerBindMount;
import org.openslx.virtualization.configuration.container.ContainerImageContext;

public class ContainerMeta {
    private int build_context_method;
    private String image_repo;
    private String build_context_url;
    private String image_name;
    private String run_options;
    private String run_command;
    private String image_type;
    private List<ContainerBindMount> bind_mount_config = new ArrayList<ContainerBindMount>();

    public ContainerMeta() {
        this.image_repo = "";
        this.build_context_method = ContainerImageContext.DOCKERFILE.ordinal();
        this.build_context_url = "";
        this.image_name = "";
        this.run_options = "";
        this.run_command = "";
        this.image_type = ContainerImageType.LECTURE.toString();
        this.bind_mount_config = new ArrayList<ContainerBindMount>();
    }

    public ContainerMeta(ContainerMeta containerMeta) {
        this.build_context_method = containerMeta.build_context_method;
        this.build_context_url = containerMeta.build_context_url;
        this.image_name = containerMeta.image_name;
        this.run_options = containerMeta.run_options;
        this.run_command = containerMeta.run_command;
        this.image_repo = containerMeta.image_repo;
        for (ContainerBindMount bm : containerMeta.bind_mount_config) {
            this.bind_mount_config.add(new ContainerBindMount(bm.getSource(), bm.getTarget(), bm.getOptions()));
        }
    }

    public int getContainerImageContext() {
        return this.build_context_method;
    }

    public void setContainerImageContext(int buildContextMethod) {
        this.build_context_method = buildContextMethod;
    }

    public String getBuildContextUrl() {
        return this.build_context_url;
    }

    public void setBuildContextUrl(String buildContextUrl) {
        this.build_context_url = buildContextUrl;
    }

    public String getRunOptions() {
        return this.run_options;
    }

    public void setRunOptions(String run_options) {
        this.run_options = run_options;
    }

    public String getRunCommand() {
        return this.run_command;
    }

    public void setRunCommand(String run_command) {
        this.run_command = run_command;
    }

    public String getImageName() {
        return this.image_name;
    }

    public void setImageName(String image_name) {
        this.image_name = image_name;
    }

    public List<ContainerBindMount> getBindMountConfig() {
        return this.bind_mount_config;
    }

    public void setBindMountConfig(List<ContainerBindMount> bindMountConfig) {
        this.bind_mount_config = bindMountConfig;
    }

    public String getImageRepo() {
        return this.image_repo;
    }

    public void setImageRepo(String from_image) {
        this.image_repo = from_image;
    }

    public ContainerImageType getImageType() {
        if (this.image_type == null || this.image_type.length() == 0) {
            return ContainerImageType.LECTURE;
        }
        return ContainerImageType.valueOf(this.image_type);
    }

    public void setImageType(ContainerImageType image_type) {
        this.image_type = image_type.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerMeta that = (ContainerMeta)o;
        return Objects.equals(this.build_context_url, that.build_context_url) && Objects.equals(this.image_name, that.image_name) && Objects.equals(this.run_options, that.run_options) && Objects.equals(this.run_command, that.run_command) && Objects.equals(this.bind_mount_config, that.bind_mount_config) && Objects.equals(this.image_repo, that.image_repo) && Objects.equals(this.image_type, that.image_type);
    }

    public int hashCode() {
        return Objects.hash(this.build_context_url, this.image_name, this.run_options, this.run_command, this.bind_mount_config, this.image_repo, this.image_type);
    }

    public static enum ContainerImageType implements TEnum
    {
        LECTURE("Lecture"),
        BATCH("Batch"),
        DATA("Data");

        private final String displayLable;

        private ContainerImageType(String name) {
            this.displayLable = name;
        }

        public boolean equalNames(String other) {
            return this.displayLable.equals(other);
        }

        public String toString() {
            return this.displayLable;
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

