/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.logic;

import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.data.ConfigurationDataDozModClientToDozModServer;
import org.openslx.virtualization.configuration.logic.ConfigurationLogic;
import org.openslx.virtualization.configuration.transformation.TransformationException;

public class ConfigurationLogicDozModClientToDozModServer
extends ConfigurationLogic<ConfigurationDataDozModClientToDozModServer> {
    private static final String CONFIGURATION_LOGIC_NAME = "Transformation of virtualization configuration during upload from DozMod client to DozMod server";

    public ConfigurationLogicDozModClientToDozModServer() {
        super(CONFIGURATION_LOGIC_NAME);
    }

    private void validateInputs(VirtualizationConfiguration config, ConfigurationDataDozModClientToDozModServer args) throws TransformationException {
        if (config == null || args == null) {
            throw new TransformationException("Virtualization configuration or input arguments are missing!");
        }
        if (config.getDisplayName() == null) {
            throw new TransformationException("Display name is missing in virtualization configuration!");
        }
    }

    @Override
    public void transform(VirtualizationConfiguration config, ConfigurationDataDozModClientToDozModServer args) throws TransformationException {
        this.validateInputs(config, args);
        try {
            config.transformPrivacy();
        }
        catch (VirtualizationConfigurationException e) {
            throw new TransformationException(e.getLocalizedMessage());
        }
    }
}

