/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.logic;

import java.util.Map;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.data.ConfigurationDataDozModServerToDozModClient;
import org.openslx.virtualization.configuration.logic.ConfigurationLogic;
import org.openslx.virtualization.configuration.transformation.TransformationException;

public class ConfigurationLogicDozModServerToDozModClient
extends ConfigurationLogic<ConfigurationDataDozModServerToDozModClient> {
    private static final String CONFIGURATION_LOGIC_NAME = "Transformation of virtualization configuration during download from DozMod server to DozMod client";
    private static final int CONFIGURATION_LOGIC_NUM_CPU_CORES = 1;
    private static final int CONFIGURATION_LOGIC_MEMORY_MIN = 1024;

    public ConfigurationLogicDozModServerToDozModClient() {
        super(CONFIGURATION_LOGIC_NAME);
    }

    private void validateInputs(VirtualizationConfiguration config, ConfigurationDataDozModServerToDozModClient args) throws TransformationException {
        if (config == null || args == null) {
            throw new TransformationException("Virtualization configuration or input arguments are missing!");
        }
        if (args.getDisplayName() == null || args.getDisplayName().isEmpty()) {
            throw new TransformationException("Valid display name is not specified!");
        }
        if (args.getDiskImage() == null || !args.getDiskImage().exists()) {
            throw new TransformationException("Valid disk image file is not specified!");
        }
        if (args.getTotalMemory() <= 0) {
            throw new TransformationException("Total memory amount is not specified!");
        }
    }

    private static int roundToNearest(int value, int nearestFactor) {
        return value / nearestFactor * nearestFactor;
    }

    private static int calculateVirtualizationMemoryOnDozmodClient(int totalMemory, int osMaxMemory) {
        int memory = totalMemory / 2 - 512;
        if (memory < 1024) {
            memory = 1024;
        }
        if (osMaxMemory > 0 && memory > osMaxMemory) {
            memory = osMaxMemory;
        }
        return ConfigurationLogicDozModServerToDozModClient.roundToNearest(memory, 4);
    }

    @Override
    public void transform(VirtualizationConfiguration config, ConfigurationDataDozModServerToDozModClient args) throws TransformationException {
        Map<String, String> virtOsIdMap;
        this.validateInputs(config, args);
        if (!config.addDisplayName(args.getDisplayName())) {
            throw new TransformationException("Can not set display name in virtualization configuration!");
        }
        if (!config.addHddTemplate(args.getDiskImage(), null, null)) {
            throw new TransformationException("Can not configure hard disk in virtualization configuration!");
        }
        if (!config.addDefaultNat()) {
            throw new TransformationException("Can not configure NAT interface in virtualization configuration!");
        }
        OperatingSystem guestOs = args.getGuestOs();
        String virtualizerId = args.getVirtualizerId();
        int osMaxMemory = 0;
        if (guestOs != null && virtualizerId != null && (virtOsIdMap = guestOs.getVirtualizerOsId()) != null) {
            int maxMemMb;
            String virtOsId = virtOsIdMap.get(virtualizerId);
            if (virtOsId != null) {
                config.setOs(virtOsId);
            }
            if ((maxMemMb = guestOs.getMaxMemMb()) > 0) {
                osMaxMemory = maxMemMb;
            }
        }
        if (!config.addCpuCoreCount(1)) {
            throw new TransformationException("Can not set CPU core count in virtualization configuration!");
        }
        int virtualizationMemory = ConfigurationLogicDozModServerToDozModClient.calculateVirtualizationMemoryOnDozmodClient(args.getTotalMemory(), osMaxMemory);
        if (!config.addRam(virtualizationMemory)) {
            throw new TransformationException("Can not set memory in virtualization configuration!");
        }
        config.addFloppy(0, null, true);
        config.addFloppy(1, null, true);
        config.addCdrom("");
        config.addCdrom(null);
        try {
            config.transformEditable();
        }
        catch (VirtualizationConfigurationException e) {
            throw new TransformationException(e.getLocalizedMessage());
        }
    }
}

