/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.logic;

import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.data.ConfigurationDataDozModServerToStatelessClient;
import org.openslx.virtualization.configuration.logic.ConfigurationLogic;
import org.openslx.virtualization.configuration.transformation.TransformationException;

public class ConfigurationLogicDozModServerToStatelessClient
extends ConfigurationLogic<ConfigurationDataDozModServerToStatelessClient> {
    private static final String CONFIGURATION_LOGIC_NAME = "Transformation of virtualization configuration during download from DozMod server to stateless client";
    private static final VirtualizationConfiguration.EtherType CONFIGURATION_DEFAULT_ETHERNET_TYPE = VirtualizationConfiguration.EtherType.NAT;

    public ConfigurationLogicDozModServerToStatelessClient() {
        super(CONFIGURATION_LOGIC_NAME);
    }

    private void validateInputs(VirtualizationConfiguration config, ConfigurationDataDozModServerToStatelessClient args) throws TransformationException {
        if (config == null || args == null) {
            throw new TransformationException("Virtualization configuration or input arguments are missing!");
        }
        if (args.getDisplayName() == null || args.getDisplayName().isEmpty()) {
            throw new TransformationException("Valid display name is not specified!");
        }
    }

    @Override
    public void transform(VirtualizationConfiguration config, ConfigurationDataDozModServerToStatelessClient args) throws TransformationException {
        this.validateInputs(config, args);
        try {
            config.transformNonPersistent();
        }
        catch (VirtualizationConfigurationException e) {
            throw new TransformationException(e.getLocalizedMessage());
        }
        if (!config.addDisplayName(args.getDisplayName())) {
            throw new TransformationException("Can not set display name in virtualization configuration!");
        }
        if (!config.addEmptyHddTemplate()) {
            throw new TransformationException("Can not configure hard disk in virtualization configuration!");
        }
        if (!config.addEthernet(CONFIGURATION_DEFAULT_ETHERNET_TYPE)) {
            throw new TransformationException("Can not configure NAT interface in virtualization configuration!");
        }
        if (args.getOsId() != null) {
            config.setOs(args.getOsId());
        }
        if (!args.hasUsbAccess()) {
            config.disableUsb();
        }
    }
}

