/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.transformation;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.virtualization.configuration.transformation.Transformation;
import org.openslx.virtualization.configuration.transformation.TransformationException;
import org.openslx.virtualization.configuration.transformation.TransformationFunction;

public class TransformationManager<T, R> {
    private ArrayList<Transformation<T, R>> transformations = new ArrayList();
    private T config;
    private R args;
    private static final Logger LOGGER = LogManager.getLogger(TransformationManager.class);

    public TransformationManager(T config, R args) {
        this.config = config;
        this.args = args;
    }

    public void register(Transformation<T, R> transformation) {
        this.register(transformation, true);
    }

    public void register(Transformation<T, R> transformation, boolean enabled) {
        LOGGER.debug("Register transformation '" + transformation.getName() + "' and " + (enabled ? "enable" : "do not enable") + " it");
        transformation.setEnabled(enabled);
        this.transformations.add(transformation);
    }

    public void register(String name, TransformationFunction<T, R> function) {
        this.register(name, function, true);
    }

    public void register(String name, final TransformationFunction<T, R> function, boolean enabled) {
        this.register(new Transformation<T, R>(name){

            @Override
            public void transform(T document, R args) throws TransformationException {
                function.apply(document, args);
            }
        }, enabled);
    }

    public void transform() throws TransformationException {
        for (Transformation<T, R> transformation : this.transformations) {
            LOGGER.debug("Apply transformation '" + transformation.getName() + "'");
            transformation.apply(this.config, this.args);
        }
    }

    private String showTransformations() {
        String transformationSummary = "";
        int maxFilterNumCharacters = (this.transformations.size() + 1) / 10;
        for (int i = 0; i < this.transformations.size(); ++i) {
            Transformation<T, R> transformation = this.transformations.get(i);
            String paddedNumber = String.format("%-" + maxFilterNumCharacters + "s", i + 1);
            String transformationState = transformation.isEnabled() ? "[ active ]" : "[inactive]";
            transformationSummary = transformationSummary + paddedNumber + ": " + transformationState + " ";
            transformationSummary = transformationSummary + transformation.getName() + System.lineSeparator();
        }
        return transformationSummary;
    }

    public String toString() {
        return this.showTransformations();
    }
}

