/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.ChunkedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.openslx.util.Util;

public abstract class NanoHTTPD
implements Runnable {
    public static final int SOCKET_READ_TIMEOUT = 10000;
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    private static final String QUERY_STRING_PARAMETER = "NanoHttpd.QUERY_STRING";
    private final ServerSocket myServerSocket;
    private Set<Socket> openConnections = new HashSet<Socket>();
    private final ExecutorService asyncRunner;
    protected int maxRequestSize = 0;

    public NanoHTTPD(String hostname, int port, ExecutorService executor) throws IOException {
        this.asyncRunner = executor;
        this.myServerSocket = new ServerSocket();
        this.myServerSocket.setReuseAddress(true);
        this.myServerSocket.bind(hostname != null ? new InetSocketAddress(hostname, port) : new InetSocketAddress(port));
    }

    @Override
    public void run() {
        do {
            try {
                final Socket sck = this.myServerSocket.accept();
                this.registerConnection(sck);
                sck.setSoTimeout(10000);
                final InputStream inputStream = sck.getInputStream();
                try {
                    this.asyncRunner.execute(new Runnable(){

                        @Override
                        public void run() {
                            OutputStream outputStream = null;
                            try {
                                outputStream = sck.getOutputStream();
                                HTTPSession session = new HTTPSession(inputStream, outputStream, sck.getInetAddress());
                                while (!(sck.isClosed() || sck.isInputShutdown() || sck.isOutputShutdown())) {
                                    session.execute();
                                }
                            }
                            catch (Exception e) {
                                block5: {
                                    try {
                                        if (e instanceof SocketTimeoutException || e instanceof SocketException && "NanoHttpd Shutdown".equals(e.getMessage())) break block5;
                                        e.printStackTrace();
                                    }
                                    catch (Throwable throwable) {
                                        Util.safeClose(outputStream, inputStream, sck);
                                        NanoHTTPD.this.unRegisterConnection(sck);
                                        throw throwable;
                                    }
                                }
                                Util.safeClose(outputStream, inputStream, sck);
                                NanoHTTPD.this.unRegisterConnection(sck);
                            }
                            Util.safeClose(outputStream, inputStream, sck);
                            NanoHTTPD.this.unRegisterConnection(sck);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    Util.safeClose(sck, inputStream);
                    this.unRegisterConnection(sck);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (!this.myServerSocket.isClosed());
        this.serverStopped();
    }

    public void serverStopped() {
    }

    public void stop() {
        try {
            Util.safeClose(this.myServerSocket);
            this.closeAllConnections();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void registerConnection(Socket socket) {
        this.openConnections.add(socket);
    }

    public synchronized void unRegisterConnection(Socket socket) {
        this.openConnections.remove(socket);
    }

    public synchronized void closeAllConnections() {
        for (Socket socket : this.openConnections) {
            Util.safeClose(socket);
        }
    }

    public final int getListeningPort() {
        return this.myServerSocket == null ? -1 : this.myServerSocket.getLocalPort();
    }

    public final boolean wasStarted() {
        return this.myServerSocket != null;
    }

    public final boolean isAlive() {
        return this.wasStarted() && !this.myServerSocket.isClosed();
    }

    @Deprecated
    public Response serve(String uri, Method method, Map<String, String> headers, Map<String, String> parms, Map<String, String> files) {
        return new Response((Response.IStatus)Response.Status.NOT_FOUND, MIME_PLAINTEXT, "Not Found");
    }

    public Response serve(IHTTPSession session) {
        Method method = session.getMethod();
        if (Method.PUT.equals((Object)method) || Method.POST.equals((Object)method)) {
            try {
                session.parseBody();
            }
            catch (IOException ioe) {
                return new Response((Response.IStatus)Response.Status.INTERNAL_ERROR, MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            }
            catch (ResponseException re) {
                return new Response((Response.IStatus)re.getStatus(), MIME_PLAINTEXT, re.getMessage());
            }
        }
        Map<String, String> parms = session.getParms();
        parms.put(QUERY_STRING_PARAMETER, session.getQueryParameterString());
        return this.serve(session.getUri(), method, session.getHeaders(), parms, null);
    }

    protected String decodePercent(String str) {
        String decoded = null;
        try {
            decoded = URLDecoder.decode(str, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    protected Map<String, List<String>> decodeParameters(Map<String, String> parms) {
        return this.decodeParameters(parms.get(QUERY_STRING_PARAMETER));
    }

    protected Map<String, List<String>> decodeParameters(String queryString) {
        HashMap<String, List<String>> parms = new HashMap<String, List<String>>();
        if (queryString != null) {
            StringTokenizer st = new StringTokenizer(queryString, "&");
            while (st.hasMoreTokens()) {
                String propertyValue;
                String propertyName;
                String e = st.nextToken();
                int sep = e.indexOf(61);
                String string = propertyName = sep >= 0 ? this.decodePercent(e.substring(0, sep)).trim() : this.decodePercent(e).trim();
                if (!parms.containsKey(propertyName)) {
                    parms.put(propertyName, new ArrayList());
                }
                if ((propertyValue = sep >= 0 ? this.decodePercent(e.substring(sep + 1)) : null) == null) continue;
                ((List)parms.get(propertyName)).add(propertyValue);
            }
        }
        return parms;
    }

    protected class HTTPSession
    implements IHTTPSession {
        public static final int BUFSIZE = 8192;
        private final OutputStream outputStream;
        private PushbackInputStream inputStream;
        private InputStream wrappedInput;
        private int splitbyte;
        private int rlen;
        private Method method;
        private Map<String, String> parms;
        private Map<String, String> headers;
        private String queryParameterString;
        private String remoteIp;
        private boolean doClose;

        public HTTPSession(InputStream inputStream, OutputStream outputStream, InetAddress inetAddress) {
            this.inputStream = new PushbackInputStream(inputStream, 8192);
            this.outputStream = outputStream;
            this.remoteIp = inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() ? "127.0.0.1" : inetAddress.getHostAddress().toString();
            this.headers = new HashMap<String, String>();
            this.parms = new HashMap<String, String>();
        }

        @Override
        public void execute() throws IOException {
            this.doClose = true;
            try {
                Response r;
                byte[] buf = new byte[8192];
                this.splitbyte = 0;
                this.rlen = 0;
                int read = -1;
                read = this.inputStream.read(buf, 0, 8192);
                if (read == -1) {
                    throw new SocketException("NanoHttpd Shutdown");
                }
                while (read > 0) {
                    this.rlen += read;
                    this.splitbyte = this.findHeaderEnd(buf, this.rlen);
                    if (this.splitbyte > 0 || this.rlen >= 8192) break;
                    read = this.inputStream.read(buf, this.rlen, 8192 - this.rlen);
                    if (NanoHTTPD.this.maxRequestSize == 0 || this.rlen <= NanoHTTPD.this.maxRequestSize) continue;
                    throw new SocketException("Request too large");
                }
                if (this.splitbyte == 0) {
                    throw new SocketException("Connection closed");
                }
                if (this.splitbyte < this.rlen) {
                    this.inputStream.unread(buf, this.splitbyte, this.rlen - this.splitbyte);
                }
                this.parms.clear();
                this.headers.clear();
                if (null != this.remoteIp) {
                    this.headers.put("remote-addr", this.remoteIp);
                    this.headers.put("http-client-ip", this.remoteIp);
                }
                BufferedReader hin = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf, 0, this.splitbyte)));
                this.decodeHeader(hin, this.parms, this.headers);
                if (!Util.isEmptyString(this.headers.get("trailer"))) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Trailers not supported.");
                }
                this.method = Method.lookup(this.headers.get("http-method"));
                if (this.method == null) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error.");
                }
                boolean bl = this.doClose = "close".equalsIgnoreCase(this.headers.get("connection")) || "1.0".equals(this.headers.get("http-version"));
                if (!(this.doClose || this.method == Method.GET || this.headers.containsKey("content-length") || "chunked".equals(this.headers.get("transfer-encoding")))) {
                    this.doClose = true;
                }
                if ((r = NanoHTTPD.this.serve(this)) == null) {
                    throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                }
                r.setRequestMethod(this.method);
                r.send(this.outputStream, this.doClose);
                if (this.doClose) {
                    Util.safeClose(this.outputStream, this.inputStream);
                } else {
                    InputStream is = this.getInputStream();
                    if (is != null) {
                        while (is.read(buf) > 0) {
                        }
                    }
                }
            }
            catch (SocketException e) {
                throw e;
            }
            catch (SocketTimeoutException ste) {
                throw ste;
            }
            catch (IOException ioe) {
                Response r = new Response((Response.IStatus)Response.Status.INTERNAL_ERROR, NanoHTTPD.MIME_PLAINTEXT, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                r.send(this.outputStream, this.doClose);
                Util.safeClose(this.outputStream);
            }
            catch (ResponseException re) {
                Response r = new Response((Response.IStatus)re.getStatus(), NanoHTTPD.MIME_PLAINTEXT, re.getMessage());
                r.send(this.outputStream, this.doClose);
                Util.safeClose(this.outputStream);
            }
        }

        @Override
        public void parseBody() throws IOException, ResponseException {
            InputStream is;
            if (this.method != Method.POST) {
                return;
            }
            long size = this.headers.containsKey("content-length") ? (long)Util.parseInt(this.headers.get("content-length"), -1) : -1L;
            String contentType = null;
            String contentEncoding = null;
            String contentTypeHeader = this.headers.get("content-type");
            StringTokenizer st = null;
            if (contentTypeHeader != null && (st = new StringTokenizer(contentTypeHeader, ",")).hasMoreTokens()) {
                String[] part = st.nextToken().split(";\\s*", 2);
                contentType = part[0].trim();
                if (part.length == 2) {
                    contentEncoding = part[1];
                }
            }
            Charset cs = StandardCharsets.UTF_8;
            if (contentEncoding != null) {
                try {
                    cs = Charset.forName(contentEncoding);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((is = this.getInputStream()) == null) {
                return;
            }
            if ("multipart/form-data".equalsIgnoreCase(contentType)) {
                throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Content type is multipart/form-data, which is not supported");
            }
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                int ret;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] pbuf = new byte[2000];
                while (size > 0L && (ret = is.read(pbuf, 0, (int)Math.min(size, (long)pbuf.length))) > 0 && (ret < 2 || pbuf[ret - 1] != 10 || pbuf[ret - 2] != 13)) {
                    size -= (long)ret;
                    baos.write(pbuf, 0, ret);
                }
                String postLine = new String(baos.toByteArray(), cs);
                baos.close();
                this.decodeParms(postLine, this.parms);
            }
        }

        private void decodeHeader(BufferedReader in, Map<String, String> parms, Map<String, String> headers) throws ResponseException {
            try {
                String inLine = in.readLine();
                if (inLine == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(inLine);
                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                String strMethod = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new ResponseException(Response.Status.BAD_REQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                String uri = st.nextToken();
                int qmi = uri.indexOf(63);
                if (qmi >= 0) {
                    this.decodeParms(uri.substring(qmi + 1), parms);
                    uri = NanoHTTPD.this.decodePercent(uri.substring(0, qmi));
                } else {
                    uri = NanoHTTPD.this.decodePercent(uri);
                }
                if (st.hasMoreTokens()) {
                    String strVersion = st.nextToken();
                    String line = in.readLine();
                    while (line != null && line.length() > 0) {
                        int p = line.indexOf(58);
                        if (p >= 0) {
                            headers.put(line.substring(0, p).trim().toLowerCase(Locale.US), line.substring(p + 1).trim());
                        }
                        line = in.readLine();
                    }
                    int sl = strVersion.indexOf(47);
                    if (sl != -1) {
                        headers.put("http-version", strVersion.substring(sl + 1));
                    }
                }
                headers.put("http-uri", uri);
                headers.put("http-method", strMethod);
            }
            catch (IOException ioe) {
                throw new ResponseException(Response.Status.INTERNAL_ERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage(), ioe);
            }
        }

        private int findHeaderEnd(byte[] buf, int rlen) {
            int splitbyte = 0;
            while (splitbyte + 3 < rlen) {
                if (buf[splitbyte] == 13 && buf[splitbyte + 1] == 10 && buf[splitbyte + 2] == 13 && buf[splitbyte + 3] == 10) {
                    return splitbyte + 4;
                }
                ++splitbyte;
            }
            return -1;
        }

        private void decodeParms(String parms, Map<String, String> p) {
            if (parms == null) {
                this.queryParameterString = "";
                return;
            }
            this.queryParameterString = parms;
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                if (sep >= 0) {
                    p.put(NanoHTTPD.this.decodePercent(e.substring(0, sep)).trim(), NanoHTTPD.this.decodePercent(e.substring(sep + 1)));
                    continue;
                }
                p.put(NanoHTTPD.this.decodePercent(e).trim(), "");
            }
        }

        @Override
        public final Map<String, String> getParms() {
            return this.parms;
        }

        @Override
        public String getQueryParameterString() {
            return this.queryParameterString;
        }

        @Override
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public final String getUri() {
            return this.headers.get("http-uri");
        }

        @Override
        public final Method getMethod() {
            return this.method;
        }

        @Override
        public final InputStream getInputStream() {
            if (this.method == Method.GET) {
                return null;
            }
            if (this.wrappedInput == null) {
                String s = this.headers.get("content-length");
                if (s != null) {
                    long cl = Util.parseLong(s, -1L);
                    if (cl == 0L) {
                        return null;
                    }
                    if (cl < 0L) {
                        this.doClose = true;
                        return null;
                    }
                    BoundedInputStream bis = new BoundedInputStream((InputStream)this.inputStream, cl);
                    bis.setPropagateClose(false);
                    this.wrappedInput = bis;
                    return this.wrappedInput;
                }
                s = this.headers.get("transfer-encoding");
                if (s != null && "chunked".equalsIgnoreCase(s.trim())) {
                    this.wrappedInput = new ChunkedInputStream(this.inputStream);
                    return this.wrappedInput;
                }
            } else {
                return this.wrappedInput;
            }
            if (!this.doClose) {
                return null;
            }
            return this.inputStream;
        }
    }

    public static interface IHTTPSession {
        public void execute() throws IOException;

        public Map<String, String> getParms();

        public Map<String, String> getHeaders();

        public String getUri();

        public String getQueryParameterString();

        public Method getMethod();

        public InputStream getInputStream();

        public void parseBody() throws IOException, ResponseException;
    }

    public static final class ResponseException
    extends Exception {
        private static final long serialVersionUID = 6569838532917408380L;
        private final Response.Status status;

        public ResponseException(Response.Status status, String message) {
            super(message);
            this.status = status;
        }

        public ResponseException(Response.Status status, String message, Exception e) {
            super(message, e);
            this.status = status;
        }

        public Response.Status getStatus() {
            return this.status;
        }
    }

    public static class Response {
        private IStatus status;
        private String mimeType;
        private InputStream data;
        private final Map<String, String> header = new HashMap<String, String>();
        private Method requestMethod;
        private boolean chunkedTransfer;
        private static final ThreadLocal<SimpleDateFormat> headerDateFormatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'");
            }
        };
        private static final byte[] CRLF = "\r\n".getBytes();
        private static final byte[] CHUNKED_END = "0\r\n\r\n".getBytes();
        private static final int BUFFER_SIZE = 262144;

        public Response(String msg) {
            this((IStatus)Status.OK, NanoHTTPD.MIME_HTML, msg);
        }

        public Response(IStatus status, String mimeType, InputStream data, boolean chunked) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
            this.chunkedTransfer = chunked;
        }

        public Response(IStatus status, String mimeType, InputStream data) {
            this(status, mimeType, data, !(data instanceof ByteArrayInputStream));
        }

        public Response(IStatus status, String mimeType, byte[] data) {
            this(status, mimeType, data == null ? null : new ByteArrayInputStream(data));
        }

        public Response(IStatus status, String mimeType, String txt) {
            this(status, mimeType, txt == null ? null : txt.getBytes(StandardCharsets.UTF_8));
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }

        public String getHeader(String name) {
            return this.header.get(name);
        }

        protected void send(OutputStream outputStream, boolean close) throws IOException {
            String mime = this.mimeType;
            StringBuilder sb = new StringBuilder();
            if (this.status == null) {
                throw new Error("sendResponse(): Status can't be null.");
            }
            sb.append("HTTP/1.1 ");
            sb.append(this.status.getDescription());
            sb.append("\r\n");
            if (mime != null) {
                sb.append("Content-Type: ");
                sb.append(mime);
                sb.append("\r\n");
            }
            if (this.header.get("Date") == null) {
                sb.append("Date: ");
                sb.append(headerDateFormatter.get().format(System.currentTimeMillis()));
                sb.append("\r\n");
            }
            for (Map.Entry<String, String> item : this.header.entrySet()) {
                sb.append(item.getKey());
                sb.append(": ");
                sb.append(item.getValue());
                sb.append("\r\n");
            }
            this.sendConnectionHeaderIfNotAlreadyPresent(sb, this.header, close);
            if (this.requestMethod != Method.HEAD && this.chunkedTransfer) {
                this.sendAsChunked(outputStream, sb);
            } else {
                int pending = this.data != null ? this.data.available() : 0;
                pending = this.sendContentLengthHeaderIfNotAlreadyPresent(sb, this.header, pending);
                sb.append("\r\n");
                outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                sb.setLength(0);
                this.sendAsFixedLength(outputStream, pending);
            }
            if (sb.length() != 0) {
                outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            }
            Util.safeClose(this.data);
        }

        protected int sendContentLengthHeaderIfNotAlreadyPresent(StringBuilder sb, Map<String, String> header, int size) {
            for (String headerName : header.keySet()) {
                if (!headerName.equalsIgnoreCase("content-length")) continue;
                try {
                    return Integer.parseInt(header.get(headerName));
                }
                catch (NumberFormatException ex) {
                    return size;
                }
            }
            sb.append("Content-Length: ");
            sb.append(size);
            sb.append("\r\n");
            return size;
        }

        protected void sendConnectionHeaderIfNotAlreadyPresent(StringBuilder sb, Map<String, String> header, boolean close) {
            if (close) {
                if (!this.headerAlreadySent(header, "connection")) {
                    sb.append("Connection: close\r\n");
                }
                return;
            }
            if (!this.headerAlreadySent(header, "connection")) {
                sb.append("Connection: keep-alive\r\n");
            }
            if (!this.headerAlreadySent(header, "keep-alive")) {
                sb.append("Keep-Alive: timeout=");
                sb.append(9);
                sb.append("\r\n");
            }
        }

        private boolean headerAlreadySent(Map<String, String> header, String name) {
            for (String headerName : header.keySet()) {
                if (!headerName.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        private void sendAsChunked(OutputStream outputStream, StringBuilder sb) throws IOException {
            int read;
            sb.append("Transfer-Encoding: chunked\r\n");
            sb.append("\r\n");
            outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            sb.setLength(0);
            byte[] buff = new byte[262144];
            while ((read = this.data.read(buff)) > 0) {
                outputStream.write(String.format("%x\r\n", read).getBytes());
                outputStream.write(buff, 0, read);
                outputStream.write(CRLF);
            }
            outputStream.write(CHUNKED_END);
        }

        private void sendAsFixedLength(OutputStream outputStream, int pending) throws IOException {
            if (this.requestMethod != Method.HEAD && this.data != null) {
                int read;
                int BUFFER_SIZE = 16384;
                byte[] buff = new byte[BUFFER_SIZE];
                while (pending > 0 && (read = this.data.read(buff, 0, pending > BUFFER_SIZE ? BUFFER_SIZE : pending)) > 0) {
                    outputStream.write(buff, 0, read);
                    pending -= read;
                }
            }
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public InputStream getData() {
            return this.data;
        }

        public void setData(InputStream data) {
            this.data = data;
        }

        public Method getRequestMethod() {
            return this.requestMethod;
        }

        public void setRequestMethod(Method requestMethod) {
            this.requestMethod = requestMethod;
        }

        public void setChunkedTransfer(boolean chunkedTransfer) {
            this.chunkedTransfer = chunkedTransfer;
        }

        public static enum Status implements IStatus
        {
            SWITCH_PROTOCOL(101, "Switching Protocols"),
            OK(200, "OK"),
            CREATED(201, "Created"),
            ACCEPTED(202, "Accepted"),
            NO_CONTENT(204, "No Content"),
            PARTIAL_CONTENT(206, "Partial Content"),
            REDIRECT(301, "Moved Permanently"),
            NOT_MODIFIED(304, "Not Modified"),
            BAD_REQUEST(400, "Bad Request"),
            UNAUTHORIZED(401, "Unauthorized"),
            FORBIDDEN(403, "Forbidden"),
            NOT_FOUND(404, "Not Found"),
            METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
            RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
            INTERNAL_ERROR(500, "Internal Server Error"),
            SERVICE_UNAVAILABLE(503, "Service Unavailable");

            private final int requestStatus;
            private final String description;

            private Status(int requestStatus, String description) {
                this.requestStatus = requestStatus;
                this.description = description;
            }

            @Override
            public int getRequestStatus() {
                return this.requestStatus;
            }

            @Override
            public String getDescription() {
                return "" + this.requestStatus + " " + this.description;
            }
        }

        public static interface IStatus {
            public int getRequestStatus();

            public String getDescription();
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        OPTIONS;


        static Method lookup(String method) {
            for (Method m : Method.values()) {
                if (!m.toString().equalsIgnoreCase(method)) continue;
                return m;
            }
            return null;
        }
    }
}

