/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.finger;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.SocketClient;

public class FingerClient
extends SocketClient {
    public static final int DEFAULT_PORT = 79;
    private static final String LONG_FLAG = "/W ";

    public FingerClient() {
        this.setDefaultPort(79);
    }

    public InputStream getInputStream(boolean longOutput) throws IOException {
        return this.getInputStream(longOutput, "");
    }

    public InputStream getInputStream(boolean longOutput, String user) throws IOException {
        return this.getInputStream(longOutput, user, null);
    }

    public InputStream getInputStream(boolean longOutput, String user, String encoding) throws IOException {
        StringBuilder buffer = new StringBuilder(64);
        if (longOutput) {
            buffer.append(LONG_FLAG);
        }
        buffer.append(user);
        buffer.append("\r\n");
        byte[] encodedQuery = buffer.toString().getBytes(Charsets.toCharset(encoding));
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(this.checkOpenOutputStream(), 1024));
        output.write(encodedQuery, 0, encodedQuery.length);
        output.flush();
        return this._input_;
    }

    public String query(boolean longOutput) throws IOException {
        return this.query(longOutput, "");
    }

    public String query(boolean longOutput, String user) throws IOException {
        return IOUtils.toString(() -> this.getInputStream(longOutput, user), this.getCharset());
    }
}

