/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.openslx.bwlp.sat.RuntimeConfig;
import org.openslx.bwlp.sat.StorageUseCheck;
import org.openslx.bwlp.sat.SupportedFeatures;
import org.openslx.bwlp.sat.database.Updater;
import org.openslx.bwlp.sat.database.mappers.DbConfiguration;
import org.openslx.bwlp.sat.database.mappers.DbUser;
import org.openslx.bwlp.sat.fileserv.FileServer;
import org.openslx.bwlp.sat.maintenance.DeleteOldImages;
import org.openslx.bwlp.sat.maintenance.DeleteOldLectures;
import org.openslx.bwlp.sat.maintenance.DeleteOldUsers;
import org.openslx.bwlp.sat.maintenance.MailFlusher;
import org.openslx.bwlp.sat.maintenance.SendExpireWarning;
import org.openslx.bwlp.sat.thrift.BinaryListener;
import org.openslx.bwlp.sat.thrift.JsonHttpListener;
import org.openslx.bwlp.sat.thrift.cache.OperatingSystemList;
import org.openslx.bwlp.sat.thrift.cache.OrganizationList;
import org.openslx.bwlp.sat.thrift.cache.VirtualizerList;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.sat.util.Identity;
import org.openslx.bwlp.sat.web.WebServer;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvalidTokenException;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.AppUtil;
import org.openslx.util.CascadedThreadPoolExecutor;
import org.openslx.util.QuickTimer;

public class App {
    private static Logger LOGGER = LogManager.getLogger(App.class);
    private static final String NAME = "bwLehrpool-Server";
    private static final Set<String> failFastMethods = new HashSet<String>();

    public static void main(String[] args) throws TTransportException, NoSuchAlgorithmException, IOException, KeyManagementException {
        System.setProperty("mariadb.logging.disable", "true");
        if (((org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(LogManager.getRootLogger())).getAppenders().isEmpty()) {
            Configurator.initialize(new DefaultConfiguration());
        }
        try {
            LOGGER.info("Loading configuration");
            Configuration.load();
        }
        catch (Exception e1) {
            LOGGER.fatal("Could not load configuration", (Throwable)e1);
            System.exit(1);
        }
        AppUtil.logHeader(LOGGER, NAME, App.class.getPackage().getImplementationVersion());
        AppUtil.logProperty(LOGGER, "rpc.version", Long.toString(5L));
        AppUtil.logProperty(LOGGER, "server.features", SupportedFeatures.getFeatureString());
        try {
            Updater.updateDatabase();
            RuntimeConfig.get();
            DbConfiguration.updateMailTemplates(false);
        }
        catch (SQLException e1) {
            LOGGER.fatal("Updating/checking the database layout failed.");
            return;
        }
        if (Identity.loadCertificate() == null) {
            LOGGER.error("Could not set up TLS/SSL requirements, exiting");
            System.exit(1);
        }
        failFastMethods.add("getVirtualizers");
        failFastMethods.add("getOperatingSystems");
        failFastMethods.add("getOrganizations");
        ThriftManager.setMasterErrorCallback(new ThriftManager.ErrorCallback(){

            @Override
            public boolean thriftError(int failCount, String method, Throwable t) {
                if (failFastMethods.contains(method)) {
                    return t != null && failCount <= 1;
                }
                if (failCount > 2 || t == null) {
                    LOGGER.warn("Thrift Client error for " + method + ", FAIL.");
                    return false;
                }
                if (t instanceof TInvalidTokenException || t instanceof TAuthorizationException || !(t instanceof TException)) {
                    return false;
                }
                if (((TException)t).getCause() == null) {
                    LOGGER.info("Thrift error " + t.toString() + " for " + method + ", retrying...");
                } else {
                    LOGGER.info("Thrift error " + ((TException)t).getCause().toString() + " for " + method + ", retrying...");
                }
                try {
                    Thread.sleep(failCount * 250);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
        });
        SSLContext ctx = null;
        if (Configuration.getMasterServerSsl()) {
            ctx = Configuration.getMasterServerSslContext();
        }
        ThriftManager.setMasterServerAddress(ctx, Configuration.getMasterServerAddress(), Configuration.getMasterServerPort(), 30000);
        if (VirtualizerList.get() == null || VirtualizerList.get().isEmpty()) {
            LOGGER.fatal("Could not get initial virtualizer list from master server. Please make sure this server can connect to the internet.");
            return;
        }
        if (OrganizationList.get() == null || OrganizationList.get().isEmpty()) {
            LOGGER.fatal("Could not get initial organization list from master server. Please make sure this server can connect to the internet.");
            return;
        }
        if (OperatingSystemList.get() == null || OperatingSystemList.get().isEmpty()) {
            LOGGER.fatal("Could not get initial operating system list from master server. Please make sure this server can connect to the internet.");
            return;
        }
        QuickTimer.scheduleAtFixedDelay(new QuickTimer.Task(){

            @Override
            public void fire() {
                VirtualizerList.get();
                OperatingSystemList.get();
                OrganizationList.get();
            }
        }, 3601000L, 10803000L);
        if (!FileServer.instance().start()) {
            LOGGER.error("Could not start internal file server.");
            return;
        }
        QuickTimer.scheduleAtFixedDelay(new StorageUseCheck(), 10000L, 60000L);
        DbUser.checkIfLegacyUsersExist();
        DeleteOldImages.init();
        SendExpireWarning.init();
        MailFlusher.init();
        DeleteOldLectures.init();
        DeleteOldUsers.init();
        CascadedThreadPoolExecutor tpe = new CascadedThreadPoolExecutor(1, 8, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), "Thr-Plain");
        Thread t = new Thread((Runnable)new BinaryListener(9090, false, tpe), "Thr-Plain:9090");
        t.setDaemon(true);
        t.start();
        tpe = new CascadedThreadPoolExecutor(2, 8, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), "Thr-SSL");
        t = new Thread((Runnable)new BinaryListener(9091, true, tpe), "Thr-SSL:9091");
        t.start();
        tpe = new CascadedThreadPoolExecutor(2, 16, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), "RPC-http");
        t = new Thread((Runnable)new WebServer(9080, tpe), "RPC-httpd:9080");
        t.setDaemon(true);
        t.start();
        tpe = new CascadedThreadPoolExecutor(6, 12, 1L, TimeUnit.MINUTES, 3, "Thr-http");
        tpe.allowCoreThreadTimeOut(true);
        t = new Thread((Runnable)new JsonHttpListener(9081, tpe), "Thr-httpd:9081");
        t.setDaemon(true);
        t.start();
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

            @Override
            public void run() {
                QuickTimer.cancel();
                LOGGER.info("All services and workers shut down, exiting...");
            }
        });
    }
}

