/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.util.QuickTimer;

public class StorageUseCheck
extends QuickTimer.Task {
    private static final Logger LOGGER = LogManager.getLogger(StorageUseCheck.class);
    private final String uuid = UUID.randomUUID().toString();
    private final File canary = new File(Configuration.getVmStoreProdPath(), "dozmod.lock");
    private boolean created = false;

    public StorageUseCheck() {
        if (FileSystem.waitForStorage()) {
            this.createCanary();
        }
    }

    private void createCanary() {
        if (!FileSystem.isStorageMounted()) {
            LOGGER.warn("Cannot check storage lock, storage not mounted");
            return;
        }
        if (!this.created || !this.canary.exists()) {
            try {
                FileUtils.write(this.canary, (CharSequence)this.uuid, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOGGER.fatal("Cannot write lock file to VMStore", (Throwable)e);
                System.exit(1);
            }
            this.created = true;
        } else {
            String canaryContents;
            try {
                canaryContents = FileUtils.readFileToString(this.canary, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOGGER.warn("Lock file cannot be accessed. Cannot ensure exclusive use of VMStore", (Throwable)e);
                return;
            }
            if (!canaryContents.equals(this.uuid)) {
                LOGGER.fatal("Lock file content changed. Another server instance is using the VMStore. Will exit immediately to prevent any damages.");
                try {
                    FileUtils.write(this.canary, (CharSequence)this.uuid, StandardCharsets.UTF_8);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(1);
            }
        }
    }

    @Override
    public void fire() {
        this.createCanary();
    }
}

