/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat;

import org.openslx.bwlp.sat.database.mappers.DbHelper;
import org.openslx.sat.thrift.version.Feature;

public class SupportedFeatures {
    private static String supportedFeatures = null;

    public static String getFeatureString() {
        return supportedFeatures;
    }

    private static void registerFeature(Feature feature) {
        supportedFeatures = supportedFeatures == null ? feature.name() : supportedFeatures + " " + feature.name();
    }

    private static void registerFeatureIf(Feature feature) {
        switch (feature) {
            case DOCKER_CONTAINER: {
                if (!DbHelper.isDockerContainerAvailable()) break;
                SupportedFeatures.registerFeature(feature);
                break;
            }
        }
    }

    static {
        SupportedFeatures.registerFeature(Feature.EXTEND_EXPIRED_VM);
        SupportedFeatures.registerFeature(Feature.NETWORK_SHARES);
        SupportedFeatures.registerFeature(Feature.MULTIPLE_HYPERVISORS);
        SupportedFeatures.registerFeature(Feature.SERVER_SIDE_COPY);
        SupportedFeatures.registerFeature(Feature.LECTURE_FILTER_LDAP);
        SupportedFeatures.registerFeature(Feature.CONFIGURE_USB);
        SupportedFeatures.registerFeatureIf(Feature.DOCKER_CONTAINER);
    }
}

