/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.util.Configuration;

public class Database {
    private static final Logger LOGGER = LogManager.getLogger(Database.class);
    private static final Queue<MysqlConnection> pool = new ConcurrentLinkedQueue<MysqlConnection>();
    private static final Set<MysqlConnection> busyConnections = Collections.newSetFromMap(new ConcurrentHashMap());

    public static MysqlConnection getConnection() {
        MysqlConnection con;
        while ((con = pool.poll()) != null) {
            if (!con.isValid()) {
                con.release();
                continue;
            }
            if (!busyConnections.add(con)) {
                throw new RuntimeException("Tried to hand out a busy connection!");
            }
            try {
                con.setAutoCommit(false);
                return con;
            }
            catch (SQLException e) {
                con.release();
            }
        }
        if (busyConnections.size() > 20) {
            LOGGER.warn("Too many open MySQL connections. Possible connection leak!");
            return null;
        }
        try {
            Connection rawConnection = DriverManager.getConnection(Configuration.getDbUri() + "&permitMysqlScheme", Configuration.getDbUsername(), Configuration.getDbPassword());
            rawConnection.setAutoCommit(false);
            con = new MysqlConnection(rawConnection);
            if (!busyConnections.add(con)) {
                throw new RuntimeException("Tried to hand out a busy connection!");
            }
            return con;
        }
        catch (SQLException e) {
            LOGGER.info("Failed to connect to local mysql server", (Throwable)e);
            return null;
        }
    }

    static void returnConnection(MysqlConnection connection) {
        if (!busyConnections.remove(connection)) {
            throw new RuntimeException("Tried to return a mysql connection to the pool that was not taken!");
        }
        pool.add(connection);
    }

    public static void printCharsetInformation() {
        LOGGER.info("MySQL charset related variables:");
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("SHOW VARIABLES LIKE :what");
            stmt.setString("what", "char%");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                LOGGER.info(rs.getString("Variable_name") + ": " + rs.getString("Value"));
            }
            stmt.setString("what", "collat%");
            rs = stmt.executeQuery();
            while (rs.next()) {
                LOGGER.info(rs.getString("Variable_name") + ": " + rs.getString("Value"));
            }
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Database.printCharsetInformation()", (Throwable)e);
        }
        LOGGER.info("End of variables");
    }

    public static void printDebug() {
        LOGGER.info("Available: " + pool.size());
        LOGGER.info("Busy: " + busyConnections.size());
    }

    static {
        try {
            Class.forName("org.mariadb.jdbc.Driver").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.fatal("Cannot get mysql JDBC driver!", (Throwable)e);
            System.exit(1);
        }
    }
}

