/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlStatement;

public class MysqlConnection
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger(MysqlConnection.class);
    private static final int CONNECTION_TIMEOUT_MS = 300000;
    private final long deadline = System.currentTimeMillis() + 300000L;
    private final Connection rawConnection;
    private boolean hasPendingQueries = false;
    private List<MysqlStatement> openStatements = new ArrayList<MysqlStatement>();

    MysqlConnection(Connection rawConnection) {
        this.rawConnection = rawConnection;
    }

    public MysqlStatement prepareStatement(String sql) throws SQLException {
        if (!(sql.startsWith("SELECT") || sql.startsWith("DESCRIBE") || sql.startsWith("SHOW"))) {
            this.hasPendingQueries = true;
        }
        MysqlStatement statement = new MysqlStatement(this.rawConnection, sql);
        this.openStatements.add(statement);
        return statement;
    }

    public void commit() throws SQLException {
        this.rawConnection.commit();
        this.hasPendingQueries = false;
    }

    public void rollback() throws SQLException {
        this.rawConnection.rollback();
        this.hasPendingQueries = false;
    }

    boolean isValid() {
        return System.currentTimeMillis() < this.deadline;
    }

    @Override
    public void close() {
        if (this.hasPendingQueries) {
            LOGGER.warn("Mysql connection had uncommited queries on .close()", (Throwable)new RuntimeException("Stack trace"));
            for (MysqlStatement s : this.openStatements) {
                LOGGER.info(s.getQuery());
            }
            this.hasPendingQueries = false;
        }
        try {
            this.rawConnection.rollback();
        }
        catch (SQLException e) {
            LOGGER.warn("Rolling back uncommited queries failed!", (Throwable)e);
        }
        if (!this.openStatements.isEmpty()) {
            for (MysqlStatement statement : this.openStatements) {
                statement.close();
            }
            this.openStatements.clear();
        }
        try {
            this.rawConnection.rollback();
            this.rawConnection.setAutoCommit(true);
        }
        catch (SQLException e) {
            LOGGER.warn("Rolling back uncommited queries failed!", (Throwable)e);
        }
        Database.returnConnection(this);
    }

    void release() {
        try {
            this.rawConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setAutoCommit(boolean b) throws SQLException {
        this.rawConnection.setAutoCommit(b);
    }
}

