/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MysqlStatement
implements Closeable {
    private static final QueryCache cache = new QueryCache();
    private final PreparsedQuery query;
    private final PreparedStatement statement;
    private final List<ResultSet> openResultSets = new ArrayList<ResultSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MysqlStatement(Connection con, String sql) throws SQLException {
        PreparsedQuery query;
        QueryCache queryCache = cache;
        synchronized (queryCache) {
            query = (PreparsedQuery)cache.get(sql);
        }
        if (query == null) {
            query = MysqlStatement.parse(sql);
            queryCache = cache;
            synchronized (queryCache) {
                cache.put(sql, query);
            }
        }
        this.query = query;
        this.statement = con.prepareStatement(query.sql, 1);
    }

    public String getQuery() {
        return this.query.sql;
    }

    private List<Integer> getIndexes(String name) {
        List indexes = (List)this.query.indexMap.get(name);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter not found: " + name);
        }
        return indexes;
    }

    public void setObject(String name, Object value) throws SQLException {
        List<Integer> indexes = this.getIndexes(name);
        for (Integer index : indexes) {
            this.statement.setObject(index, value);
        }
    }

    public void setString(String name, String value) throws SQLException {
        List<Integer> indexes = this.getIndexes(name);
        for (Integer index : indexes) {
            this.statement.setString(index, value);
        }
    }

    public void setInt(String name, int value) throws SQLException {
        List<Integer> indexes = this.getIndexes(name);
        for (Integer index : indexes) {
            this.statement.setInt(index, value);
        }
    }

    public void setLong(String name, long value) throws SQLException {
        List<Integer> indexes = this.getIndexes(name);
        for (Integer index : indexes) {
            this.statement.setLong(index, value);
        }
    }

    public void setBoolean(String name, boolean value) throws SQLException {
        List<Integer> indexes = this.getIndexes(name);
        for (Integer index : indexes) {
            this.statement.setBoolean(index, value);
        }
    }

    public void setBinary(String name, byte[] value) throws SQLException {
        List<Integer> indexes = this.getIndexes(name);
        for (Integer index : indexes) {
            this.statement.setBytes(index, value);
        }
    }

    public boolean execute() throws SQLException {
        return this.statement.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet rs = this.statement.executeQuery();
        this.openResultSets.add(rs);
        return rs;
    }

    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet rs = this.statement.getGeneratedKeys();
        this.openResultSets.add(rs);
        return rs;
    }

    public int lastInsertId() throws SQLException {
        int result = -1;
        try (ResultSet rs = this.statement.getGeneratedKeys();){
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        return result;
    }

    @Override
    public void close() {
        for (ResultSet rs : this.openResultSets) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {}
        }
        try {
            this.statement.cancel();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    private static PreparsedQuery parse(String query) {
        int length = query.length();
        StringBuffer parsedQuery = new StringBuffer(length);
        HashMap<String, List<Integer>> paramMap = new HashMap<String, List<Integer>>();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean hasBackslash = false;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            int c = query.charAt(i);
            if (hasBackslash) {
                hasBackslash = false;
            } else if (c == 92) {
                hasBackslash = true;
            } else if (inSingleQuote) {
                if (c == 39) {
                    inSingleQuote = false;
                }
            } else if (inDoubleQuote) {
                if (c == 34) {
                    inDoubleQuote = false;
                }
            } else if (c == 39) {
                inSingleQuote = true;
            } else if (c == 34) {
                inDoubleQuote = true;
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                int j;
                for (j = i + 2; j < length && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
                }
                String name = query.substring(i + 1, j);
                c = 63;
                i += name.length();
                ArrayList<Integer> indexList = (ArrayList<Integer>)paramMap.get(name);
                if (indexList == null) {
                    indexList = new ArrayList<Integer>();
                    paramMap.put(name, indexList);
                }
                indexList.add(index);
                ++index;
            }
            parsedQuery.append((char)c);
        }
        return new PreparsedQuery(parsedQuery.toString(), paramMap);
    }

    private static class QueryCache
    extends LinkedHashMap<String, PreparsedQuery> {
        private static final long serialVersionUID = 1L;

        public QueryCache() {
            super(30, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PreparsedQuery> eldest) {
            return this.size() > 40;
        }
    }

    private static class PreparsedQuery {
        private final Map<String, List<Integer>> indexMap;
        private final String sql;

        public PreparsedQuery(String sql, Map<String, List<Integer>> indexMap) {
            this.sql = sql;
            this.indexMap = indexMap;
        }
    }
}

