/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;

public class Updater {
    private static final Logger LOGGER = LogManager.getLogger(Updater.class);

    public static void updateDatabase() throws SQLException {
        Updater.addLocationPrivateField();
        Updater.addLectureLocationMapTable();
        Updater.addHasUsbAccessField();
        Updater.addLogTable();
        Updater.fixEmailFieldLength();
        Updater.addNetworkShares();
        Updater.addLectureFilter();
        Updater.addPredefinedFilters();
        Updater.addPredefinedNetworkShares();
        Updater.addPredefinedRunScripts();
        Updater.addPredefinedNetworkRules();
    }

    private static void addLectureLocationMapTable() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (Updater.tableExists(connection, "lecture_x_location")) {
                return;
            }
            MysqlStatement tableAddStmt = connection.prepareStatement("CREATE TABLE `lecture_x_location` ( `lectureid` char(36) CHARACTER SET ascii COLLATE ascii_bin NOT NULL, `locationid` int(11) NOT NULL, PRIMARY KEY (`lectureid`,`locationid`), KEY locationid (locationid) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            tableAddStmt.executeUpdate();
            MysqlStatement constraintStmt = connection.prepareStatement("ALTER TABLE `lecture_x_location` ADD FOREIGN KEY ( `lectureid` ) REFERENCES `sat`.`lecture` (`lectureid`) ON DELETE CASCADE ON UPDATE CASCADE");
            constraintStmt.executeUpdate();
            connection.commit();
            LOGGER.info("Updated database: Added lecture-location mapping table");
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addLectureLocationMapTable()", (Throwable)e);
            throw e;
        }
    }

    private static void addLocationPrivateField() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (Updater.getColumnType(connection, "lecture", "islocationprivate") != null) {
                return;
            }
            MysqlStatement columnAddStmt = connection.prepareStatement("ALTER TABLE lecture ADD islocationprivate TINYINT(1) UNSIGNED NOT NULL DEFAULT 0 AFTER isprivate");
            columnAddStmt.executeUpdate();
            connection.commit();
            LOGGER.info("Updated database: Added is location private field in lecture table");
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addLocationPrivateField()", (Throwable)e);
            throw e;
        }
    }

    private static void addHasUsbAccessField() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (Updater.getColumnType(connection, "lecture", "hasusbaccess") != null) {
                return;
            }
            MysqlStatement columnAddStmt = connection.prepareStatement("ALTER TABLE lecture ADD hasusbaccess TINYINT(1) UNSIGNED NOT NULL DEFAULT 1 AFTER hasinternetaccess");
            columnAddStmt.executeUpdate();
            connection.commit();
            LOGGER.info("Updated database: Added 'hasusbaccess' private field in lecture table");
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addHasUsbAccessField()", (Throwable)e);
            throw e;
        }
    }

    private static void addLogTable() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (Updater.tableExists(connection, "actionlog")) {
                return;
            }
            MysqlStatement tableAddStmt = connection.prepareStatement("CREATE TABLE `actionlog` ( `actionid` int(11) NOT NULL AUTO_INCREMENT, `dateline` bigint(20) NOT NULL, `userid` char(36) CHARACTER SET ascii COLLATE ascii_bin DEFAULT NULL, `targetid` char(36) CHARACTER SET ascii COLLATE ascii_bin DEFAULT NULL, `description` varchar(500) NOT NULL, PRIMARY KEY (`actionid`), KEY userid (userid, dateline), KEY targetid (targetid, dateline), KEY dateline (dateline) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            tableAddStmt.executeUpdate();
            MysqlStatement constraintStmt = connection.prepareStatement("ALTER TABLE `actionlog` ADD FOREIGN KEY ( `userid` ) REFERENCES `sat`.`user` (`userid`) ON DELETE SET NULL ON UPDATE CASCADE");
            constraintStmt.executeUpdate();
            connection.commit();
            LOGGER.info("Updated database: Added actionlog table");
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addLogTable()", (Throwable)e);
            throw e;
        }
    }

    private static void fixEmailFieldLength() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if ("varchar(100)".equals(Updater.getColumnType(connection, "user", "email"))) {
                return;
            }
            MysqlStatement upStmt = connection.prepareStatement("ALTER TABLE user CHANGE email email VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL");
            upStmt.executeUpdate();
            connection.commit();
            LOGGER.info("Updated database: Made email field longer");
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.fixEmailFieldLength()", (Throwable)e);
            throw e;
        }
    }

    private static void addNetworkShares() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (Updater.tableExists(connection, "networkshare")) {
                return;
            }
            MysqlStatement tableAddStmt = connection.prepareStatement("CREATE TABLE `networkshare` ( `lectureid` char(36) CHARACTER SET ascii COLLATE ascii_bin NOT NULL, `sharepresetid` int(11) NULL DEFAULT NULL, `sharedata` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL, KEY `sharepresetid` (`sharepresetid`), KEY `fk_lectureid_1` (`lectureid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            tableAddStmt.executeUpdate();
            MysqlStatement constraintStmt = connection.prepareStatement("ALTER TABLE `networkshare` ADD CONSTRAINT `fk_lectureid_1` FOREIGN KEY (`lectureid`) REFERENCES `sat`.`lecture` (`lectureid`) ON DELETE CASCADE ON UPDATE CASCADE");
            constraintStmt.executeUpdate();
            connection.commit();
            LOGGER.info("Updated database: Added networkshare table");
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addNetworkShares()", (Throwable)e);
            throw e;
        }
    }

    private static void addLectureFilter() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (Updater.tableExists(connection, "lecturefilter")) {
                return;
            }
            MysqlStatement tableAddStmt = connection.prepareStatement("CREATE TABLE `lecturefilter` (  `lectureid` char(36) CHARACTER SET ascii COLLATE ascii_bin NOT NULL,  `filtertype` varchar(24) CHARACTER SET ascii NULL DEFAULT NULL,  `filterkey` varchar(24) NULL DEFAULT NULL,  `filtervalue` varchar(200) NULL DEFAULT NULL,  KEY `lectureid` (`lectureid`,`filtertype`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            tableAddStmt.executeUpdate();
            MysqlStatement constraintStmt = connection.prepareStatement("ALTER TABLE `lecturefilter` ADD  CONSTRAINT `lectureid` FOREIGN KEY (`lectureid`) REFERENCES `lecture` (`lectureid`) ON DELETE CASCADE ON UPDATE CASCADE");
            constraintStmt.executeUpdate();
            connection.commit();
            LOGGER.info("Updated database: Added lecture filter table");
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addLectureFilter()", (Throwable)e);
            throw e;
        }
    }

    private static void addPredefinedFilters() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (!Updater.tableExists(connection, "presetlecturefilter")) {
                MysqlStatement tableAddStmt = connection.prepareStatement("CREATE TABLE presetlecturefilter (      filterid int(11) NOT NULL AUTO_INCREMENT,      filtertype varchar(24) CHARACTER SET ascii NOT NULL,      filtername varchar(100) NOT NULL,      filterkey varchar(24) NOT NULL,      filtervalue varchar(200) NOT NULL,      PRIMARY KEY (filterid),      KEY (filtertype, filtername)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
                tableAddStmt.executeUpdate();
                LOGGER.info("Updated database: Added preset lecture filters");
            }
            if (Updater.getColumnType(connection, "lecturefilter", "filterpresetid") == null) {
                MysqlStatement constraintStmt = connection.prepareStatement("ALTER TABLE lecturefilter  CHANGE filtertype filtertype VARCHAR(24) CHARACTER SET ascii NULL DEFAULT NULL, CHANGE filterkey filterkey VARCHAR(24) NULL DEFAULT NULL, CHANGE filtervalue filtervalue VARCHAR(200) NULL DEFAULT NULL, ADD COLUMN filterpresetid int(11) NULL DEFAULT NULL AFTER lectureid,  ADD KEY filterpresetid (filterpresetid),  ADD CONSTRAINT `filterpresetid` FOREIGN KEY (`filterpresetid`) REFERENCES `presetlecturefilter` (`filterid`)     ON DELETE CASCADE ON UPDATE CASCADE");
                constraintStmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addPredefinedFilters()", (Throwable)e);
            throw e;
        }
    }

    private static void addPredefinedNetworkShares() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (!Updater.tableExists(connection, "presetnetworkshare")) {
                MysqlStatement addStmt = connection.prepareStatement("CREATE TABLE `presetnetworkshare` (  `shareid` int(11) NOT NULL AUTO_INCREMENT,  `sharename` varchar(100) NOT NULL,  `sharedata` varchar(500) NOT NULL,  `active` tinyint(1) NOT NULL DEFAULT '0',  PRIMARY KEY (`shareid`),  KEY sharename (`sharename`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
                addStmt.executeUpdate();
                LOGGER.info("Updated database: Added preset network shares");
            }
            if (Updater.getColumnType(connection, "networkshare", "sharepresetid") == null) {
                MysqlStatement alterStmt = connection.prepareStatement("ALTER TABLE networkshare DROP COLUMN shareid, DROP COLUMN shareuid, ADD COLUMN sharepresetid int(11) NULL DEFAULT NULL, ADD KEY sharepresetid (sharepresetid), ADD CONSTRAINT sharepresetid FOREIGN KEY (sharepresetid) REFERENCES presetnetworkshare (shareid)     ON DELETE CASCADE ON UPDATE CASCADE");
                alterStmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addPredefinedNetworkShares()", (Throwable)e);
            throw e;
        }
    }

    private static void addPredefinedRunScripts() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (!Updater.tableExists(connection, "presetrunscript")) {
                connection.prepareStatement("CREATE TABLE presetrunscript (  runscriptid int(11) NOT NULL AUTO_INCREMENT,  scriptname varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,  content text COLLATE utf8mb4_unicode_ci NOT NULL,  extension varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,  visibility tinyint(1) NOT NULL COMMENT '0 = hidden, 1 = normal, 2 = minimized',  passcreds tinyint(1) NOT NULL,  isglobal tinyint(1) NOT NULL COMMENT 'Whether to apply this script to all lectures',  PRIMARY KEY (runscriptid),  KEY isglobal (isglobal),  KEY scriptname (scriptname)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci").executeUpdate();
                LOGGER.info("Updated database: Created table presetrunscript");
            }
            if (!Updater.tableExists(connection, "presetrunscript_x_operatingsystem")) {
                connection.prepareStatement("CREATE TABLE presetrunscript_x_operatingsystem (  runscriptid int(11) NOT NULL,  osid int(11) NOT NULL,  PRIMARY KEY (runscriptid, osid),  KEY osid (osid)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci").executeUpdate();
                connection.prepareStatement("ALTER TABLE presetrunscript_x_operatingsystem  ADD CONSTRAINT osid FOREIGN KEY (osid)    REFERENCES operatingsystem (osid)    ON DELETE CASCADE ON UPDATE CASCADE,  ADD CONSTRAINT runscriptid FOREIGN KEY (runscriptid)    REFERENCES presetrunscript (runscriptid)    ON DELETE CASCADE ON UPDATE CASCADE").executeUpdate();
                LOGGER.info("Updated database: Created presetrunscript_x_operatingsystem table + constraint");
            }
            if (!Updater.tableExists(connection, "lecture_x_runscript")) {
                connection.prepareStatement("CREATE TABLE lecture_x_runscript (  lectureid char(36) CHARACTER SET ascii COLLATE ascii_bin NOT NULL,  runscriptid int(11) NOT NULL,  PRIMARY KEY (lectureid,runscriptid),  KEY runscriptid (runscriptid)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci").executeUpdate();
                connection.prepareStatement("ALTER TABLE lecture_x_runscript  ADD CONSTRAINT lecture_runscript FOREIGN KEY (lectureid)    REFERENCES lecture (lectureid)    ON DELETE CASCADE ON UPDATE CASCADE,  ADD CONSTRAINT lecture_x_runscript_ibfk_1 FOREIGN KEY (runscriptid)    REFERENCES presetrunscript (runscriptid)    ON DELETE CASCADE ON UPDATE CASCADE").executeUpdate();
                LOGGER.info("Updated database: Created lecture_x_runscript table + constraint");
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in addPredefinedRunScripts()", (Throwable)e);
            throw e;
        }
    }

    private static void addPredefinedNetworkRules() throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            if (!Updater.tableExists(connection, "presetnetworkrule")) {
                MysqlStatement addStmt = connection.prepareStatement("CREATE TABLE `presetnetworkrule` (  `ruleid` int(11) NOT NULL AUTO_INCREMENT,  `rulename` varchar(100) NOT NULL,  `ruledata` text NOT NULL,  PRIMARY KEY (`ruleid`),  KEY rulename (`rulename`)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
                addStmt.executeUpdate();
                LOGGER.info("Updated database: Added preset network rules");
            }
            if (!Updater.tableExists(connection, "lecture_x_networkrule")) {
                connection.prepareStatement("CREATE TABLE lecture_x_networkrule (  lectureid char(36) CHARACTER SET ascii COLLATE ascii_bin NOT NULL,  ruleid int(11) NOT NULL,  PRIMARY KEY (lectureid,ruleid),  KEY ruleid (ruleid)) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci").executeUpdate();
                connection.prepareStatement("ALTER TABLE lecture_x_networkrule  ADD CONSTRAINT lecture_x_networkrule_ibfk_1 FOREIGN KEY (lectureid)    REFERENCES lecture (lectureid)    ON DELETE CASCADE ON UPDATE CASCADE,  ADD CONSTRAINT lecture_x_networkrule_ibfk_2 FOREIGN KEY (ruleid)    REFERENCES presetnetworkrule (ruleid)    ON DELETE CASCADE ON UPDATE CASCADE").executeUpdate();
                LOGGER.info("Updated database: Created lecture_x_networkrule table + constraint");
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in Updater.addPredefinedNetworkShares()", (Throwable)e);
            throw e;
        }
    }

    private static boolean tableExists(MysqlConnection connection, String name) throws SQLException {
        MysqlStatement tablesStmt = connection.prepareStatement("SHOW TABLES");
        ResultSet tables = tablesStmt.executeQuery();
        boolean exists = false;
        while (tables.next()) {
            if (!tables.getString(1).equals(name)) continue;
            exists = true;
            break;
        }
        tablesStmt.close();
        return exists;
    }

    private static String getColumnType(MysqlConnection connection, String table, String column) throws SQLException {
        MysqlStatement checkStmt = connection.prepareStatement("DESCRIBE " + table);
        ResultSet cols = checkStmt.executeQuery();
        String ret = null;
        while (cols.next()) {
            if (!cols.getString("Field").equals(column)) continue;
            ret = cols.getString("Type");
            break;
        }
        return ret;
    }
}

