/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.mail.MailQueue;
import org.openslx.bwlp.sat.mail.MailTemplate;
import org.openslx.bwlp.sat.mail.MailTemplateConfiguration;
import org.openslx.bwlp.sat.mail.MailTemplatePlain;
import org.openslx.bwlp.thrift.iface.SatelliteConfig;
import org.openslx.util.Json;

public class DbConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(DbConfiguration.class);
    private static final String KEY_CERTIFICATE = "certstore";
    private static final String KEY_MAILCONFIG = "mailconfig";
    private static final String KEY_TEMPLATES = "templates";
    private static final String KEY_LIMITS = "runtimelimits";

    public static KeyStore loadKeyStore(String password) throws KeyStoreException, SQLException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        InputStream stream = DbConfiguration.retrieveStream(KEY_CERTIFICATE);
        if (stream == null) {
            return null;
        }
        keystore.load(stream, password.toCharArray());
        return keystore;
    }

    public static void saveKeyStore(File file) throws SQLException, FileNotFoundException, IOException {
        DbConfiguration.store(KEY_CERTIFICATE, new FileInputStream(file));
    }

    private static void store(String configKey, InputStream stream) throws IOException, SQLException {
        DbConfiguration.store(configKey, IOUtils.toByteArray(stream));
    }

    private static void store(String configKey, byte[] value) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("INSERT INTO configuration (parameter, value) VALUES (:parameter, :value) ON DUPLICATE KEY UPDATE value = VALUES(value)");
            stmt.setString("parameter", configKey);
            stmt.setBinary("value", value);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbConfiguration.store()", (Throwable)e);
            throw e;
        }
    }

    private static InputStream retrieveStream(String configKey) throws SQLException {
        byte[] data = DbConfiguration.retrieve(configKey);
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] retrieve(String configKey) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("SELECT value FROM configuration WHERE parameter = :parameter LIMIT 1");
            stmt.setString("parameter", configKey);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = rs.getBytes("value");
            return byArray;
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbConfiguration.retrieve()", (Throwable)e);
            throw e;
        }
    }

    public static MailQueue.MailConfig getMailConfig() throws SQLException {
        byte[] conf = DbConfiguration.retrieve(KEY_MAILCONFIG);
        if (conf == null) {
            return null;
        }
        return Json.deserialize(new String(conf, StandardCharsets.UTF_8), MailQueue.MailConfig.class);
    }

    public static SatelliteConfig getSatelliteConfig() throws SQLException {
        byte[] conf = DbConfiguration.retrieve(KEY_LIMITS);
        if (conf == null) {
            return null;
        }
        return Json.deserialize(new String(conf, StandardCharsets.UTF_8), SatelliteConfig.class);
    }

    public static void setSatelliteConfig(SatelliteConfig config) throws SQLException {
        DbConfiguration.store(KEY_LIMITS, Json.serialize(config).getBytes(StandardCharsets.UTF_8));
    }

    private static MailTemplateConfiguration getExistingMailTemplates() {
        MailTemplateConfiguration templateConf = null;
        try {
            byte[] raw = DbConfiguration.retrieve(KEY_TEMPLATES);
            if (raw != null) {
                String json = new String(raw, StandardCharsets.UTF_8);
                templateConf = Json.deserialize(json, MailTemplateConfiguration.class);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Cannot get mail templates from db", (Throwable)e);
        }
        return templateConf;
    }

    public static MailTemplate getMailTemplate(MailTemplatePlain.Template name) {
        MailTemplateConfiguration templateConf = DbConfiguration.getExistingMailTemplates();
        if (templateConf == null) {
            LOGGER.debug("No template config in DB -> save the default config to DB");
            templateConf = MailTemplateConfiguration.defaultTemplateConfiguration;
            try {
                DbConfiguration.store(KEY_TEMPLATES, Json.serialize(templateConf).getBytes(StandardCharsets.UTF_8));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (templateConf != null && templateConf.getByName(name) == null && MailTemplateConfiguration.defaultTemplateConfiguration.getByName(name) != null) {
            LOGGER.debug("DB template config does not contain a template for " + (Object)((Object)name));
            MailTemplateConfiguration newConf = templateConf.merge(MailTemplateConfiguration.defaultTemplateConfiguration);
            try {
                DbConfiguration.store(KEY_TEMPLATES, Json.serialize(newConf).getBytes(StandardCharsets.UTF_8));
                templateConf = newConf;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (templateConf != null && templateConf.getByName(name) != null) {
            return templateConf.getByName(name);
        }
        LOGGER.debug("Template with name \"" + (Object)((Object)name) + "\" could not be found");
        return null;
    }

    public static void updateMailTemplates(boolean resetExisting) {
        MailTemplateConfiguration conf = null;
        if (!resetExisting && (conf = DbConfiguration.getExistingMailTemplates()) != null) {
            conf = conf.merge(MailTemplateConfiguration.defaultTemplateConfiguration);
        }
        if (conf == null) {
            conf = MailTemplateConfiguration.defaultTemplateConfiguration;
        }
        try {
            DbConfiguration.store(KEY_TEMPLATES, Json.serialize(conf).getBytes(StandardCharsets.UTF_8));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static {
        Json.registerThriftClass(SatelliteConfig.class);
    }
}

