/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import com.google.gson.JsonObject;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.RuntimeConfig;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.database.Paginator;
import org.openslx.bwlp.sat.database.mappers.DbImageBlock;
import org.openslx.bwlp.sat.database.mappers.DbImagePermissions;
import org.openslx.bwlp.sat.database.mappers.DbLecture;
import org.openslx.bwlp.sat.database.mappers.DbSoftwareTag;
import org.openslx.bwlp.sat.database.models.ImageVersionMeta;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.mail.MailGenerator;
import org.openslx.bwlp.sat.permissions.User;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.thrift.iface.ImageBaseWrite;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.ImagePublishData;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.ImageVersionWrite;
import org.openslx.bwlp.thrift.iface.Role;
import org.openslx.bwlp.thrift.iface.ShareMode;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.filetransfer.util.ChunkList;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;
import org.openslx.virtualization.configuration.container.ContainerDefinition;
import org.openslx.virtualization.configuration.container.ContainerMeta;

public class DbImage {
    private static final Logger LOGGER = LogManager.getLogger(DbImage.class);
    private static final String localImageBaseSql = "SELECT v.imageversionid, v.imagebaseid, v.filepath, v.filesize, v.uploaderid, v.createtime, v.expiretime, v.isvalid, v.deletestate FROM imageversion v";

    public static List<ImageSummaryRead> getAllVisible(UserInfo user, List<String> tagSearch, int page) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT i.imagebaseid, i.latestversionid, i.displayname, i.description, i.osid, i.virtid, i.createtime, i.updatetime, i.ownerid, i.sharemode, i.istemplate, i.canlinkdefault, i.candownloaddefault, i.caneditdefault, i.canadmindefault, lat.expiretime, lat.filesize, lat.isrestricted, lat.isvalid, lat.uploaderid, lat.isprocessed, lat.createtime AS uploadtime, perm.canlink, perm.candownload, perm.canedit, perm.canadmin, Sum(allv.filesize) AS filesizesum, Count(allv.imageversionid) AS versioncount FROM imagebase i LEFT JOIN imageversion lat ON (lat.imageversionid = i.latestversionid) LEFT JOIN imageversion allv ON (allv.imagebaseid = i.imagebaseid) LEFT JOIN imagepermission perm ON (i.imagebaseid = perm.imagebaseid AND perm.userid = :userid) GROUP BY imagebaseid" + Paginator.limitStatement(page));
            stmt.setString("userid", user.userId);
            ResultSet rs = stmt.executeQuery();
            ArrayList<ImageSummaryRead> list = new ArrayList<ImageSummaryRead>(100);
            while (rs.next()) {
                list.add(DbImage.resultSetToSummary(user, rs));
            }
            ArrayList<ImageSummaryRead> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getAllVisible()", (Throwable)e);
                throw e;
            }
        }
    }

    public static ImageDetailsRead getImageDetails(UserInfo user, String imageBaseId) throws TNotFoundException, SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            ImageDetailsRead image;
            ImagePermissions defaultPermissions;
            MysqlStatement stmt = null;
            stmt = user != null && user.role == Role.STUDENT ? connection.prepareStatement("SELECT i.imagebaseid, i.latestversionid, i.virtid, i.osid, i.canlinkdefault, i.candownloaddefault, i.caneditdefault, i.canadmindefault FROM imagebase i LEFT JOIN imagepermission perm ON (i.imagebaseid = perm.imagebaseid AND perm.userid = :userid) WHERE i.imagebaseid = :imagebaseid") : connection.prepareStatement("SELECT i.imagebaseid, i.latestversionid, i.displayname, i.description, i.osid, i.virtid, i.createtime, i.updatetime, i.ownerid, i.updaterid, i.sharemode, i.istemplate, i.canlinkdefault, i.candownloaddefault, i.caneditdefault, i.canadmindefault, perm.canlink, perm.candownload, perm.canedit, perm.canadmin FROM imagebase i LEFT JOIN imagepermission perm ON (i.imagebaseid = perm.imagebaseid AND perm.userid = :userid) WHERE i.imagebaseid = :imagebaseid");
            stmt.setString("userid", user == null ? "-" : user.userId);
            stmt.setString("imagebaseid", imageBaseId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new TNotFoundException();
            }
            List<String> tags = DbSoftwareTag.getImageTags(connection, imageBaseId);
            List<ImageVersionDetails> versions = DbImage.getImageVersions(connection, imageBaseId, user);
            if (user != null && user.role == Role.STUDENT) {
                defaultPermissions = DbImagePermissions.fromResultSetDefault(rs);
                for (ImageVersionDetails version : versions) {
                    defaultPermissions.admin = false;
                    defaultPermissions.edit = false;
                    if (!version.isRestricted) continue;
                    defaultPermissions.download = false;
                }
                image = new ImageDetailsRead(rs.getString("imagebaseid"), rs.getString("latestversionid"), versions, "DownloadedImage", null, tags, 0, rs.getString("virtid"), 0L, 0L, null, null, null, false, defaultPermissions);
                image.setUserPermissions(defaultPermissions);
            } else {
                defaultPermissions = DbImagePermissions.fromResultSetDefault(rs);
                image = new ImageDetailsRead(rs.getString("imagebaseid"), rs.getString("latestversionid"), versions, rs.getString("displayname"), rs.getString("description"), tags, rs.getInt("osid"), rs.getString("virtid"), rs.getLong("createtime"), rs.getLong("updatetime"), rs.getString("ownerid"), rs.getString("updaterid"), DbImage.toShareMode(rs.getString("sharemode")), rs.getByte("istemplate") != 0, defaultPermissions);
                image.setUserPermissions(DbImagePermissions.fromResultSetUser(rs));
            }
            User.setCombinedUserPermissions(image, user);
            if (!image.userPermissions.download) {
                for (ImageVersionDetails version : versions) {
                    version.imagePath = null;
                }
            }
            ImageDetailsRead imageDetailsRead = image;
            if (connection != null) {
                connection.close();
            }
            return imageDetailsRead;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getImageDetails()", (Throwable)e);
                throw e;
            }
        }
    }

    private static LocalImageVersion toLocalImageVersion(ResultSet rs) throws SQLException {
        return new LocalImageVersion(rs.getString("imageversionid"), rs.getString("imagebaseid"), rs.getString("filepath"), rs.getLong("filesize"), rs.getString("uploaderid"), rs.getLong("createtime"), rs.getLong("expiretime"), rs.getBoolean("isvalid"), rs.getString("deletestate"));
    }

    public static LocalImageVersion getLocalImageData(String imageVersionId) throws TNotFoundException, SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT v.imageversionid, v.imagebaseid, v.filepath, v.filesize, v.uploaderid, v.createtime, v.expiretime, v.isvalid, v.deletestate FROM imageversion v WHERE imageversionid = :imageversionid");
            stmt.setString("imageversionid", imageVersionId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new TNotFoundException();
            }
            LocalImageVersion localImageVersion = DbImage.toLocalImageVersion(rs);
            if (connection != null) {
                connection.close();
            }
            return localImageVersion;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getLocalImageData()", (Throwable)e);
                throw e;
            }
        }
    }

    protected static List<LocalImageVersion> getLocalImageVersions(MysqlConnection connection, String imageBaseId) throws SQLException {
        MysqlStatement stmt = connection.prepareStatement("SELECT v.imageversionid, v.imagebaseid, v.filepath, v.filesize, v.uploaderid, v.createtime, v.expiretime, v.isvalid, v.deletestate FROM imageversion v WHERE imagebaseid = :imagebaseid");
        stmt.setString("imagebaseid", imageBaseId);
        ResultSet rs = stmt.executeQuery();
        ArrayList<LocalImageVersion> list = new ArrayList<LocalImageVersion>();
        while (rs.next()) {
            list.add(DbImage.toLocalImageVersion(rs));
        }
        return list;
    }

    public static List<LocalImageVersion> getExpiringLocalImageVersions(int maxRemainingDays) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT v.imageversionid, v.imagebaseid, v.filepath, v.filesize, v.uploaderid, v.createtime, v.expiretime, v.isvalid, v.deletestate FROM imageversion v WHERE expiretime < :deadline");
            stmt.setLong("deadline", Util.unixTime() + (long)(maxRemainingDays * 86400));
            ResultSet rs = stmt.executeQuery();
            ArrayList<LocalImageVersion> list = new ArrayList<LocalImageVersion>();
            while (rs.next()) {
                list.add(DbImage.toLocalImageVersion(rs));
            }
            ArrayList<LocalImageVersion> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getAllLocalImages()", (Throwable)e);
                throw e;
            }
        }
    }

    private static ImageSummaryRead resultSetToSummary(UserInfo user, ResultSet rs) throws SQLException {
        ImagePermissions defaultPermissions = DbImagePermissions.fromResultSetDefault(rs);
        ImageSummaryRead entry = new ImageSummaryRead(rs.getString("imagebaseid"), rs.getString("latestversionid"), rs.getString("displayname"), rs.getString("description"), rs.getInt("osid"), rs.getString("virtid"), rs.getLong("createtime"), rs.getLong("updatetime"), rs.getLong("uploadtime"), rs.getLong("expiretime"), rs.getString("ownerid"), rs.getString("uploaderid"), DbImage.toShareMode(rs.getString("sharemode")), rs.getLong("filesize"), rs.getByte("isrestricted") != 0, rs.getByte("isvalid") != 0, rs.getByte("isprocessed") != 0, rs.getByte("istemplate") != 0, defaultPermissions);
        entry.userPermissions = DbImagePermissions.fromResultSetUser(rs);
        try {
            entry.setFileSizeSum(rs.getLong("filesizesum"));
            entry.setVersionCount(rs.getInt("versioncount"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        User.setCombinedUserPermissions(entry, user);
        return entry;
    }

    public static ImageSummaryRead getImageSummary(UserInfo user, String imageBaseId) throws SQLException, TNotFoundException {
        MysqlConnection connection = Database.getConnection();
        try {
            ImageSummaryRead imageSummaryRead = DbImage.getImageSummary(connection, user, imageBaseId);
            if (connection != null) {
                connection.close();
            }
            return imageSummaryRead;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getImageSummary()", (Throwable)e);
                throw e;
            }
        }
    }

    protected static ImageSummaryRead getImageSummary(MysqlConnection connection, UserInfo user, String imageBaseId) throws SQLException, TNotFoundException {
        MysqlStatement stmt = connection.prepareStatement("SELECT i.imagebaseid, i.latestversionid, i.displayname, i.description, i.osid, i.virtid, i.createtime, i.updatetime, i.ownerid, i.sharemode, i.istemplate, i.canlinkdefault, i.candownloaddefault, i.caneditdefault, i.canadmindefault, lat.expiretime, lat.filesize, lat.isrestricted, lat.isvalid, lat.uploaderid, lat.isprocessed, lat.createtime AS uploadtime, perm.canlink, perm.candownload, perm.canedit, perm.canadmin FROM imagebase i LEFT JOIN imageversion lat ON (lat.imageversionid = i.latestversionid) LEFT JOIN imagepermission perm ON (i.imagebaseid = perm.imagebaseid AND perm.userid = :userid) WHERE i.imagebaseid = :imagebaseid");
        stmt.setString("userid", user.userId);
        stmt.setString("imagebaseid", imageBaseId);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            throw new TNotFoundException();
        }
        return DbImage.resultSetToSummary(user, rs);
    }

    protected static List<ImageVersionDetails> getImageVersions(MysqlConnection connection, String imageBaseId, UserInfo user) throws SQLException {
        ArrayList<ImageVersionDetails> versionList = new ArrayList<ImageVersionDetails>();
        MysqlStatement stmt = null;
        stmt = user != null && user.role == Role.STUDENT ? connection.prepareStatement("SELECT imageversionid, createtime, expiretime, filesize, isrestricted, isvalid, isprocessed, NULL AS filepath FROM imageversion WHERE imagebaseid = :imagebaseid AND isrestricted = 0") : connection.prepareStatement("SELECT imageversionid, createtime, expiretime, filesize, uploaderid, isrestricted, isvalid, isprocessed, filepath FROM imageversion WHERE imagebaseid = :imagebaseid");
        stmt.setString("imagebaseid", imageBaseId);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String imageVersionId = rs.getString("imageversionid");
            String uploaderID = "";
            if (user == null || user.role != Role.STUDENT) {
                uploaderID = rs.getString("uploaderid");
            }
            ImageVersionDetails v = new ImageVersionDetails(imageVersionId, rs.getLong("createtime"), rs.getLong("expiretime"), rs.getLong("filesize"), uploaderID, rs.getByte("isrestricted") != 0, rs.getByte("isvalid") != 0, rs.getByte("isprocessed") != 0, DbSoftwareTag.getImageVersionSoftwareList(connection, imageVersionId));
            v.setImagePath(rs.getString("filepath"));
            versionList.add(v);
        }
        stmt.close();
        return versionList;
    }

    public static String createImage(UserInfo user, String imageName) throws SQLException {
        if (imageName.length() > 100) {
            imageName = imageName.substring(0, 100);
        }
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("INSERT INTO imagebase (imagebaseid, displayname, createtime, updatetime, ownerid, updaterid, sharemode, istemplate, canlinkdefault, candownloaddefault, caneditdefault, canadmindefault) VALUES (:baseid, :name, UNIX_TIMESTAMP(), UNIX_TIMESTAMP(), :userid, :userid, 'LOCAL', 0, 0, 0, 0, 0)");
            String imageUuid = UUID.randomUUID().toString();
            stmt.setString("baseid", imageUuid);
            stmt.setString("name", imageName);
            stmt.setString("userid", user.userId);
            stmt.executeUpdate();
            connection.commit();
            String string = imageUuid;
            if (connection != null) {
                connection.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.createImage()", (Throwable)e);
                throw e;
            }
        }
    }

    public static void writeBaseImage(ImagePublishData image) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("INSERT INTO imagebase (imagebaseid, displayname, description, osid, virtid, createtime,  updatetime, ownerid, updaterid, sharemode, istemplate,  canlinkdefault, candownloaddefault, caneditdefault, canadmindefault)               VALUES                           (:imagebaseid, :displayname, :description, :osid, :virtid, :unixtime,  :unixtime, :userid, :userid, :sharemode, :istemplate,   1, 1, 0, 0)                                  ON DUPLICATE KEY UPDATE                         displayname = VALUES(displayname), description = VALUES(description),  osid = VALUES(osid), virtid = VALUES(virtid), updatetime = VALUES(updatetime),  updaterid = VALUES(updaterid), istemplate = VALUES(istemplate)");
            stmt.setString("imagebaseid", image.imageBaseId);
            stmt.setString("displayname", image.imageName);
            stmt.setString("description", image.description);
            stmt.setInt("osid", image.osId);
            stmt.setString("virtid", image.virtId);
            stmt.setLong("unixtime", Util.unixTime());
            stmt.setString("userid", image.owner.userId);
            stmt.setString("sharemode", "DOWNLOAD");
            stmt.setBoolean("istemplate", image.isTemplate);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.writeBaseImage()", (Throwable)e);
            throw e;
        }
    }

    public static void updateImageMetadata(UserInfo user, String imageBaseId, ImageBaseWrite image) throws SQLException {
        if (image.imageName.length() > 100) {
            image.imageName = image.imageName.substring(0, 100);
        }
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE imagebase SET displayname = :imagename, description = :description, osid = :osid, virtid = :virtid," + (user == null || User.isSuperUser(user) ? " istemplate = :istemplate," : "") + " canlinkdefault = :canlink, candownloaddefault = :candownload, caneditdefault = :canedit," + (user != null ? " updaterid = :updaterid, updatetime = UNIX_TIMESTAMP()," : "") + " canadmindefault = :canadmin WHERE imagebaseid = :baseid");
            stmt.setString("baseid", imageBaseId);
            stmt.setString("imagename", image.imageName);
            stmt.setString("description", image.description);
            stmt.setInt("osid", image.osId);
            stmt.setString("virtid", image.virtId);
            try {
                stmt.setBoolean("istemplate", image.isTemplate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            stmt.setBoolean("canlink", image.defaultPermissions.link);
            stmt.setBoolean("candownload", image.defaultPermissions.download);
            stmt.setBoolean("canedit", image.defaultPermissions.edit);
            stmt.setBoolean("canadmin", image.defaultPermissions.admin);
            if (user != null) {
                stmt.setString("updaterid", user.userId);
            }
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.updateImageMetadata()", (Throwable)e);
            throw e;
        }
    }

    public static void setImageOwner(String imageBaseId, String newOwnerId, UserInfo changingUser) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt;
            if (changingUser == null) {
                stmt = connection.prepareStatement("UPDATE imagebase SET ownerid = :ownerid WHERE imagebaseid = :baseid");
                stmt.setString("ownerid", newOwnerId);
                stmt.setString("baseid", imageBaseId);
            } else {
                stmt = connection.prepareStatement("UPDATE imagebase SET ownerid = :ownerid, updaterid = :updaterid, updatetime = UNIX_TIMESTAMP() WHERE imagebaseid = :baseid");
                stmt.setString("ownerid", newOwnerId);
                stmt.setString("updaterid", changingUser.userId);
                stmt.setString("baseid", imageBaseId);
            }
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.setImageOwner()", (Throwable)e);
            throw e;
        }
    }

    public static String getBaseIdForVersionId(String imageVersionId) throws SQLException, TNotFoundException {
        MysqlConnection connection = Database.getConnection();
        try {
            String string = DbImage.getBaseIdForVersionId(connection, imageVersionId);
            if (connection != null) {
                connection.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getBaseIdForVersionId()", (Throwable)e);
                throw e;
            }
        }
    }

    protected static String getBaseIdForVersionId(MysqlConnection connection, String imageVersionId) throws SQLException, TNotFoundException {
        MysqlStatement stmt = connection.prepareStatement("SELECT imagebaseid FROM imageversion WHERE imageversionid = :imageversionid LIMIT 1");
        stmt.setString("imageversionid", imageVersionId);
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            throw new TNotFoundException();
        }
        return rs.getString("imagebaseid");
    }

    private static ShareMode toShareMode(String string) {
        return ShareMode.valueOf(string);
    }

    public static void updateImageVersion(UserInfo user, String imageVersionId, ImageVersionWrite image) throws SQLException, TNotFoundException {
        try (MysqlConnection connection = Database.getConnection();){
            String baseId = DbImage.getBaseIdForVersionId(connection, imageVersionId);
            if (baseId == null) {
                throw new TNotFoundException();
            }
            MysqlStatement stmtVersion = connection.prepareStatement("UPDATE imageversion v SET v.isrestricted = :isrestricted WHERE v.imageversionid = :versionid");
            stmtVersion.setString("versionid", imageVersionId);
            stmtVersion.setBoolean("isrestricted", image.isRestricted);
            if (stmtVersion.executeUpdate() != 0) {
                MysqlStatement stmtBase = connection.prepareStatement("UPDATE imagebase b SET b.updaterid = :userid, b.updatetime = UNIX_TIMESTAMP() WHERE b.imagebaseid = :baseid");
                stmtBase.setString("userid", user.userId);
                stmtBase.setString("baseid", baseId);
                stmtBase.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.updateImageVersion()", (Throwable)e);
            throw e;
        }
    }

    public static void markForDeletion(String ... imageVersionIds) throws SQLException, TNotFoundException {
        if (imageVersionIds == null || imageVersionIds.length == 0) {
            return;
        }
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement checkStmt = connection.prepareStatement("SELECT imageversionid FROM imageversion WHERE imageversionid = :versionid AND (expiretime > UNIX_TIMESTAMP() OR isvalid <> 0)");
            MysqlStatement disableStmt = connection.prepareStatement("UPDATE imageversion SET expiretime = 1234567890, isvalid = 0 WHERE imageversionid = :versionid");
            ArrayList<String> affectedList = new ArrayList<String>(imageVersionIds.length);
            for (String imageVersionId : imageVersionIds) {
                if (imageVersionId == null) continue;
                checkStmt.setString("versionid", imageVersionId);
                ResultSet cr = checkStmt.executeQuery();
                if (!cr.next()) continue;
                disableStmt.setString("versionid", imageVersionId);
                disableStmt.executeUpdate();
                affectedList.add(imageVersionId);
            }
            checkStmt.close();
            disableStmt.close();
            connection.commit();
            if (!affectedList.isEmpty()) {
                DbImage.updateLatestVersion(connection, affectedList.toArray(new String[affectedList.size()]));
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.markForDeletion()", (Throwable)e);
            throw e;
        }
    }

    public static void setShareMode(String imageBaseId, ImageBaseWrite newData) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE imagebase SET sharemode = :sharemode WHERE imagebaseid = :baseid LIMIT 1");
            stmt.setString("baseid", imageBaseId);
            stmt.setString("sharemode", newData.shareMode.name());
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.setShareMode()", (Throwable)e);
            throw e;
        }
    }

    public static void createImageVersion(String imageBaseId, String imageVersionId, UserInfo owner, long fileSize, String filePath, ImageVersionWrite versionSettings, ChunkList chunks, byte[] machineDescription) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            long nowSecs = Util.unixTime();
            long expireTime = nowSecs + RuntimeConfig.getMaxImageValiditySeconds();
            MysqlStatement verStmt = connection.prepareStatement("INSERT INTO imageversion (imageversionid, imagebaseid, createtime, expiretime, filesize, filepath, uploaderid,  isrestricted, isvalid, isprocessed, mastersha1, virtualizerconfig)         VALUES                      (:imageversionid, :imagebaseid, :createtime, :expiretime, :filesize, :filepath,  :uploaderid, :isrestricted, :isvalid, :isprocessed, :mastersha1, :virtualizerconfig)");
            verStmt.setString("imageversionid", imageVersionId);
            verStmt.setString("imagebaseid", imageBaseId);
            verStmt.setLong("createtime", nowSecs);
            verStmt.setLong("expiretime", expireTime);
            verStmt.setLong("filesize", fileSize);
            verStmt.setString("filepath", filePath);
            verStmt.setString("uploaderid", owner.userId);
            verStmt.setBoolean("isrestricted", versionSettings == null ? false : versionSettings.isRestricted);
            verStmt.setBoolean("isvalid", true);
            verStmt.setBoolean("isprocessed", false);
            verStmt.setBinary("mastersha1", null);
            verStmt.setBinary("virtualizerconfig", machineDescription);
            verStmt.executeUpdate();
            DbImage.writeChunks(connection, imageVersionId, chunks);
            LocalImageVersion liv = new LocalImageVersion(imageVersionId, imageBaseId, filePath, fileSize, owner.userId, nowSecs, expireTime, true, DeleteState.KEEP.name());
            DbLecture.autoUpdateUsedImage(connection, imageBaseId, liv);
            MysqlStatement baseStmt = connection.prepareStatement("UPDATE imagebase SET updatetime = :updatetime, updaterid = :updaterid WHERE imagebaseid = :imagebaseid LIMIT 1");
            baseStmt.setString("imagebaseid", imageBaseId);
            baseStmt.setString("updaterid", owner.userId);
            baseStmt.setLong("updatetime", nowSecs);
            baseStmt.executeUpdate();
            DbImage.setLatestVersion(connection, imageBaseId, liv);
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.createImageVersion()", (Throwable)e);
            throw e;
        }
    }

    private static void writeChunks(MysqlConnection connection, String imageVersionId, ChunkList chunks) throws SQLException {
        if (chunks == null || chunks.isEmpty()) {
            LOGGER.info("Not writing chunk list - empty or missing");
            return;
        }
        for (FileChunk chunk : chunks.getAll()) {
            if (chunk.getSha1Sum() != null) continue;
            LOGGER.info("Not writing chunk list - at least one hash missing");
            return;
        }
        MysqlStatement stmt = connection.prepareStatement("INSERT IGNORE INTO imageblock (imageversionid, startbyte, blocksize, blocksha1, ismissing) VALUES (:imageversionid, :startbyte, :blocksize, :blocksha1, 0)");
        stmt.setString("imageversionid", imageVersionId);
        for (FileChunk chunk : chunks.getAll()) {
            stmt.setLong("startbyte", chunk.range.startOffset);
            stmt.setInt("blocksize", chunk.range.getLength());
            stmt.setBinary("blocksha1", chunk.getSha1Sum());
            stmt.executeUpdate();
        }
    }

    protected static LocalImageVersion[] markValid(MysqlConnection connection, boolean valid, LocalImageVersion ... imageVersion) throws SQLException {
        if (imageVersion == null || imageVersion.length == 0) {
            return new LocalImageVersion[0];
        }
        MysqlStatement stmt = connection.prepareStatement("UPDATE imageversion SET isvalid = :valid WHERE imageversionid = :imageversionid");
        stmt.setBoolean("valid", valid);
        ArrayList<LocalImageVersion> retList = new ArrayList<LocalImageVersion>(imageVersion.length);
        for (LocalImageVersion version : imageVersion) {
            stmt.setString("imageversionid", version.imageVersionId);
            if (stmt.executeUpdate() == 0) continue;
            retList.add(version);
        }
        return retList.toArray(new LocalImageVersion[retList.size()]);
    }

    public static void markValid(boolean valid, boolean async, LocalImageVersion ... imageVersions) throws SQLException {
        LocalImageVersion[] affectedVersions;
        if (imageVersions == null || imageVersions.length == 0) {
            return;
        }
        try (MysqlConnection connection = Database.getConnection();){
            affectedVersions = DbImage.markValid(connection, valid, imageVersions);
            if (!async) {
                DbImage.updateLatestVersion(connection, affectedVersions);
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.markInvalid()", (Throwable)e);
            throw e;
        }
        if (async) {
            DbImage.updateLatestVersionAsync(affectedVersions);
        }
    }

    public static void deleteVersionPermanently(LocalImageVersion image) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            DbLecture.unlinkFromImageVersion(connection, image.imageVersionId);
            MysqlStatement unlinkStmt = connection.prepareStatement("UPDATE imagebase SET latestversionid = NULL WHERE latestversionid = :imageversionid");
            unlinkStmt.setString("imageversionid", image.imageVersionId);
            unlinkStmt.executeUpdate();
            MysqlStatement stmt = connection.prepareStatement("DELETE FROM imageversion WHERE imageversionid = :imageversionid");
            stmt.setString("imageversionid", image.imageVersionId);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (Exception e) {
            LOGGER.error("Query failed in DbImage.deleteVersionPermanently(2)", (Throwable)e);
            throw e;
        }
    }

    private static void updateLatestVersionAsync(final LocalImageVersion ... changingVersion) {
        if (changingVersion == null || changingVersion.length == 0) {
            return;
        }
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                try (MysqlConnection connection = Database.getConnection();){
                    DbImage.updateLatestVersion(connection, changingVersion);
                    connection.commit();
                }
                catch (SQLException e) {
                    LOGGER.error("Query failed in DbImage.updateLatestVersionAsync()", (Throwable)e);
                }
            }
        });
    }

    private static void updateLatestVersion(MysqlConnection connection, LocalImageVersion ... versions) throws SQLException {
        if (versions == null || versions.length == 0) {
            return;
        }
        for (LocalImageVersion version : versions) {
            try {
                DbImage.versionValidityChanged(connection, version.imageVersionId, version.imageBaseId);
            }
            catch (TNotFoundException tNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void updateLatestVersion(MysqlConnection connection, String ... versions) throws SQLException {
        if (versions == null || versions.length == 0) {
            return;
        }
        for (String version : versions) {
            try {
                DbImage.versionValidityChanged(connection, version, null);
            }
            catch (TNotFoundException tNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void versionValidityChanged(MysqlConnection connection, String changingImageVersionId, String imageBaseId) throws TNotFoundException, SQLException {
        if (imageBaseId == null && (imageBaseId = DbImage.getBaseIdForVersionId(connection, changingImageVersionId)) == null) {
            LOGGER.warn("versionValidityChanged for non-existent version " + changingImageVersionId);
            throw new TNotFoundException();
        }
        List<LocalImageVersion> versions = DbImage.getLocalImageVersions(connection, imageBaseId);
        LocalImageVersion latestVersion = null;
        LocalImageVersion changingVersion = null;
        for (LocalImageVersion version : versions) {
            File versionFile;
            if (version.imageVersionId.equals(changingImageVersionId)) {
                changingVersion = version;
            }
            if (version.deleteState != DeleteState.KEEP || !version.isValid || latestVersion != null && version.createTime <= latestVersion.createTime || (versionFile = FileSystem.composeAbsoluteImagePath(version)) == null) continue;
            if (versionFile.canRead() && versionFile.length() == version.fileSize) {
                latestVersion = version;
                continue;
            }
            DbImage.markValid(connection, false, version);
        }
        if (changingVersion == null) {
            LOGGER.warn("BUG: oldVersion ninjad away on updateLatestVersion (" + changingImageVersionId + ")");
        } else if (changingVersion.isValid) {
            DbLecture.autoUpdateUsedImage(connection, imageBaseId, latestVersion);
        } else {
            DbLecture.forcefullySwitchUsedImage(connection, changingVersion, latestVersion);
        }
        if (DbImage.setLatestVersion(connection, imageBaseId, latestVersion)) {
            MailGenerator.sendImageVersionDeleted(imageBaseId, changingVersion, latestVersion);
        }
    }

    private static boolean setLatestVersion(MysqlConnection connection, String imageBaseId, LocalImageVersion newLatest) throws SQLException {
        boolean latestVersionChanged = true;
        MysqlStatement ds = connection.prepareStatement("SELECT latestversionid FROM imagebase WHERE imagebaseid = :imagebaseid");
        ds.setString("imagebaseid", imageBaseId);
        ResultSet drs = ds.executeQuery();
        if (drs.next()) {
            String currentLatest = drs.getString("latestversionid");
            if (currentLatest == null && (newLatest == null || newLatest.imageVersionId == null)) {
                latestVersionChanged = false;
            } else if (currentLatest != null && newLatest != null && currentLatest.equals(newLatest.imageVersionId)) {
                latestVersionChanged = false;
            }
        }
        MysqlStatement latestStmt = connection.prepareStatement("UPDATE imagebase SET latestversionid = :newversionid WHERE imagebaseid = :imagebaseid");
        latestStmt.setString("newversionid", newLatest == null ? null : newLatest.imageVersionId);
        latestStmt.setString("imagebaseid", imageBaseId);
        latestStmt.executeUpdate();
        if (!latestVersionChanged) {
            return false;
        }
        if (newLatest == null) {
            return true;
        }
        long shortExpire = Util.unixTime() + RuntimeConfig.getOldVersionExpireSeconds();
        MysqlStatement oldStmt = connection.prepareStatement("UPDATE imageversion SET expiretime = If(expiretime < :shortexpire, expiretime, :shortexpire) WHERE imagebaseid = :imagebaseid AND imageversionid <> :imageversionid AND isvalid = 1");
        oldStmt.setString("imageversionid", newLatest.imageVersionId);
        oldStmt.setString("imagebaseid", imageBaseId);
        oldStmt.setLong("shortexpire", shortExpire);
        oldStmt.executeUpdate();
        MysqlStatement newStmt = connection.prepareStatement("UPDATE imageversion SET expiretime = If(createtime + :maxvalid > expiretime, createtime + :maxvalid, expiretime) WHERE imageversionid = :imageversionid");
        newStmt.setString("imageversionid", newLatest.imageVersionId);
        newStmt.setLong("maxvalid", RuntimeConfig.getMaxImageValiditySeconds());
        newStmt.executeUpdate();
        return true;
    }

    public static List<LocalImageVersion> getVersionsWithMissingData() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT v.imageversionid, v.imagebaseid, v.filepath, v.filesize, v.uploaderid, v.createtime, v.expiretime, v.isvalid, v.deletestate FROM imageversion v INNER JOIN imagebase b USING (imagebaseid) WHERE b.virtid IS NULL OR b.osid IS NULL");
            ResultSet rs = stmt.executeQuery();
            ArrayList<LocalImageVersion> list = new ArrayList<LocalImageVersion>();
            while (rs.next()) {
                list.add(new LocalImageVersion(rs.getString("imageversionid"), rs.getString("imagebaseid"), rs.getString("filepath"), rs.getLong("filesize"), rs.getString("uploaderid"), rs.getLong("createtime"), 0L, rs.getBoolean("isvalid"), rs.getString("deletestate")));
            }
            ArrayList<LocalImageVersion> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getVersionsWithMissingData()", (Throwable)e);
                throw e;
            }
        }
    }

    public static int deleteOrphanedBases() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement sel = connection.prepareStatement("SELECT i.imagebaseid FROM imagebase i LEFT JOIN imageversion v USING (imagebaseid) WHERE (   i.updatetime < :cutoff1 OR (i.updatetime < :cutoff2 AND (i.updatetime - i.createtime) < 600)) AND v.imageversionid IS NULL");
            sel.setLong("cutoff1", Util.unixTime() - 1209600L);
            sel.setLong("cutoff2", Util.unixTime() - 7200L);
            ResultSet rs = sel.executeQuery();
            MysqlStatement stmt = connection.prepareStatement("DELETE FROM imagebase WHERE imagebaseid = :imagebaseid");
            int ret = 0;
            while (rs.next()) {
                String baseId = null;
                try {
                    baseId = rs.getString("imagebaseid");
                    stmt.setString("imagebaseid", baseId);
                    ret += stmt.executeUpdate();
                }
                catch (SQLException e) {
                    LOGGER.warn("Could not delete base image " + baseId, (Throwable)e);
                }
            }
            connection.commit();
            int n = ret;
            if (connection != null) {
                connection.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.deleteOrphanedBases()", (Throwable)e);
                throw e;
            }
        }
    }

    public static ImageVersionMeta getVersionDetails(String imageVersionId) throws SQLException, TNotFoundException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT imageversionid, imagebaseid, virtualizerconfig FROM imageversion WHERE imageversionid = :imageversionid");
            stmt.setString("imageversionid", imageVersionId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new TNotFoundException();
            }
            ImageVersionMeta imageVersionMeta = new ImageVersionMeta(imageVersionId, rs.getString("imagebaseid"), rs.getBytes("virtualizerconfig"), DbImageBlock.getBlockHashes(connection, imageVersionId));
            if (connection != null) {
                connection.close();
            }
            return imageVersionMeta;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getVersionDetails()", (Throwable)e);
                throw e;
            }
        }
    }

    public static byte[] getVirtualizerConfig(String imageVersionId) throws SQLException, TNotFoundException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT virtualizerconfig FROM imageversion WHERE imageversionid = :imageversionid");
            stmt.setString("imageversionid", imageVersionId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new TNotFoundException();
            }
            byte[] byArray = rs.getBytes("virtualizerconfig");
            if (connection != null) {
                connection.close();
            }
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getVirtualizerConfig()", (Throwable)e);
                throw e;
            }
        }
    }

    public static void setVirtualizerConfig(String imageVersionId, byte[] machineDescription) throws SQLException, TNotFoundException {
        if (imageVersionId == null || machineDescription == null || machineDescription.length == 0) {
            return;
        }
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE imageversion SET virtualizerconfig = :virtualizerconfig WHERE imageversionid = :imageversionid");
            stmt.setString("imageversionid", imageVersionId);
            stmt.setBinary("virtualizerconfig", machineDescription);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.setVersionDetails()", (Throwable)e);
            throw e;
        }
    }

    public static void setDeletion(DeleteState shouldDelete, String ... imageVersionIds) throws SQLException {
        if (imageVersionIds == null || imageVersionIds.length == 0 || shouldDelete == null) {
            return;
        }
        String ignoredOldState = shouldDelete == DeleteState.SHOULD_DELETE ? DeleteState.WANT_DELETE.name() : "invalid";
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE imageversion SET deletestate = :newstate WHERE imageversionid = :imageversionid AND deletestate <> :oldstate");
            stmt.setString("newstate", shouldDelete.name());
            stmt.setString("oldstate", ignoredOldState);
            for (String imageVersionId : imageVersionIds) {
                if (imageVersionId == null) continue;
                stmt.setString("imageversionid", imageVersionId);
                stmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.setDeletion()", (Throwable)e);
            throw e;
        }
    }

    public static List<LocalImageVersion> getLocalWithState(DeleteState state) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT v.imageversionid, v.imagebaseid, v.filepath, v.filesize, v.uploaderid, v.createtime, v.expiretime, v.isvalid, v.deletestate FROM imageversion v WHERE deletestate = :deletestate");
            stmt.setString("deletestate", state.name());
            ResultSet rs = stmt.executeQuery();
            ArrayList<LocalImageVersion> list = new ArrayList<LocalImageVersion>();
            while (rs.next()) {
                list.add(DbImage.toLocalImageVersion(rs));
            }
            ArrayList<LocalImageVersion> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getLocalWithState()", (Throwable)e);
                throw e;
            }
        }
    }

    public static void deleteBasePermanently(String imageBaseId) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("DELETE FROM imagebase WHERE imagebaseid = :imagebaseid");
            stmt.setString("imagebaseid", imageBaseId);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.deleteBasePermanently()", (Throwable)e);
            throw e;
        }
    }

    public static Set<String> resetDeleteState() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement sstmt = connection.prepareStatement("SELECT imageversionid FROM imageversion WHERE deletestate = :should");
            sstmt.setString("should", DeleteState.SHOULD_DELETE.name());
            ResultSet rs = sstmt.executeQuery();
            HashSet<String> list = new HashSet<String>();
            while (rs.next()) {
                list.add(rs.getString("imageversionid"));
            }
            MysqlStatement ustmt = connection.prepareStatement("UPDATE imageversion SET deletestate = :keep WHERE deletestate = :should");
            ustmt.setString("keep", DeleteState.KEEP.name());
            ustmt.setString("should", DeleteState.SHOULD_DELETE.name());
            ustmt.executeUpdate();
            connection.commit();
            HashSet<String> hashSet = list;
            if (connection != null) {
                connection.close();
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.resetDeleteState()", (Throwable)e);
                throw e;
            }
        }
    }

    public static void setExpireDate(String imageVersionId, long expireTime) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE imageversion SET expiretime = :expiretime WHERE imageversionid = :imageversionid");
            stmt.setString("imageversionid", imageVersionId);
            stmt.setLong("expiretime", expireTime);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImage.setExpireDate()", (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getAllFilenames() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT filepath FROM imageversion");
            ResultSet rs = stmt.executeQuery();
            HashSet<String> result = new HashSet<String>();
            while (rs.next()) {
                result.add(rs.getString("filepath"));
            }
            HashSet<String> hashSet = result;
            if (connection != null) {
                connection.close();
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getAllFilenames()", (Throwable)e);
                throw e;
            }
        }
    }

    public static List<ContainerImages> getContainerImageCluster() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT ib.imagebaseid, iv.filepath, iv.filesize, iv.virtualizerconfig, u.firstname, u.lastname FROM imagebase AS ib JOIN imageversion AS iv ON (ib.imagebaseid=iv.imagebaseid AND ib.virtid = 'docker' AND ib.latestversionid IS NOT NULL) JOIN user as u ON ib.ownerid = u.userid");
            ResultSet rs = stmt.executeQuery();
            ArrayList<ContainerImages> result = new ArrayList<ContainerImages>();
            while (rs.next()) {
                ContainerDefinition condev = ContainerDefinition.fromByteArray(rs.getBytes("iv.virtualizerconfig"));
                if (condev.getContainerMeta().getImageType() == ContainerMeta.ContainerImageType.LECTURE) continue;
                ContainerImages entry = new ContainerImages(rs.getString("u.firstname"), rs.getString("u.lastname"), condev.getContainerMeta().getImageRepo(), condev.getContainerMeta().getImageType().name());
                result.add(entry);
            }
            ArrayList<ContainerImages> arrayList = result;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Query failed in DbImage.getContainerImages()", (Throwable)e);
                throw e;
            }
        }
    }

    public static String getContainerImageMetadata(String imagebaseid) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            ContainerDefinition condev;
            MysqlStatement stmt = connection.prepareStatement("SELECT ib.imagebaseid, ib.displayname, iv.filepath, iv.filesize, iv.virtualizerconfig FROM imagebase AS ib JOIN imageversion AS iv ON (ib.latestversionid=iv.imageversionid AND ib.virtid = 'docker' AND ib.latestversionid IS NOT NULL) WHERE ib.imagebaseid = :imagebaseid");
            stmt.setString("imagebaseid", imagebaseid);
            ResultSet rs = stmt.executeQuery();
            JsonObject resultJson = new JsonObject();
            if (rs.next() && (condev = ContainerDefinition.fromByteArray(rs.getBytes("iv.virtualizerconfig"))).getContainerMeta().getImageType() == ContainerMeta.ContainerImageType.DATA) {
                resultJson.addProperty("displayname", rs.getString("ib.displayname"));
                resultJson.addProperty("imagepath", rs.getString("iv.filepath"));
                resultJson.addProperty("filesize", rs.getString("iv.filesize"));
                resultJson.addProperty("image_recipe", condev.getContainerRecipe());
                resultJson.addProperty("image_repo", condev.getContainerMeta().getImageRepo());
                resultJson.addProperty("build_context_method", condev.getContainerMeta().getContainerImageContext());
                resultJson.addProperty("build_context_url", condev.getContainerMeta().getBuildContextUrl());
            }
            String string = resultJson.toString();
            if (connection != null) {
                connection.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Query failed in DbImage.getContainerImages()", (Throwable)e);
                throw e;
            }
        }
    }

    public static Set<LocalImageVersion> getAllInvalid() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement sstmt = connection.prepareStatement("SELECT v.imageversionid, v.imagebaseid, v.filepath, v.filesize, v.uploaderid, v.createtime, v.expiretime, v.isvalid, v.deletestate FROM imageversion v WHERE v.isvalid = 0 AND v.expiretime > :now");
            sstmt.setLong("now", Util.unixTime());
            ResultSet rs = sstmt.executeQuery();
            HashSet<LocalImageVersion> list = new HashSet<LocalImageVersion>();
            while (rs.next()) {
                list.add(DbImage.toLocalImageVersion(rs));
            }
            HashSet<LocalImageVersion> hashSet = list;
            if (connection != null) {
                connection.close();
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.resetDeleteState()", (Throwable)e);
                throw e;
            }
        }
    }

    static class ContainerImages {
        public final String owner_firstname;
        public final String owner_lastname;
        public final String image;
        public final String image_type;

        public ContainerImages(String owner_firstname, String owner_lastname, String image, String image_type) {
            this.owner_firstname = owner_firstname;
            this.owner_lastname = owner_lastname;
            this.image = image;
            this.image_type = image_type;
        }
    }

    public static enum DeleteState {
        KEEP,
        SHOULD_DELETE,
        WANT_DELETE;

    }
}

