/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.filetransfer.FileRange;
import org.openslx.filetransfer.LocalChunkSource;
import org.openslx.filetransfer.util.ChunkStatus;
import org.openslx.filetransfer.util.FileChunk;

public class DbImageBlock {
    private static final Logger LOGGER = LogManager.getLogger(DbImageBlock.class);
    private static AsyncThread asyncBlockUpdate = null;

    private static synchronized void initAsyncThread() {
        if (asyncBlockUpdate == null) {
            asyncBlockUpdate = new AsyncThread();
            asyncBlockUpdate.start();
        }
    }

    public static void asyncUpdate(String imageVersionId, FileChunk chunk) throws InterruptedException {
        DbImageBlock.initAsyncThread();
        asyncBlockUpdate.put(new ChunkUpdate(imageVersionId, chunk.range, chunk.getStatus() != ChunkStatus.COMPLETE));
    }

    public static void insertChunkList(String imageVersionId, List<FileChunk> all, boolean missing) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("INSERT IGNORE INTO imageblock (imageversionid, startbyte, blocksize, blocksha1, ismissing) VALUES (:imageversionid, :startbyte, :blocksize, :blocksha1, :ismissing)");
            stmt.setString("imageversionid", imageVersionId);
            stmt.setBoolean("ismissing", missing);
            for (FileChunk chunk : all) {
                stmt.setLong("startbyte", chunk.range.startOffset);
                stmt.setInt("blocksize", chunk.range.getLength());
                stmt.setBinary("blocksha1", chunk.getSha1Sum());
                stmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImageBlock.insertChunkList()", (Throwable)e);
            throw e;
        }
    }

    static List<ByteBuffer> getBlockHashes(MysqlConnection connection, String imageVersionId) throws SQLException {
        MysqlStatement stmt = connection.prepareStatement("SELECT startbyte, blocksha1 FROM imageblock WHERE imageversionid = :imageversionid ORDER BY startbyte ASC");
        stmt.setString("imageversionid", imageVersionId);
        ResultSet rs = stmt.executeQuery();
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
        long expectedOffset = 0L;
        while (rs.next()) {
            long currentOffset = rs.getLong("startbyte");
            if (currentOffset < expectedOffset) continue;
            while (currentOffset > expectedOffset) {
                list.add(null);
                expectedOffset += 0x1000000L;
            }
            if (currentOffset != expectedOffset) continue;
            list.add(ByteBuffer.wrap(rs.getBytes("blocksha1")));
            expectedOffset += 0x1000000L;
        }
        return list;
    }

    public static List<ByteBuffer> getBlockHashes(String imageVersionId) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            List<ByteBuffer> list = DbImageBlock.getBlockHashes(connection, imageVersionId);
            if (connection != null) {
                connection.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImage.getBlockHashes()", (Throwable)e);
                throw e;
            }
        }
    }

    public static List<Boolean> getMissingStatusList(String imageVersionId) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT startbyte, ismissing FROM imageblock WHERE imageversionid = :imageversionid ORDER BY startbyte ASC");
            stmt.setString("imageversionid", imageVersionId);
            ResultSet rs = stmt.executeQuery();
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            long expectedOffset = 0L;
            while (rs.next()) {
                long currentOffset = rs.getLong("startbyte");
                if (currentOffset < expectedOffset) continue;
                while (currentOffset > expectedOffset) {
                    list.add(Boolean.TRUE);
                    expectedOffset += 0x1000000L;
                }
                if (currentOffset != expectedOffset) continue;
                list.add(rs.getBoolean("ismissing"));
                expectedOffset += 0x1000000L;
            }
            ArrayList<Boolean> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImageBlock.getBlockStatuses()", (Throwable)e);
                throw e;
            }
        }
    }

    public static List<LocalChunkSource.ChunkSource> getBlocksWithHash(List<byte[]> sums) throws SQLException {
        ArrayList<LocalChunkSource.ChunkSource> list = null;
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("SELECT startbyte, blocksize, filepath FROM imageblock INNER JOIN imageversion USING (imageversionid) WHERE blocksha1 = :sha1 GROUP BY imageversionid");
            for (byte[] sha1 : sums) {
                stmt.setBinary("sha1", sha1);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) continue;
                LocalChunkSource.ChunkSource cs = new LocalChunkSource.ChunkSource(sha1);
                do {
                    cs.addFile(FileSystem.composeAbsolutePath(rs.getString("filepath")).getAbsolutePath(), rs.getLong("startbyte"), rs.getInt("blocksize"));
                } while (rs.next());
                if (list == null) {
                    list = new ArrayList<LocalChunkSource.ChunkSource>();
                }
                list.add(cs);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImageBlock.getBlocksWithHash()", (Throwable)e);
            throw e;
        }
        return list;
    }

    private static class ChunkUpdate {
        public final String imageVersionId;
        public final FileRange range;
        public final boolean isMissing;

        public ChunkUpdate(String imageVersionId, FileRange range, boolean isMissing) {
            this.imageVersionId = imageVersionId;
            this.range = range;
            this.isMissing = isMissing;
        }
    }

    private static class AsyncThread
    extends Thread {
        private final ArrayBlockingQueue<ChunkUpdate> queue = new ArrayBlockingQueue(100);

        public AsyncThread() {
            super("DbBlockUpdater");
        }

        public void put(ChunkUpdate chunk) throws InterruptedException {
            this.queue.put(chunk);
        }

        @Override
        public void run() {
            try {
                while (!AsyncThread.interrupted()) {
                    ChunkUpdate chunk = this.queue.take();
                    Thread.sleep(100L);
                    try (MysqlConnection connection = Database.getConnection();){
                        MysqlStatement stmt = connection.prepareStatement("UPDATE imageblock SET ismissing = :ismissing WHERE imageversionid = :imageversionid AND startbyte = :startbyte AND blocksize = :blocksize");
                        do {
                            stmt.setBoolean("ismissing", chunk.isMissing);
                            stmt.setString("imageversionid", chunk.imageVersionId);
                            stmt.setLong("startbyte", chunk.range.startOffset);
                            stmt.setInt("blocksize", chunk.range.getLength());
                            stmt.executeUpdate();
                        } while ((chunk = this.queue.poll()) != null);
                        connection.commit();
                    }
                    catch (SQLException e) {
                        LOGGER.error("Query failed in DbImageBlock.AsyncThread.run()", (Throwable)e);
                        continue;
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException e) {
                LOGGER.debug("async thread interrupted");
                this.interrupt();
            }
        }
    }
}

