/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.util.Sanitizer;
import org.openslx.bwlp.thrift.iface.ImagePermissions;

public class DbImagePermissions {
    private static final Logger LOGGER = LogManager.getLogger(DbImagePermissions.class);

    private static ImagePermissions fromResultSet(ResultSet rs, String canLink, String canDownload, String canEdit, String canAdmin) throws SQLException {
        byte link = rs.getByte(canLink);
        if (rs.wasNull()) {
            return null;
        }
        return new ImagePermissions(link != 0, rs.getByte(canDownload) != 0, rs.getByte(canEdit) != 0, rs.getByte(canAdmin) != 0);
    }

    public static ImagePermissions fromResultSetUser(ResultSet rs) throws SQLException {
        return DbImagePermissions.fromResultSet(rs, "canlink", "candownload", "canedit", "canadmin");
    }

    public static ImagePermissions fromResultSetDefault(ResultSet rs) throws SQLException {
        return DbImagePermissions.fromResultSet(rs, "canlinkdefault", "candownloaddefault", "caneditdefault", "canadmindefault");
    }

    public static Map<String, ImagePermissions> getForImageBase(String imageBaseId, boolean adminOnly) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT userid, canlink, candownload, canedit, canadmin FROM imagepermission WHERE imagebaseid = :imagebaseid");
            stmt.setString("imagebaseid", imageBaseId);
            ResultSet rs = stmt.executeQuery();
            HashMap<String, ImagePermissions> list = new HashMap<String, ImagePermissions>();
            while (rs.next()) {
                boolean admin = rs.getBoolean("canadmin");
                if (adminOnly && !admin) continue;
                ImagePermissions perm = new ImagePermissions(rs.getBoolean("canlink"), rs.getBoolean("candownload"), rs.getBoolean("canedit"), admin);
                list.put(rs.getString("userid"), perm);
            }
            HashMap<String, ImagePermissions> hashMap = list;
            if (connection != null) {
                connection.close();
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImagePermissions.getForImageBase()", (Throwable)e);
                throw e;
            }
        }
    }

    public static void writeForImageBase(String imageBaseId, Map<String, ImagePermissions> permissions) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("DELETE FROM imagepermission WHERE imagebaseid = :baseid");
            stmt.setString("baseid", imageBaseId);
            stmt.executeUpdate();
            stmt = connection.prepareStatement("INSERT INTO imagepermission (imagebaseid, userid, canlink, candownload, canedit, canadmin) VALUES (:baseid, :userid, :canlink, :candownload, :canedit, :canadmin)");
            stmt.setString("baseid", imageBaseId);
            for (Map.Entry<String, ImagePermissions> entry : permissions.entrySet()) {
                ImagePermissions perm = entry.getValue();
                perm = Sanitizer.handleImagePermissions(perm);
                stmt.setString("userid", entry.getKey());
                stmt.setBoolean("canlink", perm.link);
                stmt.setBoolean("candownload", perm.download);
                stmt.setBoolean("canedit", perm.edit);
                stmt.setBoolean("canadmin", perm.admin);
                stmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbImagePermissions.writeForImageBase()", (Throwable)e);
            throw e;
        }
    }

    public static void writeForImageBase(String imageBaseId, String userId, ImagePermissions imagePermissions) throws SQLException {
        HashMap<String, ImagePermissions> map = new HashMap<String, ImagePermissions>();
        map.put(userId, imagePermissions);
        DbImagePermissions.writeForImageBase(imageBaseId, map);
    }
}

