/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.util.Sanitizer;
import org.openslx.bwlp.thrift.iface.LecturePermissions;

public class DbLecturePermissions {
    private static final Logger LOGGER = LogManager.getLogger(DbLecturePermissions.class);

    private static LecturePermissions fromResultSet(ResultSet rs, String canEdit, String canAdmin) throws SQLException {
        boolean edit = rs.getBoolean(canEdit);
        if (rs.wasNull()) {
            return null;
        }
        return new LecturePermissions(edit, rs.getBoolean(canAdmin));
    }

    public static LecturePermissions fromResultSetUser(ResultSet rs) throws SQLException {
        return DbLecturePermissions.fromResultSet(rs, "canedit", "canadmin");
    }

    public static LecturePermissions fromResultSetDefault(ResultSet rs) throws SQLException {
        return DbLecturePermissions.fromResultSet(rs, "caneditdefault", "canadmindefault");
    }

    public static void writeForLecture(String lectureId, Map<String, LecturePermissions> permissions) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("DELETE FROM lecturepermission WHERE lectureid = :lectureid");
            stmt.setString("lectureid", lectureId);
            stmt.executeUpdate();
            stmt = connection.prepareStatement("INSERT INTO lecturepermission (lectureid, userid, canedit, canadmin) VALUES (:lectureid, :userid, :canedit, :canadmin)");
            stmt.setString("lectureid", lectureId);
            for (Map.Entry<String, LecturePermissions> entry : permissions.entrySet()) {
                LecturePermissions perm = entry.getValue();
                perm = Sanitizer.handleLecturePermissions(perm);
                stmt.setString("userid", entry.getKey());
                stmt.setBoolean("canedit", perm.edit);
                stmt.setBoolean("canadmin", perm.admin);
                stmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbLecturePermissions.writeForLecture()", (Throwable)e);
            throw e;
        }
    }

    public static Map<String, LecturePermissions> getForLecture(String lectureId, boolean adminOnly) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT userid, canedit, canadmin FROM lecturepermission WHERE lectureid = :lectureid");
            stmt.setString("lectureid", lectureId);
            ResultSet rs = stmt.executeQuery();
            HashMap<String, LecturePermissions> list = new HashMap<String, LecturePermissions>();
            while (rs.next()) {
                boolean admin = rs.getBoolean("canadmin");
                if (adminOnly && !admin) continue;
                LecturePermissions perm = new LecturePermissions(rs.getBoolean("canedit"), admin);
                list.put(rs.getString("userid"), perm);
            }
            HashMap<String, LecturePermissions> hashMap = list;
            if (connection != null) {
                connection.close();
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbImagePermissions.getForImageBase()", (Throwable)e);
                throw e;
            }
        }
    }
}

