/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class DbLog {
    private static final Logger LOGGER = LogManager.getLogger(DbLog.class);

    public static void log(final UserInfo user, final String targetId, final String description) {
        final long timeStamp = Util.unixTime();
        final String userName = user == null ? "System" : Formatter.userFullName(user);
        LOGGER.info("[" + userName + "] " + description);
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                try (MysqlConnection connection = Database.getConnection();){
                    MysqlStatement stmt = connection.prepareStatement("INSERT INTO actionlog (dateline, userid, targetid, description) VALUES (:dateline, :userid, :targetid, :description)");
                    stmt.setLong("dateline", timeStamp);
                    stmt.setString("userid", user == null ? null : user.userId);
                    stmt.setString("targetid", targetId);
                    stmt.setString("description", description == null ? "" : "[" + userName + "] " + description);
                    stmt.executeUpdate();
                    connection.commit();
                }
                catch (SQLException e) {
                    LOGGER.error("Query failed in DbLog.log()", (Throwable)e);
                }
            }
        });
    }
}

