/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.mail.Mail;

public class DbMailQueue {
    private static final Logger LOGGER = LogManager.getLogger(DbMailQueue.class);

    public static void queue(Mail mail) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("INSERT IGNORE INTO mailqueue (mailid, userid, message, failcount, dateline) VALUES (:mailid, :userid, :message, 0, UNIX_TIMESTAMP())");
            stmt.setString("mailid", mail.id);
            stmt.setString("userid", mail.userId);
            stmt.setString("message", mail.message);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbMailQueue.queue()", (Throwable)e);
            throw e;
        }
    }

    public static List<Mail> getQueued(int batchSize) throws SQLException {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be > 0");
        }
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement delStmt = connection.prepareStatement("DELETE FROM mailqueue WHERE UNIX_TIMESTAMP() - dateline > 86400 * 2");
            delStmt.executeUpdate();
            if (Math.random() < 0.01) {
                MysqlStatement optStmt = connection.prepareStatement("OPTIMIZE TABLE mailqueue");
                optStmt.execute();
            }
            MysqlStatement stmt = connection.prepareStatement("SELECT mailid, userid, message FROM mailqueue WHERE failcount < 8 ORDER BY dateline ASC LIMIT " + batchSize);
            ResultSet rs = stmt.executeQuery();
            ArrayList<Mail> list = new ArrayList<Mail>();
            while (rs.next()) {
                list.add(new Mail(rs.getString("mailid"), rs.getString("userid"), rs.getString("message")));
            }
            connection.commit();
            ArrayList<Mail> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbMailQueue.getQueued()", (Throwable)e);
                throw e;
            }
        }
    }

    public static void markFailed(List<Mail> mails) throws SQLException {
        if (mails.isEmpty()) {
            return;
        }
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE mailqueue SET failcount = failcount + 1   WHERE mailid = :mailid");
            for (Mail mail : mails) {
                stmt.setString("mailid", mail.id);
                stmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbMailQueue.markFailed()", (Throwable)e);
            throw e;
        }
    }

    public static void markSent(List<Mail> mails) throws SQLException {
        if (mails.isEmpty()) {
            return;
        }
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("DELETE FROM mailqueue WHERE mailid = :mailid");
            for (Mail mail : mails) {
                stmt.setString("mailid", mail.id);
                stmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbMailQueue.markFailed()", (Throwable)e);
            throw e;
        }
    }
}

