/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.database.models.LocalOrganization;
import org.openslx.bwlp.thrift.iface.Organization;

public class DbOrganization {
    private static final Logger LOGGER = LogManager.getLogger(DbOrganization.class);

    public static void storeOrganizations(List<Organization> organizations) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("INSERT INTO organization (organizationid, displayname, canlogin) VALUES (:id, :name, 0) ON DUPLICATE KEY UPDATE displayname = VALUES(displayname)");
            for (Organization organization : organizations) {
                stmt.setString("id", organization.organizationId);
                stmt.setString("name", organization.displayName);
                stmt.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbOrganization.storeOrganization()", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalOrganization getLocalData(String organizationId) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("SELECT canlogin FROM organization WHERE organizationid = :organizationid");
            stmt.setString("organizationid", organizationId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                LocalOrganization localOrganization = null;
                return localOrganization;
            }
            LocalOrganization localOrganization = new LocalOrganization(rs.getBoolean("canlogin"));
            return localOrganization;
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbOrganization.getLocalData()", (Throwable)e);
            throw e;
        }
    }

    public static List<Organization> getLoginAllowedOrganizations() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT organizationid, displayname FROM organization WHERE canlogin = 1");
            ResultSet rs = stmt.executeQuery();
            ArrayList<Organization> list = new ArrayList<Organization>();
            while (rs.next()) {
                list.add(new Organization(rs.getString("organizationid"), rs.getString("displayname"), null, null));
            }
            ArrayList<Organization> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbOrganization.getLoginAllowedOrganizations()", (Throwable)e);
                throw e;
            }
        }
    }

    public static void setCanLogin(String organizationId, boolean canlogin) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE organization SET canlogin = :canlogin WHERE organizationid = :organizationid");
            stmt.setString("organizationid", organizationId);
            stmt.setBoolean("canlogin", canlogin);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbOrganization.setCanLogin()", (Throwable)e);
            throw e;
        }
    }

    public static List<Organization> getAll() throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT o.organizationid, o.displayname FROM organization o");
            ResultSet rsOrg = stmt.executeQuery();
            ArrayList<Organization> list = new ArrayList<Organization>();
            while (rsOrg.next()) {
                list.add(new Organization(rsOrg.getString("organizationid"), rsOrg.getString("displayname"), null, null));
            }
            ArrayList<Organization> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbOrganization.getAll()", (Throwable)e);
                throw e;
            }
        }
    }
}

