/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;

public class DbSoftwareTag {
    private static final Logger LOGGER = LogManager.getLogger(DbSoftwareTag.class);

    public static List<String> getImageVersionSoftwareList(MysqlConnection connection, String imageVersionId) throws SQLException {
        MysqlStatement stmt = connection.prepareStatement("SELECT softwarestring FROM software INNER JOIN imageversion_x_software USING (softwareid) WHERE imageversionid = :imageversionid");
        stmt.setString("imageversionid", imageVersionId);
        ResultSet rs = stmt.executeQuery();
        ArrayList<String> softwareList = new ArrayList<String>();
        while (rs.next()) {
            softwareList.add(rs.getString("softwarestring"));
        }
        stmt.close();
        return softwareList;
    }

    public static List<String> getImageVersionSoftwareList(String imageVersionId) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        try {
            List<String> list = DbSoftwareTag.getImageVersionSoftwareList(connection, imageVersionId);
            if (connection != null) {
                connection.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbSoftware.getImageVersionSoftwareList()", (Throwable)e);
                throw e;
            }
        }
    }

    public static List<String> getImageTags(MysqlConnection connection, String imageBaseId) throws SQLException {
        MysqlStatement stmt = connection.prepareStatement("SELECT tagname FROM imagetag WHERE imagebaseid = :imagebaseid");
        stmt.setString("imagebaseid", imageBaseId);
        ResultSet rs = stmt.executeQuery();
        ArrayList<String> tagList = new ArrayList<String>();
        while (rs.next()) {
            tagList.add(rs.getString("displayname"));
        }
        stmt.close();
        return tagList;
    }
}

