/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.database.mappers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.RuntimeConfig;
import org.openslx.bwlp.sat.database.Database;
import org.openslx.bwlp.sat.database.MysqlConnection;
import org.openslx.bwlp.sat.database.MysqlStatement;
import org.openslx.bwlp.sat.database.Paginator;
import org.openslx.bwlp.sat.database.models.LocalUser;
import org.openslx.bwlp.thrift.iface.SatelliteUserConfig;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.QuickTimer;
import org.openslx.util.TimeoutHashMap;
import org.openslx.util.Util;

public class DbUser {
    private static boolean legacyUsersExist = false;
    private static final Logger LOGGER = LogManager.getLogger(DbUser.class);
    private static Map<String, User> userCache = new TimeoutHashMap<String, User>(TimeUnit.MINUTES.toMillis(15L));

    public static List<UserInfo> getAll(int page) throws SQLException {
        if (page < 0) {
            return new ArrayList<UserInfo>(1);
        }
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT userid, firstname, lastname, email, organizationid FROM user ORDER BY userid ASC " + Paginator.limitStatement(page));
            ResultSet rs = stmt.executeQuery();
            ArrayList<UserInfo> list = new ArrayList<UserInfo>();
            while (rs.next()) {
                list.add(new UserInfo(rs.getString("userid"), rs.getString("firstname"), rs.getString("lastname"), rs.getString("email"), rs.getString("organizationid")));
            }
            ArrayList<UserInfo> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in DbUser.getAll()", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UserInfo getOrNull(String userId) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("SELECT userid, firstname, lastname, email, organizationid FROM user WHERE userid = :userid");
            stmt.setString("userid", userId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                UserInfo userInfo = new UserInfo(rs.getString("userid"), rs.getString("firstname"), rs.getString("lastname"), rs.getString("email"), rs.getString("organizationid"));
                return userInfo;
            }
            UserInfo userInfo = null;
            return userInfo;
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbUser.getAll()", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalUser getLocalData(UserInfo user) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("SELECT lastlogin, canlogin, issuperuser, emailnotifications FROM user WHERE userid = :userid LIMIT 1");
            stmt.setString("userid", user.userId);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                LocalUser localUser = null;
                return localUser;
            }
            LocalUser localUser = new LocalUser(rs.getLong("lastlogin"), rs.getBoolean("canlogin"), rs.getBoolean("issuperuser"), rs.getBoolean("emailnotifications"));
            return localUser;
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbUser.getLocalData()", (Throwable)e);
            throw e;
        }
    }

    public static void writeUserConfig(UserInfo user, SatelliteUserConfig config) throws SQLException {
        try (MysqlConnection connection = Database.getConnection();){
            MysqlStatement stmt = connection.prepareStatement("UPDATE user SET emailnotifications = :emailnotifications    WHERE userid = :userid");
            stmt.setString("userid", user.userId);
            stmt.setBoolean("emailnotifications", config.emailNotifications);
            stmt.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbUser.writeUserConfig()", (Throwable)e);
            throw e;
        }
    }

    public static void writeUserOnLogin(UserInfo ui) throws SQLException {
        DbUser.writeUser(ui, true);
    }

    public static void writeUserOnReplication(UserInfo ui) throws SQLException {
        DbUser.writeUser(ui, false);
    }

    private static void writeUser(UserInfo ui, boolean isLogin) throws SQLException {
        if (ui.firstName.length() > 50) {
            ui.firstName = ui.firstName.substring(0, 50);
        }
        if (ui.lastName.length() > 50) {
            ui.lastName = ui.lastName.substring(0, 50);
        }
        if (ui.eMail.length() > 100) {
            ui.eMail = ui.eMail.substring(0, 100);
        }
        boolean recheckLegacy = true;
        try (MysqlConnection connection = Database.getConnection();){
            if (!legacyUsersExist || !DbUser.tryLegacyUserUpdate(connection, ui)) {
                MysqlStatement insUpStmt;
                if (isLogin) {
                    insUpStmt = connection.prepareStatement("INSERT INTO user (userid, firstname, lastname, email, organizationid, lastlogin, canlogin, issuperuser, emailnotifications) VALUES (:userid, :firstname, :lastname, :email, :organizationid, UNIX_TIMESTAMP(), :canlogin, 0, 1) ON DUPLICATE KEY UPDATE lastlogin = UNIX_TIMESTAMP(), email = VALUES(email), firstname = VALUES(firstname), lastname = VALUES(lastname), organizationid = VALUES(organizationid)");
                    insUpStmt.setBoolean("canlogin", RuntimeConfig.allowLoginByDefault());
                } else {
                    insUpStmt = connection.prepareStatement("INSERT INTO user (userid, firstname, lastname, email, organizationid, canlogin, issuperuser, emailnotifications) VALUES (:userid, :firstname, :lastname, :email, :organizationid, 0, 0, 0) ON DUPLICATE KEY UPDATE email = VALUES(email), firstname = VALUES(firstname), lastname = VALUES(lastname), organizationid = VALUES(organizationid)");
                }
                insUpStmt.setString("userid", ui.userId);
                insUpStmt.setString("firstname", ui.firstName);
                insUpStmt.setString("lastname", ui.lastName);
                insUpStmt.setString("email", ui.eMail);
                insUpStmt.setString("organizationid", ui.organizationId);
                insUpStmt.executeUpdate();
                recheckLegacy = false;
            }
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Query failed in DbUser.writeUserOnLogin()", (Throwable)e);
            throw e;
        }
        if (recheckLegacy) {
            DbUser.checkIfLegacyUsersExist();
        }
    }

    private static boolean tryLegacyUserUpdate(MysqlConnection connection, UserInfo ui) throws SQLException {
        MysqlStatement findStmt = connection.prepareStatement("SELECT userid FROM user WHERE firstname = :firstname AND lastname = :lastname AND email = :email");
        findStmt.setString("firstname", ui.firstName);
        findStmt.setString("lastname", ui.lastName);
        findStmt.setString("email", "@" + ui.eMail + "@");
        ResultSet rs = findStmt.executeQuery();
        if (!rs.next()) {
            return false;
        }
        String oldId = rs.getString("userid");
        MysqlStatement insUpStmt = connection.prepareStatement("UPDATE IGNORE user SET lastlogin = UNIX_TIMESTAMP(), email = :email, userid = :newuserid, organizationid = :organizationid, emailnotifications = 1 WHERE userid = :olduserid");
        insUpStmt.setString("newuserid", ui.userId);
        insUpStmt.setString("email", ui.eMail);
        insUpStmt.setString("organizationid", ui.organizationId);
        insUpStmt.setString("olduserid", oldId);
        insUpStmt.executeUpdate();
        if (!ui.userId.equals(oldId)) {
            MysqlStatement fixStmt = connection.prepareStatement("UPDATE user SET email = 'void', emailnotifications = 0 WHERE userid = :olduserid AND email LIKE '@%'");
            fixStmt.setString("olduserid", oldId);
            fixStmt.executeUpdate();
        }
        return true;
    }

    public static void checkIfLegacyUsersExist() {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                try (MysqlConnection connection = Database.getConnection();){
                    MysqlStatement stmt = connection.prepareStatement("SELECT userid FROM user WHERE email LIKE '@%@' LIMIT 1");
                    ResultSet rs = stmt.executeQuery();
                    legacyUsersExist = rs.next();
                }
                catch (SQLException e) {
                    LOGGER.error("Query failed in DbUser.checkIfLegacyUsersExist()", (Throwable)e);
                }
                LOGGER.info("Imported legacy users exist: " + Boolean.toString(legacyUsersExist));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getCached(String userId) throws SQLException, TNotFoundException {
        Class<DbUser> clazz = DbUser.class;
        synchronized (DbUser.class) {
            User user = userCache.get(userId);
            if (user != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return user;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            MysqlConnection connection = Database.getConnection();
            try {
                MysqlStatement stmt = connection.prepareStatement("SELECT userid, firstname, lastname, email, organizationid, lastlogin, canlogin, issuperuser, emailnotifications FROM user WHERE userid = :userid");
                stmt.setString("userid", userId);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new TNotFoundException();
                }
                UserInfo userInfo = new UserInfo(rs.getString("userid"), rs.getString("firstname"), rs.getString("lastname"), rs.getString("email"), rs.getString("organizationid"));
                LocalUser local = new LocalUser(rs.getLong("lastlogin"), rs.getBoolean("canlogin"), rs.getBoolean("issuperuser"), rs.getBoolean("emailnotifications"));
                User user2 = new User(userInfo, local);
                Object object = DbUser.class;
                synchronized (DbUser.class) {
                    userCache.put(userInfo.userId, user2);
                    // ** MonitorExit[var7_11] (shouldn't be in output)
                    object = user2;
                    if (connection != null) {
                        connection.close();
                    }
                    return object;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Query failed in DbUser.getCached()", (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public static List<UserInfo> getInactive() throws SQLException {
        long cutoff = Util.unixTime() - TimeUnit.DAYS.toSeconds(180L);
        MysqlConnection connection = Database.getConnection();
        try {
            MysqlStatement stmt = connection.prepareStatement("SELECT userid, firstname, lastname, email, organizationid FROM user WHERE lastlogin < :cutoff AND canlogin <> 0 AND issuperuser = 0");
            stmt.setLong("cutoff", cutoff);
            ResultSet rs = stmt.executeQuery();
            ArrayList<UserInfo> list = new ArrayList<UserInfo>();
            while (rs.next()) {
                list.add(new UserInfo(rs.getString("userid"), rs.getString("firstname"), rs.getString("lastname"), rs.getString("email"), rs.getString("organizationid")));
            }
            ArrayList<UserInfo> arrayList = list;
            if (connection != null) {
                connection.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                LOGGER.error("Query failed in getInactive()", (Throwable)e);
                throw e;
            }
        }
    }

    public static boolean deleteUser(UserInfo user) throws SQLException {
        MysqlConnection connection = Database.getConnection();
        MysqlStatement stmt = connection.prepareStatement("DELETE FROM user WHERE userid = :userid");
        stmt.setString("userid", user.userId);
        try {
            boolean bl;
            int num = stmt.executeUpdate();
            connection.commit();
            boolean bl2 = bl = num > 0;
            if (connection != null) {
                connection.close();
            }
            return bl;
        }
        catch (SQLException e) {
            try {
                connection.rollback();
                boolean bl = false;
                if (connection != null) {
                    connection.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOGGER.error("Query failed in deleteUser()", (Throwable)e2);
                    throw e2;
                }
            }
        }
    }

    public static class User {
        public final UserInfo ui;
        public final LocalUser local;

        public User(UserInfo ui, LocalUser local) {
            this.ui = ui;
            this.local = local;
        }
    }
}

