/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.fileserv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.fileserv.IncomingDataTransfer;
import org.openslx.bwlp.sat.fileserv.OutgoingDataTransfer;
import org.openslx.bwlp.sat.fileserv.cow.CowSessionManager;
import org.openslx.bwlp.sat.util.Constants;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.sat.util.Identity;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.TTransferRejectedException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.filetransfer.Downloader;
import org.openslx.filetransfer.IncomingEvent;
import org.openslx.filetransfer.Listener;
import org.openslx.filetransfer.Uploader;
import org.openslx.filetransfer.util.AbstractTransfer;
import org.openslx.thrifthelper.Comparators;
import org.openslx.util.CascadedThreadPoolExecutor;
import org.openslx.util.PrioThreadFactory;

public class FileServer
implements IncomingEvent {
    private static final Logger LOGGER = LogManager.getLogger(FileServer.class);
    private final Listener plainListener = new Listener(this, null, 9092, 15000);
    private final Listener sslListener;
    private final ExecutorService transferPool = new CascadedThreadPoolExecutor(1, Constants.MAX_UPLOADS + Constants.MAX_DOWNLOADS, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), (ThreadFactory)new PrioThreadFactory("CTransf", 3), null);
    private final Map<String, IncomingDataTransfer> uploads = new ConcurrentHashMap<String, IncomingDataTransfer>();
    private final Map<String, OutgoingDataTransfer> downloads = new ConcurrentHashMap<String, OutgoingDataTransfer>();
    static final long MIN_FREE_SPACE_BYTES = 0x1000000 * (2 + Constants.MAX_UPLOADS);
    private static final FileServer globalInstance = new FileServer();

    private FileServer() {
        SSLContext ctx = Identity.getSSLContext();
        this.sslListener = ctx == null ? null : new Listener(this, ctx, 9093, 15000);
        LOGGER.info("Max allowed concurrent uploads from clients: " + Constants.MAX_UPLOADS);
        LOGGER.info("Max allowed concurrent downloads from clients: " + Constants.MAX_DOWNLOADS);
        LOGGER.info("Max allowed connections per transfer: " + Constants.MAX_CONNECTIONS_PER_TRANSFER);
    }

    public static FileServer instance() {
        return globalInstance;
    }

    public boolean start() {
        boolean ret = this.plainListener.start();
        if (this.sslListener != null) {
            ret |= this.sslListener.start();
        }
        return ret;
    }

    @Override
    public void incomingDownloadRequest(Uploader uploader) throws IOException {
        OutgoingDataTransfer download;
        String token = uploader.getToken();
        OutgoingDataTransfer outgoingDataTransfer = download = token == null ? null : this.downloads.get(token);
        if (download == null) {
            LOGGER.warn("Download request: Unknown token " + token);
            uploader.cancel();
            return;
        }
        if (!download.addConnection(uploader, this.transferPool)) {
            uploader.cancel();
        }
    }

    @Override
    public void incomingUploadRequest(Downloader downloader) throws IOException {
        IncomingDataTransfer upload;
        String token = downloader.getToken();
        IncomingDataTransfer incomingDataTransfer = upload = token == null ? null : this.uploads.get(token);
        if (upload == null) {
            LOGGER.warn("Upload request: Unknown token " + token);
            downloader.cancel();
            return;
        }
        if (!upload.addConnection(downloader, this.transferPool)) {
            if (upload.getErrorMessage() != null) {
                downloader.sendErrorCode(upload.getErrorMessage());
            }
            downloader.cancel();
        }
    }

    public IncomingDataTransfer getUploadByToken(String uploadToken) {
        if (uploadToken == null) {
            return null;
        }
        return this.uploads.get(uploadToken);
    }

    public OutgoingDataTransfer getDownloadByToken(String downloadToken) {
        if (downloadToken == null) {
            return null;
        }
        return this.downloads.get(downloadToken);
    }

    public IncomingDataTransfer createNewUserUpload(UserInfo owner, ImageDetailsRead image, long fileSize, List<byte[]> sha1Sums, byte[] machineDescription) throws TTransferRejectedException {
        IncomingDataTransfer upload;
        Iterator<IncomingDataTransfer> it = this.uploads.values().iterator();
        long now = System.currentTimeMillis();
        int activeUploads = 0;
        int activeUserUploads = 0;
        while (it.hasNext()) {
            IncomingDataTransfer upload2 = it.next();
            if (upload2.isComplete(now) || upload2.hasReachedIdleTimeout(now)) {
                upload2.cancel();
                it.remove();
                continue;
            }
            if (!upload2.countsTowardsConnectionLimit(now)) continue;
            if (upload2.getOwner() != null && Comparators.user.compare(owner, upload2.getOwner()) == 0) {
                ++activeUserUploads;
            }
            ++activeUploads;
        }
        if (activeUploads >= Constants.MAX_UPLOADS || activeUserUploads > Constants.MAX_UPLOADS_PER_USER) {
            throw new TTransferRejectedException("Server busy. Too many running uploads (User: " + activeUserUploads + "/" + Constants.MAX_UPLOADS_PER_USER + "; Total: " + activeUploads + "/" + Constants.MAX_UPLOADS + ").");
        }
        File destinationFile = null;
        String uploadkey = UUID.randomUUID().toString();
        while ((destinationFile = Formatter.getTempImageName(uploadkey)).exists()) {
        }
        destinationFile.getParentFile().mkdirs();
        try {
            upload = new IncomingDataTransfer(uploadkey, owner, image, destinationFile, fileSize, sha1Sums, machineDescription, false);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not open destination file for writing", (Throwable)e);
            throw new TTransferRejectedException("Destination file not writable!");
        }
        LOGGER.info(owner.getFirstName() + " " + owner.getLastName() + " (" + owner.getUserId() + ") started upload " + uploadkey + " of '" + image.getImageName() + "'");
        this.uploads.put(uploadkey, upload);
        return upload;
    }

    public int getPlainPort() {
        if (this.plainListener == null) {
            return 0;
        }
        return this.plainListener.getPort();
    }

    public int getSslPort() {
        if (this.sslListener == null) {
            return 0;
        }
        return this.sslListener.getPort();
    }

    public OutgoingDataTransfer createNewUserDownload(LocalImageVersion localImageData) throws TTransferRejectedException {
        Iterator<OutgoingDataTransfer> it = this.downloads.values().iterator();
        long now = System.currentTimeMillis();
        int activeDownloads = 0;
        while (it.hasNext()) {
            OutgoingDataTransfer download = it.next();
            if (download.isComplete(now) || download.hasReachedIdleTimeout(now)) {
                download.cancel();
                it.remove();
                continue;
            }
            if (!download.countsTowardsConnectionLimit(now)) continue;
            ++activeDownloads;
        }
        if (activeDownloads >= Constants.MAX_DOWNLOADS) {
            throw new TTransferRejectedException("Server busy. Too many running uploads (" + activeDownloads + "/" + Constants.MAX_UPLOADS + ").");
        }
        File srcFile = FileSystem.composeAbsoluteImagePath(localImageData);
        String errorMessage = null;
        if (srcFile == null) {
            LOGGER.warn("Rejecting download of VID " + localImageData.imageVersionId + ": Invalid local relative path");
            errorMessage = "File has invalid path on server";
        } else {
            if (!srcFile.canRead()) {
                LOGGER.warn("Rejecting download of VID " + localImageData.imageVersionId + ": Missing " + srcFile.getPath());
                errorMessage = "File missing on server";
            }
            if (srcFile.length() != localImageData.fileSize) {
                LOGGER.warn("Rejecting download of VID " + localImageData.imageVersionId + ": Size mismatch for " + srcFile.getPath() + " (expected " + localImageData.fileSize + ", is " + srcFile.length() + ")");
                errorMessage = "File corrupted on server";
            }
        }
        if (errorMessage != null) {
            if (localImageData.isValid) {
                try {
                    DbImage.markValid(false, true, localImageData);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new TTransferRejectedException(errorMessage);
        }
        String key = UUID.randomUUID().toString();
        OutgoingDataTransfer transfer = new OutgoingDataTransfer(key, srcFile, this.getPlainPort(), this.getSslPort(), localImageData.imageVersionId);
        this.downloads.put(key, transfer);
        return transfer;
    }

    public Status getStatus() {
        return new Status();
    }

    public boolean isActiveTransfer(String baseId, String versionId) {
        long now = System.currentTimeMillis();
        if (versionId != null) {
            for (OutgoingDataTransfer odt : this.downloads.values()) {
                if (versionId == null || !versionId.equals(odt.getVersionId()) || odt.isComplete(now) || !odt.isActive()) continue;
                return true;
            }
        }
        for (IncomingDataTransfer idt : this.uploads.values()) {
            if (idt.isComplete(now) || !idt.isActive()) continue;
            if (versionId != null && versionId.equals(idt.getVersionId())) {
                return true;
            }
            if (baseId == null || !baseId.equals(idt.getBaseId())) continue;
            return true;
        }
        return false;
    }

    class Status {
        public final int activeUploads;
        public final int activeDownloads;

        private Status() {
            long now = System.currentTimeMillis();
            int d = 0;
            int u = 0;
            for (AbstractTransfer t : FileServer.this.downloads.values()) {
                if (!t.countsTowardsConnectionLimit(now)) continue;
                ++d;
            }
            for (AbstractTransfer t : FileServer.this.uploads.values()) {
                if (!t.countsTowardsConnectionLimit(now)) continue;
                ++u;
            }
            this.activeDownloads = d;
            this.activeUploads = u + CowSessionManager.getActiveCount();
        }
    }
}

