/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.fileserv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.RuntimeConfig;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbImageBlock;
import org.openslx.bwlp.sat.database.mappers.DbLog;
import org.openslx.bwlp.sat.fileserv.FileServer;
import org.openslx.bwlp.sat.fileserv.StorageChunkSource;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePublishData;
import org.openslx.bwlp.thrift.iface.ImageVersionWrite;
import org.openslx.bwlp.thrift.iface.SscMode;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.TransferInformation;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.bwlp.thrift.iface.UploadOptions;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.filetransfer.Downloader;
import org.openslx.filetransfer.util.ChunkStatus;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.filetransfer.util.IncomingTransferBase;
import org.openslx.util.ThriftUtil;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageException;

public class IncomingDataTransfer
extends IncomingTransferBase {
    private static final Logger LOGGER = LogManager.getLogger(IncomingDataTransfer.class);
    private final UserInfo owner;
    private final ImageDetailsRead image;
    private ImageVersionWrite versionSettings = null;
    private final byte[] machineDescription;
    private final AtomicBoolean versionWrittenToDb = new AtomicBoolean();
    private final TransferInformation masterTransferInfo;
    private String errorMessage = null;
    private final long initTimestamp = System.currentTimeMillis();
    private final AtomicInteger speedCounter = new AtomicInteger();
    private long speedTimestamp = 0L;
    private static final long SSC_ENABLE_THRES = 0xA00000L;
    private static final long SSC_DISABLE_THRES = 0x1400000L;

    public IncomingDataTransfer(String uploadId, UserInfo owner, ImageDetailsRead image, File destinationFile, long fileSize, List<byte[]> sha1Sums, byte[] machineDescription, boolean repairUpload) throws FileNotFoundException {
        super(uploadId, destinationFile, fileSize, sha1Sums, StorageChunkSource.instance);
        this.owner = repairUpload ? null : owner;
        this.image = image;
        this.machineDescription = machineDescription;
        this.masterTransferInfo = null;
        this.initCommonUpload();
    }

    public IncomingDataTransfer(ImagePublishData publishData, File tmpFile, TransferInformation transferInfo, boolean repairUpload) throws FileNotFoundException {
        super(publishData.imageVersionId, tmpFile, publishData.fileSize, ThriftUtil.unwrapByteBufferList(transferInfo.blockHashes), StorageChunkSource.instance);
        ImageDetailsRead idr = new ImageDetailsRead();
        idr.setCreateTime(publishData.createTime);
        idr.setDescription(publishData.description);
        idr.setImageBaseId(publishData.imageBaseId);
        idr.setImageName(publishData.imageName);
        idr.setIsTemplate(publishData.isTemplate);
        idr.setLatestVersionId(publishData.imageVersionId);
        idr.setOsId(publishData.osId);
        idr.setOwnerId(publishData.owner.userId);
        idr.setTags(publishData.tags);
        idr.setUpdaterId(publishData.uploader.userId);
        idr.setUpdateTime(publishData.createTime);
        idr.setVirtId(publishData.virtId);
        this.owner = repairUpload ? null : publishData.uploader;
        this.image = idr;
        this.machineDescription = ThriftUtil.unwrapByteBuffer(transferInfo.machineDescription);
        this.masterTransferInfo = transferInfo;
        this.versionSettings = new ImageVersionWrite(false);
        this.initCommonUpload();
    }

    private void initCommonUpload() {
        SscMode sscMode = RuntimeConfig.get().serverSideCopy;
        if (sscMode == SscMode.OFF) {
            super.enableServerSideCopying(false);
        } else if (sscMode == SscMode.ON) {
            super.enableServerSideCopying(true);
        }
        if (!this.isRepairUpload()) {
            return;
        }
        if (this.getTmpFileName().exists() && this.getTmpFileName().length() > 0L) {
            try {
                List<Boolean> statusList = DbImageBlock.getMissingStatusList(this.getVersionId());
                if (!statusList.isEmpty()) {
                    this.getChunks().resumeFromStatusList(statusList, this.getTmpFileName().length());
                    for (int i = 0; i < 3; ++i) {
                        this.queueUnhashedChunk(false);
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartBeat(ExecutorService pool) {
        if (this.masterTransferInfo == null) {
            return;
        }
        if (this.connectFailCount() > 50) {
            return;
        }
        IncomingDataTransfer incomingDataTransfer = this;
        synchronized (incomingDataTransfer) {
            if (this.getActiveConnectionCount() >= 1) {
                return;
            }
            Downloader downloader = null;
            if (downloader == null && this.masterTransferInfo.sslPort != 0) {
                try {
                    downloader = new Downloader(Configuration.getMasterServerAddress(), this.masterTransferInfo.sslPort, 15000, SSLContext.getDefault(), this.masterTransferInfo.token);
                }
                catch (Exception e2) {
                    LOGGER.debug("SSL connect failed", (Throwable)e2);
                    downloader = null;
                }
            }
            if (downloader == null && this.masterTransferInfo.plainPort != 0) {
                try {
                    downloader = new Downloader(Configuration.getMasterServerAddress(), this.masterTransferInfo.plainPort, 15000, null, this.masterTransferInfo.token);
                }
                catch (Exception e1) {
                    LOGGER.debug("Plain connect failed", (Throwable)e1);
                    downloader = null;
                }
            }
            if (downloader == null) {
                LOGGER.warn("Could not connect to master server for downloading " + this.image.imageName);
                return;
            }
            this.addConnection(downloader, pool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setVersionData(UserInfo user, ImageVersionWrite data) {
        if (this.isRepairUpload()) {
            return false;
        }
        AtomicBoolean atomicBoolean = this.versionWrittenToDb;
        synchronized (atomicBoolean) {
            if (this.versionWrittenToDb.get()) {
                return false;
            }
            if (!user.userId.equals(this.owner.userId)) {
                return false;
            }
            this.versionSettings = new ImageVersionWrite(data);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean finishIncomingTransfer() {
        if (this.getState() != TransferState.FINISHED) {
            LOGGER.warn("finishIncomingTransfer called in bad state " + this.getState());
            return false;
        }
        this.potentialFinishTime.set(System.currentTimeMillis());
        if (this.isRepairUpload()) {
            try {
                DbImage.markValid(true, false, DbImage.getLocalImageData(this.getVersionId()));
            }
            catch (TNotFoundException e) {
                LOGGER.warn("Apparently, the image " + this.getVersionId() + " that was just repaired doesn't exist...");
            }
            catch (SQLException e) {
                // empty catch block
            }
            return true;
        }
        LOGGER.info("Finalizing uploaded image " + this.image.imageName);
        String ext = "img";
        try (DiskImage inst2 = DiskImage.newInstance(this.getTmpFileName());){
            ext = inst2.getFormat().getExtension();
        }
        catch (IOException | DiskImageException inst2) {
            // empty catch block
        }
        File destination = new File(this.getTmpFileName().getParent(), Formatter.vmName(this.initTimestamp, this.owner, this.image.imageName, ext)).getAbsoluteFile();
        String relPath = FileSystem.getRelativePath(destination, Configuration.getVmStoreBasePath());
        if (relPath == null) {
            LOGGER.error(destination.getAbsolutePath() + " is not a subdir of " + Configuration.getVmStoreBasePath().getAbsolutePath());
            this.cancel();
            return false;
        }
        if (relPath.length() > 200) {
            LOGGER.error("Generated file name is >200 chars. DB will not like it");
        }
        try {
            Path d = Files.move(this.getTmpFileName().toPath(), destination.toPath(), StandardCopyOption.ATOMIC_MOVE);
            if (d != null && d.toFile().exists()) {
                destination = d.toFile();
            }
        }
        catch (IOException e1) {
            LOGGER.warn("Cannot rename", (Throwable)e1);
        }
        if (!destination.exists()) {
            try {
                this.getTmpFileName().renameTo(destination);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot rename", (Throwable)e);
            }
        }
        if (!destination.exists()) {
            LOGGER.warn("Could not rename '" + this.getTmpFileName().getAbsolutePath() + "' to '" + destination.getAbsolutePath());
            this.cancel();
            return false;
        }
        if (destination.length() != this.getFileSize()) {
            LOGGER.warn("Destination file size mismatch. Is: " + destination.length() + ", should be: " + this.getFileSize());
        }
        try {
            AtomicBoolean e = this.versionWrittenToDb;
            synchronized (e) {
                LOGGER.debug("Owner id " + this.owner);
                DbImage.createImageVersion(this.image.imageBaseId, this.getVersionId(), this.owner, this.getFileSize(), relPath, this.versionSettings, this.getChunks(), this.machineDescription);
                this.versionWrittenToDb.set(true);
            }
            DbLog.log(this.owner, this.image.imageBaseId, "successfully uploaded new version " + this.getVersionId() + " of VM '" + this.image.imageName + "'");
        }
        catch (SQLException e) {
            LOGGER.error("Error finishing upload: Inserting version to DB failed", (Throwable)e);
            LOGGER.info("Deleting file " + destination, (Throwable)e);
            FileSystem.deleteAsync(destination);
            this.cancel();
            return false;
        }
        try {
            String crcfile = destination.getAbsolutePath() + ".crc";
            this.getChunks().writeCrc32List(crcfile);
        }
        catch (Exception e) {
            LOGGER.warn("Could not get CRC32 list for upload of " + this.image.getImageName(), (Throwable)e);
        }
        return true;
    }

    public String getVersionId() {
        if (this.masterTransferInfo == null) {
            return this.getId();
        }
        return this.image.latestVersionId;
    }

    public String getBaseId() {
        return this.image.imageBaseId;
    }

    @Override
    public synchronized void cancel() {
        if (!this.isRepairUpload() && this.getTmpFileName().exists()) {
            super.cancel();
            LOGGER.debug("Deleting file " + this.getTmpFileName(), (Throwable)new RuntimeException());
            FileSystem.deleteAsync(this.getTmpFileName());
        }
    }

    public boolean isRepairUpload() {
        return this.owner == null;
    }

    public UserInfo getOwner() {
        return this.owner;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected boolean hasEnoughFreeSpace() {
        return FileSystem.getAvailableStorageBytes() > FileServer.MIN_FREE_SPACE_BYTES;
    }

    @Override
    public TransferInformation getTransferInfo() {
        return new TransferInformation(this.getId(), FileServer.instance().getPlainPort(), FileServer.instance().getSslPort());
    }

    @Override
    public String getRelativePath() {
        return FileSystem.getRelativePath(this.getTmpFileName(), Configuration.getVmStoreBasePath());
    }

    @Override
    protected void chunkStatusChanged(FileChunk chunk) {
        ChunkStatus status;
        if (chunk.getFailCount() > 3) {
            this.cancel();
            this.errorMessage = "Uploaded file is corrupted - did you modify the VM while uploading?";
            DbLog.log(this.owner, this.image.imageBaseId, "Server is cancelling upload of version " + this.getVersionId() + " for '" + this.image.imageName + "': Hash check for block " + chunk.getChunkIndex() + " failed " + chunk.getFailCount() + " times. Maybe the user was still running the VM when starting the upload.");
        }
        if (this.isRepairUpload() && ((status = chunk.getStatus()) == ChunkStatus.MISSING || status == ChunkStatus.COMPLETE)) {
            try {
                DbImageBlock.asyncUpdate(this.getVersionId(), chunk);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean chunkReceived(FileChunk chunk, byte[] data) {
        SscMode sscMode = RuntimeConfig.get().serverSideCopy;
        if (sscMode == SscMode.AUTO) {
            long bytes;
            long diff = 0L;
            AtomicInteger atomicInteger = this.speedCounter;
            synchronized (atomicInteger) {
                bytes = this.speedCounter.addAndGet(chunk.range.getLength());
                if (bytes >= 0x3000000L) {
                    diff = System.currentTimeMillis() - this.speedTimestamp;
                    this.speedTimestamp = System.currentTimeMillis();
                }
            }
            if (diff >= 1000L && diff < 100000000L) {
                long speed = bytes / (diff / 1000L);
                if (speed < 0xA00000L) {
                    super.enableServerSideCopying(true);
                } else if (speed > 0x1400000L) {
                    super.enableServerSideCopying(false);
                }
            }
        } else {
            this.speedTimestamp = 0L;
            if (sscMode == SscMode.OFF) {
                super.enableServerSideCopying(false);
            } else if (sscMode == SscMode.ON) {
                super.enableServerSideCopying(true);
            }
        }
        if (IncomingDataTransfer.getHashChecker() == null) {
            return false;
        }
        try {
            IncomingDataTransfer.getHashChecker().queue(chunk, data, null, 5);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public UploadOptions setOptions(UploadOptions options) {
        if (RuntimeConfig.get().serverSideCopy == SscMode.USER && options != null && options.isSetServerSideCopying()) {
            super.enableServerSideCopying(options.serverSideCopying);
        }
        return new UploadOptions(super.isServerSideCopyingEnabled());
    }
}

