/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.fileserv;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.thrift.iface.TInvalidTokenException;
import org.openslx.bwlp.thrift.iface.TransferInformation;
import org.openslx.filetransfer.Uploader;
import org.openslx.filetransfer.util.OutgoingTransferBase;
import org.openslx.thrifthelper.ThriftManager;

public class OutgoingDataTransfer
extends OutgoingTransferBase {
    private static final Logger LOGGER = LogManager.getLogger(OutgoingDataTransfer.class);
    private final TransferInformation masterTransferInfo;
    private final String versionId;

    public OutgoingDataTransfer(String uuid, File file, int plainPort, int sslPort, String versionId) {
        super(uuid, file, plainPort, sslPort);
        this.masterTransferInfo = null;
        this.versionId = versionId;
    }

    public OutgoingDataTransfer(TransferInformation transferInfo, File absFile, String versionId) {
        super(transferInfo.token, absFile, 0, 0);
        this.masterTransferInfo = transferInfo;
        this.versionId = versionId;
    }

    public synchronized void heartBeat(ExecutorService pool) {
        if (this.masterTransferInfo == null) {
            return;
        }
        if (this.connectFailCount() > 50) {
            return;
        }
        if (this.connectFailCount() > 5) {
            try {
                ThriftManager.getMasterClient().queryUploadStatus(this.masterTransferInfo.token);
            }
            catch (TInvalidTokenException e) {
                LOGGER.info("Master server forgot about upload " + this.masterTransferInfo.token + ", aborting...");
                this.connectFails.set(100);
                return;
            }
            catch (TException e) {
                LOGGER.warn("Cannot query master server for upload status of " + this.masterTransferInfo.token, (Throwable)e);
            }
        }
        if (this.getActiveConnectionCount() >= 1) {
            return;
        }
        Uploader uploader = null;
        Exception connectException = null;
        if (uploader == null && this.masterTransferInfo.sslPort != 0 && Configuration.getMasterServerSsl()) {
            try {
                uploader = new Uploader(Configuration.getMasterServerAddress(), this.masterTransferInfo.sslPort, 10000, SSLContext.getDefault(), this.masterTransferInfo.token);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                connectException = e;
            }
        }
        if (uploader == null && this.masterTransferInfo.plainPort != 0) {
            try {
                uploader = new Uploader(Configuration.getMasterServerAddress(), this.masterTransferInfo.plainPort, 10000, null, this.masterTransferInfo.token);
            }
            catch (IOException e) {
                uploader = null;
                connectException = e;
            }
        }
        if (uploader == null) {
            LOGGER.debug("Cannot connect to master server for uploading", (Throwable)connectException);
        } else {
            this.runConnectionInternal(uploader, pool);
        }
    }

    @Override
    public String getRelativePath() {
        throw new RuntimeException("Not implemented");
    }

    public Object getVersionId() {
        return this.versionId;
    }
}

