/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.fileserv;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbImageBlock;
import org.openslx.bwlp.sat.database.mappers.DbUser;
import org.openslx.bwlp.sat.database.models.ImageVersionMeta;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.fileserv.IncomingDataTransfer;
import org.openslx.bwlp.sat.fileserv.OutgoingDataTransfer;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePublishData;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.InvocationError;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.TTransferRejectedException;
import org.openslx.bwlp.thrift.iface.TransferInformation;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.CascadedThreadPoolExecutor;
import org.openslx.util.PrioThreadFactory;
import org.openslx.util.QuickTimer;

public class SyncTransferHandler {
    private static final Logger LOGGER = LogManager.getLogger(SyncTransferHandler.class);
    private static final CascadedThreadPoolExecutor transferPool = new CascadedThreadPoolExecutor(1, 5, 1L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), (ThreadFactory)new PrioThreadFactory("MTransf", 2), null);
    private static final Map<String, IncomingDataTransfer> downloads = new ConcurrentHashMap<String, IncomingDataTransfer>();
    private static final Map<String, OutgoingDataTransfer> uploadsByTransferId = new ConcurrentHashMap<String, OutgoingDataTransfer>();
    private static final Map<String, OutgoingDataTransfer> uploadsByVersionId = new ConcurrentHashMap<String, OutgoingDataTransfer>();
    private static QuickTimer.Task heartBeatTask = new QuickTimer.Task(){
        private int skips = 0;
        private final Runnable worker = new Runnable(){

            @Override
            public void run() {
                OutgoingDataTransfer upload;
                long now = System.currentTimeMillis();
                Iterator it = downloads.values().iterator();
                while (it.hasNext()) {
                    IncomingDataTransfer download = (IncomingDataTransfer)it.next();
                    if (download.isActive()) {
                        download.heartBeat(transferPool);
                    }
                    if (download.isComplete(now)) {
                        LOGGER.info("Download <" + download.getId() + "> from master server complete");
                        it.remove();
                        continue;
                    }
                    if (!download.hasReachedIdleTimeout(now) && download.connectFailCount() <= 50) continue;
                    LOGGER.info("Download <" + download.getId() + "> errored out");
                    it.remove();
                }
                it = uploadsByTransferId.values().iterator();
                while (it.hasNext()) {
                    upload = (OutgoingDataTransfer)it.next();
                    if (upload.isActive()) {
                        upload.heartBeat(transferPool);
                    }
                    if (upload.isComplete(now)) {
                        LOGGER.info("Upload <" + upload.getId() + "> to master server complete");
                        it.remove();
                        continue;
                    }
                    if (!upload.hasReachedIdleTimeout(now) && upload.connectFailCount() <= 50) continue;
                    LOGGER.info("Upload <" + upload.getId() + "> errored out");
                    it.remove();
                }
                it = uploadsByVersionId.values().iterator();
                while (it.hasNext()) {
                    upload = (OutgoingDataTransfer)it.next();
                    if (upload.isComplete(now)) {
                        it.remove();
                        continue;
                    }
                    if (!upload.hasReachedIdleTimeout(now) && upload.connectFailCount() <= 50) continue;
                    it.remove();
                }
            }
        };

        @Override
        public synchronized void fire() {
            if (uploadsByTransferId.isEmpty() && uploadsByVersionId.isEmpty() && downloads.isEmpty()) {
                return;
            }
            if (transferPool.getMaximumPoolSize() - transferPool.getActiveCount() < 2 && ++this.skips < 10) {
                return;
            }
            this.skips = 0;
            transferPool.execute(this.worker);
        }
    };

    public static synchronized String requestImageUpload(String userToken, ImageSummaryRead imgBase, LocalImageVersion imgVersion) throws SQLException, TNotFoundException, TInvocationException, TAuthorizationException, TTransferRejectedException {
        TransferInformation transferInfo;
        OutgoingDataTransfer existing = uploadsByVersionId.get(imgVersion.imageVersionId);
        if (existing != null) {
            LOGGER.info("Upload of image " + imgVersion.imageVersionId + " of '" + imgBase.imageName + "' to master is already in progess via " + existing.getId());
            return existing.getId();
        }
        File absFile = FileSystem.composeAbsoluteImagePath(imgVersion);
        if (!absFile.isFile() || !absFile.canRead()) {
            LOGGER.error("Cannot upload " + imgVersion.imageVersionId + " of '" + imgBase.imageName + "': file missing: " + absFile.getAbsolutePath());
            DbImage.markValid(false, true, imgVersion);
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "Source file not readable");
        }
        if (absFile.length() != imgVersion.fileSize) {
            LOGGER.error("Cannot upload" + imgVersion.imageVersionId + " of '" + imgBase.imageName + "': wrong file size - expected " + imgVersion.fileSize + ", got " + absFile.length());
            DbImage.markValid(false, true, imgVersion);
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "File corrupted on satellite server");
        }
        SyncTransferHandler.checkUploadCount();
        ImageVersionMeta versionDetails = DbImage.getVersionDetails(imgVersion.imageVersionId);
        if (versionDetails == null || versionDetails.machineDescription == null || versionDetails.machineDescription.length == 0) {
            throw new TInvocationException(InvocationError.MISSING_DATA, "Given virtual machine has no hardware description");
        }
        ImageDetailsRead details = DbImage.getImageDetails(null, imgVersion.imageBaseId);
        List<ByteBuffer> blockHashes = DbImageBlock.getBlockHashes(imgVersion.imageVersionId);
        ImagePublishData publishData = new ImagePublishData();
        publishData.createTime = imgVersion.createTime;
        publishData.description = details.description;
        publishData.fileSize = imgVersion.fileSize;
        publishData.imageBaseId = imgVersion.imageBaseId;
        publishData.imageName = details.imageName;
        publishData.imageVersionId = imgVersion.imageVersionId;
        publishData.isTemplate = details.isTemplate;
        publishData.osId = details.osId;
        publishData.uploader = DbUser.getOrNull(imgVersion.uploaderId);
        publishData.owner = DbUser.getOrNull(imgBase.ownerId);
        publishData.virtId = details.virtId;
        publishData.machineDescription = ByteBuffer.wrap(versionDetails.machineDescription);
        try {
            transferInfo = ThriftManager.getMasterClient().submitImage(userToken, publishData, blockHashes);
        }
        catch (TAuthorizationException e) {
            LOGGER.warn("Master server rejected our session on uploadImage", (Throwable)e);
            throw e;
        }
        catch (TInvocationException e) {
            LOGGER.warn("Master server made a boo-boo on uploadImage", (Throwable)e);
            throw e;
        }
        catch (TTransferRejectedException e) {
            LOGGER.warn("Master server rejected our upload request", (Throwable)e);
            throw e;
        }
        catch (TException e) {
            LOGGER.warn("Unknown exception on uploadImage to master server", (Throwable)e);
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "Communication with master server failed");
        }
        OutgoingDataTransfer transfer = new OutgoingDataTransfer(transferInfo, absFile, imgVersion.imageVersionId);
        uploadsByVersionId.put(imgVersion.imageVersionId, transfer);
        uploadsByTransferId.put(transfer.getId(), transfer);
        heartBeatTask.fire();
        return transfer.getId();
    }

    public static synchronized String requestImageDownload(String userToken, ImagePublishData image) throws TInvocationException, TAuthorizationException, TNotFoundException {
        File tmpFile;
        LocalImageVersion localImageData;
        TransferInformation transferInfo;
        IncomingDataTransfer existing = downloads.get(image.imageVersionId);
        if (existing != null) {
            return existing.getId();
        }
        SyncTransferHandler.checkDownloadCount();
        try {
            transferInfo = ThriftManager.getMasterClient().downloadImage(userToken, image.imageVersionId);
        }
        catch (TAuthorizationException e) {
            LOGGER.warn("Master server rejected our session on downloadImage", (Throwable)e);
            throw e;
        }
        catch (TInvocationException e) {
            LOGGER.warn("Master server made a boo-boo on downloadImage", (Throwable)e);
            throw e;
        }
        catch (TNotFoundException e) {
            LOGGER.warn("Master server couldn't find image on downloadImage", (Throwable)e);
            throw e;
        }
        catch (TException e) {
            LOGGER.warn("Master server made a boo-boo on downloadImage", (Throwable)e);
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "Communication with master server failed");
        }
        try {
            localImageData = DbImage.getLocalImageData(image.imageVersionId);
        }
        catch (TNotFoundException e) {
            localImageData = null;
        }
        catch (SQLException e) {
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "Database error");
        }
        if (localImageData == null) {
            tmpFile = null;
            while ((tmpFile = Formatter.getTempImageName()).exists()) {
            }
        } else {
            tmpFile = FileSystem.composeAbsoluteImagePath(localImageData);
        }
        tmpFile.getParentFile().mkdirs();
        try {
            IncomingDataTransfer transfer = new IncomingDataTransfer(image, tmpFile, transferInfo, localImageData != null);
            downloads.put(transfer.getId(), transfer);
            heartBeatTask.fire();
            return transfer.getId();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not open " + tmpFile.getAbsolutePath());
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "Could not access local file for writing");
        }
    }

    private static void checkDownloadCount() throws TInvocationException {
        Iterator<IncomingDataTransfer> it = downloads.values().iterator();
        long now = System.currentTimeMillis();
        int activeDownloads = 0;
        while (it.hasNext()) {
            IncomingDataTransfer upload = it.next();
            if (upload.isComplete(now) || upload.hasReachedIdleTimeout(now)) {
                upload.cancel();
                it.remove();
                continue;
            }
            if (!upload.countsTowardsConnectionLimit(now)) continue;
            ++activeDownloads;
        }
        if (activeDownloads >= 3) {
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "Server busy. Too many running downloads (" + activeDownloads + "/" + 3 + ").");
        }
    }

    private static void checkUploadCount() throws TInvocationException {
        Iterator<OutgoingDataTransfer> it = uploadsByTransferId.values().iterator();
        long now = System.currentTimeMillis();
        int activeUploads = 0;
        while (it.hasNext()) {
            OutgoingDataTransfer download = it.next();
            if (download.isComplete(now) || download.hasReachedIdleTimeout(now)) {
                download.cancel();
                it.remove();
                continue;
            }
            if (!download.countsTowardsConnectionLimit(now)) continue;
            ++activeUploads;
        }
        if (activeUploads >= 2) {
            throw new TInvocationException(InvocationError.INTERNAL_SERVER_ERROR, "Server busy. Too many running uploads (" + activeUploads + "/" + 2 + ").");
        }
    }

    public static OutgoingDataTransfer getUploadByToken(String uploadToken) {
        if (uploadToken == null) {
            return null;
        }
        return uploadsByTransferId.get(uploadToken);
    }

    public static IncomingDataTransfer getDownloadByToken(String downloadToken) {
        if (downloadToken == null) {
            return null;
        }
        return downloads.get(downloadToken);
    }

    public static boolean isActiveTransfer(String baseId, String versionId) {
        OutgoingDataTransfer odt;
        if (versionId != null && (odt = uploadsByVersionId.get(versionId)) != null && !odt.isComplete(System.currentTimeMillis()) && odt.isActive()) {
            return true;
        }
        long now = System.currentTimeMillis();
        for (IncomingDataTransfer idt : downloads.values()) {
            if (idt.isComplete(now) || !idt.isActive()) continue;
            if (versionId != null && versionId.equals(idt.getVersionId())) {
                return true;
            }
            if (baseId == null || !baseId.equals(idt.getBaseId())) continue;
            return true;
        }
        return false;
    }

    static {
        transferPool.allowCoreThreadTimeOut(true);
        QuickTimer.scheduleAtFixedDelay(heartBeatTask, 123L, TimeUnit.SECONDS.toMillis(56L));
    }
}

