/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.fileserv.cow;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.fileserv.cow.CowSession;
import org.openslx.bwlp.sat.fileserv.cow.CowSessionData;
import org.openslx.bwlp.sat.permissions.User;
import org.openslx.bwlp.sat.thrift.cache.OperatingSystemList;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.thrift.iface.ImageBaseWrite;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImageVersionWrite;
import org.openslx.filetransfer.util.ChunkList;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.filetransfer.util.HashChecker;
import org.openslx.filetransfer.util.IncomingTransferBase;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;

public class CowFinalizer {
    private static final Logger LOGGER = LogManager.getLogger(CowFinalizer.class);
    private ChunkList chunks;
    private boolean hashesDone;
    private final CowSessionData data;
    private String error;
    private int progressPercent;
    private CowSession cowSession;
    private final Thread worker = new Thread("cow-work"){

        @Override
        public void run() {
            String relPath;
            block21: {
                relPath = FileSystem.getRelativePath(((CowFinalizer)CowFinalizer.this).data.destinationFile, Configuration.getVmStoreBasePath());
                if (relPath == null) {
                    CowFinalizer.this.setError(((CowFinalizer)CowFinalizer.this).data.destinationFile.getAbsolutePath() + " is not a subdir of " + Configuration.getVmStoreBasePath().getAbsolutePath());
                    return;
                }
                try {
                    CowFinalizer.this.calculateHashes();
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot calculate hashes of new image, continuing without", (Throwable)e);
                }
                if (CowFinalizer.this.hashesDone) {
                    try {
                        FileUtils.writeByteArrayToFile(new File(((CowFinalizer)CowFinalizer.this).data.destinationFile + ".crc"), CowFinalizer.this.chunks.getDnbd3Crc32List());
                    }
                    catch (IOException | IllegalStateException e) {
                        LOGGER.warn("Could not write dnbd3 crc list", (Throwable)e);
                    }
                }
                try {
                    Files.move(((CowFinalizer)CowFinalizer.this).data.temporaryImageFile.toPath(), ((CowFinalizer)CowFinalizer.this).data.destinationFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException e1) {
                    LOGGER.warn("Cannot rename", (Throwable)e1);
                    if (((CowFinalizer)CowFinalizer.this).data.temporaryImageFile.renameTo(((CowFinalizer)CowFinalizer.this).data.destinationFile)) break block21;
                    CowFinalizer.this.setError("Renaming temporary file to final name failed");
                    return;
                }
            }
            String uuid = UUID.randomUUID().toString();
            try {
                boolean copy = true;
                if ("EDIT".equals(((CowFinalizer)CowFinalizer.this).data.sessionType)) {
                    try {
                        User.canEditBaseImageOrFail(((CowFinalizer)CowFinalizer.this).data.owner, ((CowFinalizer)CowFinalizer.this).data.imageBaseId);
                        copy = false;
                    }
                    catch (Exception e) {
                        LOGGER.info("Permission check for EDIT failed, falling back to COPY");
                    }
                }
                String baseId = ((CowFinalizer)CowFinalizer.this).data.imageBaseId;
                if (copy) {
                    String imgName;
                    ImageBaseWrite ibw = new ImageBaseWrite();
                    ImageDetailsRead id = null;
                    try {
                        id = DbImage.getImageDetails(null, ((CowFinalizer)CowFinalizer.this).data.imageBaseId);
                        imgName = id.imageName;
                    }
                    catch (Exception e) {
                        imgName = "[UNKNOWN VM]";
                    }
                    ibw.setImageName("Copy of " + imgName);
                    if (id != null) {
                        ibw.setDefaultPermissions(id.defaultPermissions);
                        ibw.setDescription(ibw.imageName);
                        ibw.setOsId(id.osId);
                        ibw.setVirtId(id.virtId);
                    } else {
                        try {
                            VirtualizationConfiguration conf = VirtualizationConfiguration.getInstance(OperatingSystemList.get(), ((CowFinalizer)CowFinalizer.this).data.machineDescription, ((CowFinalizer)CowFinalizer.this).data.machineDescription.length);
                            ibw.setVirtId(conf.getVirtualizer().getId());
                        }
                        catch (IOException | VirtualizationConfigurationException e) {
                            LOGGER.error("Can neither get virtID from existing image, nor guess from description", (Throwable)e);
                        }
                    }
                    baseId = DbImage.createImage(((CowFinalizer)CowFinalizer.this).data.owner, ibw.imageName);
                    DbImage.updateImageMetadata(null, baseId, ibw);
                }
                DbImage.createImageVersion(baseId, uuid, ((CowFinalizer)CowFinalizer.this).data.owner, CowFinalizer.this.data.newFileSize(), relPath, new ImageVersionWrite(((CowFinalizer)CowFinalizer.this).data.restricted), CowFinalizer.this.hashesDone ? CowFinalizer.this.chunks : null, ((CowFinalizer)CowFinalizer.this).data.machineDescription);
            }
            catch (SQLException e) {
                CowFinalizer.this.setError("Cannot write new version to database");
                return;
            }
            LOGGER.info("Processing CoW session done.");
            CowFinalizer.this.progressPercent = 100;
            if (CowFinalizer.this.cowSession != null) {
                CowFinalizer.this.cowSession.finalizerFinished();
                CowFinalizer.this.cowSession = null;
            }
        }
    };

    public CowFinalizer(CowSessionData data, CowSession cowSession) {
        this.data = data;
        this.cowSession = cowSession;
        if (data.newFileSize() == -1L) {
            throw new IllegalStateException("Initialized finalizer before new file size was set");
        }
        this.worker.start();
    }

    private void setError(String msg) {
        if (this.error != null) {
            return;
        }
        LOGGER.warn(msg);
        this.error = msg;
        if (this.cowSession != null) {
            this.cowSession.finalizerFinished();
            this.cowSession = null;
        }
    }

    public int progressPercent() {
        return this.progressPercent;
    }

    public String getError() {
        return this.error;
    }

    private void calculateHashes() throws IOException {
        HashChecker hc = IncomingTransferBase.getHashChecker();
        if (hc == null) {
            LOGGER.info("No hash checker, skipping...");
            return;
        }
        try (RandomAccessFile file = new RandomAccessFile(this.data.temporaryImageFile, "r");){
            this.chunks = new ChunkList(this.data.temporaryImageFile.length(), null);
            final int chunkCount = this.chunks.getAll().size();
            final Semaphore pendingChunks = new Semaphore(0);
            HashChecker.HashCheckCallback cb = new HashChecker.HashCheckCallback(){

                @Override
                public void hashCheckDone(HashChecker.HashResult result, byte[] data, FileChunk chunk) {
                    pendingChunks.release();
                    CowFinalizer.this.progressPercent = pendingChunks.availablePermits() * 100 / (chunkCount + 1);
                }
            };
            for (FileChunk chunk : this.chunks.getAll()) {
                byte[] buffer = new byte[chunk.range.getLength()];
                file.readFully(buffer);
                hc.queue(chunk, buffer, cb, 29);
            }
            pendingChunks.acquire(chunkCount);
            this.progressPercent = 99;
            this.hashesDone = true;
        }
        catch (InterruptedException e) {
            LOGGER.info("Interrupted while hashing");
            Thread.currentThread().interrupt();
            return;
        }
    }
}

