/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.fileserv.cow;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.fileserv.cow.Cow;
import org.openslx.bwlp.sat.fileserv.cow.CowFinalizer;
import org.openslx.bwlp.sat.fileserv.cow.CowSessionData;
import org.openslx.bwlp.sat.permissions.User;
import org.openslx.bwlp.sat.util.Configuration;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.Json;
import org.openslx.util.Util;

public class CowSession {
    private static final Logger LOGGER = LogManager.getLogger(CowSession.class);
    private static final long FINISHED_TIMEOUT_MS = 300000L;
    private static final long ACTIVE_TIMEOUT_MS = 900000L;
    private static int ABANDONED_TIMEOUT_MS = 43200000;
    private static int COPY_BLOCK_SIZE = 0x100000;
    public long lastActivity = Util.tickCount();
    private final long sourceFileSize;
    private RandomAccessFile sourceFile;
    private RandomAccessFile destinationFile;
    private Thread copyThread;
    private Status status = Status.COPYING;
    private final CowSessionData data;
    private long estimatedSpeedKbs = 0L;
    private final Object destFileLock = new Object();
    private final Object varLock = new Object();
    private long fileCopyPosition = 0L;
    private String errorMessage;
    private String lastErrorMessage;
    private CowFinalizer finalizer;

    public CowSession(String sourceFileName, byte[] machineDescription, String imageBaseId, String vmName, boolean restricted, UserInfo owner, String sessionType) throws RuntimeException {
        RandomAccessFile srcFile;
        if ("EDIT".equals(sessionType)) {
            try {
                User.canEditBaseImageOrFail(owner, imageBaseId);
            }
            catch (TAuthorizationException | TInvocationException | TNotFoundException e) {
                LOGGER.warn(Formatter.userFullName(owner) + " requested EDIT CoW session, but no permission", (Throwable)e);
                throw new RuntimeException("EDIT permission denied");
            }
        }
        long sfl = -1L;
        try {
            srcFile = new RandomAccessFile(Configuration.getVmStoreBasePath() + "/" + sourceFileName, "r");
        }
        catch (IOException e) {
            LOGGER.error("Cannot open source file for reading", (Throwable)e);
            throw new RuntimeException("Cannot open source file for reading");
        }
        try {
            sfl = srcFile.length();
        }
        catch (IOException e) {
            LOGGER.error("Cannot determine size of source file", (Throwable)e);
            throw new RuntimeException("Cannot determine size of source file");
        }
        File tmpFile = null;
        while ((tmpFile = Formatter.getTempImageName()).exists()) {
        }
        tmpFile.getParentFile().mkdirs();
        String ext = sourceFileName.replaceFirst("^.*\\.", "");
        File finalFile = new File(tmpFile.getParent(), Formatter.vmName(System.currentTimeMillis(), owner, vmName, ext)).getAbsoluteFile();
        RandomAccessFile df = null;
        try {
            df = new RandomAccessFile(tmpFile, "rw");
        }
        catch (Exception e) {
            Util.safeClose(srcFile);
            LOGGER.error("Cannot open destination file for writing", (Throwable)e);
            throw new RuntimeException("Cannot open destination file for writing");
        }
        this.sourceFileSize = sfl;
        this.sourceFile = srcFile;
        this.destinationFile = df;
        this.data = new CowSessionData(imageBaseId, restricted, tmpFile, finalFile, owner, machineDescription, sessionType);
        LOGGER.info("Started new " + sessionType + " CoW session for " + Formatter.userFullName(owner));
        this.startCopying();
    }

    public boolean timedout() {
        if (this.status == Status.COMPLETELY_DONE || this.status == Status.ERROR) {
            return Util.tickCount() > this.lastActivity + 300000L;
        }
        return Util.tickCount() > this.lastActivity + (long)ABANDONED_TIMEOUT_MS;
    }

    public boolean isActive() {
        if (this.status == Status.COMPLETELY_DONE || this.status == Status.ERROR) {
            return false;
        }
        return Util.tickCount() < this.lastActivity + 900000L;
    }

    public String getError() {
        return this.errorMessage;
    }

    public String getStatusJson() {
        JsonStatus ret = new JsonStatus();
        if (this.status == Status.COPYING || this.status == Status.WAITING_FOR_COPYING_DONE) {
            ret.tasks.add(new ProgressItem("Copying source file", (int)(this.fileCopyPosition * 100L / this.sourceFileSize), this.errorMessage));
        } else {
            ret.tasks.add(new ProgressItem("Copying source file", 100, null));
        }
        if (this.finalizer != null) {
            ret.tasks.add(new ProgressItem("Hashing modified image", this.finalizer.progressPercent(), this.finalizer.getError()));
        }
        ret.state = this.status.name();
        return Json.serialize(ret);
    }

    private void setStatus(Status s) {
        if (this.status == Status.ERROR || this.status == Status.COMPLETELY_DONE) {
            return;
        }
        if (s != Status.ERROR) {
            boolean illegal = false;
            switch (this.status) {
                case ERROR: 
                case COMPLETELY_DONE: {
                    break;
                }
                case COPYING: {
                    illegal = s != Status.WAITING_FOR_UPLOAD_DONE && s != Status.WAITING_FOR_COPYING_DONE;
                    break;
                }
                case WAITING_FOR_UPLOAD_DONE: {
                    illegal = s != Status.UPLOAD_DONE;
                    break;
                }
                case WAITING_FOR_COPYING_DONE: {
                    illegal = s != Status.UPLOAD_DONE;
                    break;
                }
                case UPLOAD_DONE: {
                    illegal = s != Status.PROCESSING;
                    break;
                }
                case PROCESSING: {
                    boolean bl = illegal = s != Status.COMPLETELY_DONE;
                }
            }
            if (illegal) {
                LOGGER.log(Level.ERROR, "Illegal state change: " + (Object)((Object)this.status) + " -> " + (Object)((Object)s), (Throwable)new RuntimeException());
            }
        }
        this.status = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transition(Status from, Status to) {
        Object object = this.varLock;
        synchronized (object) {
            if (this.status != from) {
                return false;
            }
            this.setStatus(to);
        }
        return true;
    }

    private void setError(String message, Exception e) {
        if (this.lastErrorMessage == null || !this.lastErrorMessage.equals(message)) {
            LOGGER.log(Level.ERROR, message, (Throwable)e);
            this.lastErrorMessage = message;
        }
        if (this.errorMessage == null) {
            this.errorMessage = message;
            this.setStatus(Status.ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.varLock;
        synchronized (object) {
            if (this.status == Status.ERROR || this.status == Status.COMPLETELY_DONE) {
                return;
            }
            this.setError("Session aborted by user", null);
        }
        object = this.destFileLock;
        synchronized (object) {
            Util.safeClose(this.destinationFile);
            this.destinationFile = null;
        }
        LOGGER.info("Deleting " + this.data.temporaryImageFile.getPath());
        try {
            Files.delete(this.data.temporaryImageFile.toPath());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Cannot delete CoW file for aborted session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFinished(long newFileSize) throws IllegalTransitionException {
        Object object = this.varLock;
        synchronized (object) {
            if (!this.transition(Status.WAITING_FOR_UPLOAD_DONE, Status.UPLOAD_DONE) && !this.transition(Status.COPYING, Status.WAITING_FOR_COPYING_DONE)) {
                throw new IllegalTransitionException("Cannot mark upload as finished, unexpected state " + (Object)((Object)this.status));
            }
        }
        LOGGER.info("Upload of clusters for '" + this.data.destinationFile + "' finished, final size: " + newFileSize);
        this.data.setFinalSize(newFileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFinalization() throws IllegalTransitionException {
        Object object = this.varLock;
        synchronized (object) {
            if (!this.transition(Status.UPLOAD_DONE, Status.PROCESSING)) {
                throw new IllegalTransitionException("Cannot finish before upload is complete");
            }
            Util.safeClose(this.destinationFile);
            this.destinationFile = null;
            LOGGER.info("Finalization of '" + this.data.destinationFile + "' requested");
            this.finalizer = new CowFinalizer(this.data, this);
            this.lastActivity = Util.tickCount();
        }
    }

    void finalizerFinished() {
        if (this.finalizer == null) {
            return;
        }
        if (this.finalizer.getError() == null) {
            this.setStatus(Status.COMPLETELY_DONE);
        } else {
            this.setStatus(Status.ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCluster(long clusterIndex, byte[] rawData) {
        if (rawData.length < Cow.BITFIELD_SIZE) {
            LOGGER.warn("Short cluster upload: Not enough payload for bitfield (" + rawData.length + " bytes)");
            return -1;
        }
        int readPos = Cow.BITFIELD_SIZE;
        Object object = this.destFileLock;
        synchronized (object) {
            if (this.destinationFile == null) {
                this.setError("Destination file already closed", null);
                return -1;
            }
            for (int byt = 0; byt < Cow.BITFIELD_SIZE; ++byt) {
                int bytVal = rawData[byt] & 0xFF;
                for (int bit = 0; bit < 8; ++bit) {
                    if ((bytVal & 1 << bit) == 0) continue;
                    if (readPos + Cow.BLOCK_SIZE > rawData.length) {
                        LOGGER.warn("Not enough data payload for COW block (short of " + (readPos + Cow.BLOCK_SIZE - rawData.length) + " bytes)");
                        return -1;
                    }
                    int ret = this.writeBlock(clusterIndex * (long)Cow.BITFIELD_BITS + (long)(byt * 8) + (long)bit, rawData, readPos);
                    if (ret != 0) {
                        return ret;
                    }
                    readPos += Cow.BLOCK_SIZE;
                }
            }
        }
        this.lastActivity = Util.tickCount();
        return 0;
    }

    private int writeBlock(long blockIndex, byte[] rawData, int readArrayStart) {
        if (this.status == Status.ERROR) {
            return -1;
        }
        long filePos = blockIndex * (long)Cow.BLOCK_SIZE;
        long missing = filePos + (long)Cow.BLOCK_SIZE - this.fileCopyPosition;
        if (this.status == Status.COPYING && missing > 0L) {
            int delay = 30;
            if (this.estimatedSpeedKbs > 0L) {
                delay = (int)(missing / 1000L / this.estimatedSpeedKbs);
            }
            if (delay < 1) {
                delay = 1;
            }
            LOGGER.info("Throttling client - Missing: " + Util.formatBytes(missing) + ", Speed: " + Util.formatBytes(this.estimatedSpeedKbs * 1000L) + "/s, Wait: " + delay);
            return delay;
        }
        try {
            this.destinationFile.seek(filePos);
            this.destinationFile.write(rawData, readArrayStart, Cow.BLOCK_SIZE);
        }
        catch (IOException e) {
            this.setError("Cannot write changed cluster to destination file, aborting CoW session", e);
            Util.safeClose(this.destinationFile);
            this.destinationFile = null;
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCopying() {
        Thread t = new Thread("CoW-Copy"){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void updateSpeedEstimate(long[] history) {
                long sum = 0L;
                for (int i = 0; i < history.length; ++i) {
                    sum += history[i];
                }
                CowSession.this.estimatedSpeedKbs = sum / (long)history.length;
            }
        };
        Object object = this.varLock;
        synchronized (object) {
            this.copyThread = t;
            this.copyThread.setDaemon(true);
            this.copyThread.start();
        }
    }

    static /* synthetic */ int access$100() {
        return COPY_BLOCK_SIZE;
    }

    static /* synthetic */ RandomAccessFile access$200(CowSession x0) {
        return x0.sourceFile;
    }

    static /* synthetic */ long access$300(CowSession x0) {
        return x0.fileCopyPosition;
    }

    static /* synthetic */ long access$400(CowSession x0) {
        return x0.sourceFileSize;
    }

    static /* synthetic */ void access$500(CowSession x0, String x1, Exception x2) {
        x0.setError(x1, x2);
    }

    static /* synthetic */ Object access$600(CowSession x0) {
        return x0.destFileLock;
    }

    static /* synthetic */ RandomAccessFile access$700(CowSession x0) {
        return x0.destinationFile;
    }

    static /* synthetic */ long access$314(CowSession x0, long x1) {
        return x0.fileCopyPosition += x1;
    }

    static /* synthetic */ Object access$800(CowSession x0) {
        return x0.varLock;
    }

    static /* synthetic */ boolean access$900(CowSession x0, Status x1, Status x2) {
        return x0.transition(x1, x2);
    }

    static /* synthetic */ Status access$1000(CowSession x0) {
        return x0.status;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static /* synthetic */ RandomAccessFile access$202(CowSession x0, RandomAccessFile x1) {
        x0.sourceFile = x1;
        return x0.sourceFile;
    }

    static /* synthetic */ Thread access$1202(CowSession x0, Thread x1) {
        x0.copyThread = x1;
        return x0.copyThread;
    }

    private static class JsonStatus {
        String state;
        List<ProgressItem> tasks = new ArrayList<ProgressItem>();

        private JsonStatus() {
        }
    }

    private static class ProgressItem {
        public final String title;
        public final int percent;
        public final String error;

        public ProgressItem(String title, int percent, String error) {
            this.title = title;
            this.percent = percent;
            this.error = error;
        }
    }

    public static class IllegalTransitionException
    extends Exception {
        private static final long serialVersionUID = -6792998975872772519L;

        public IllegalTransitionException(String message) {
            super(message);
        }
    }

    static enum Status {
        COPYING,
        WAITING_FOR_UPLOAD_DONE,
        WAITING_FOR_COPYING_DONE,
        UPLOAD_DONE,
        PROCESSING,
        ERROR,
        COMPLETELY_DONE;

    }
}

