/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.fileserv.cow;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openslx.bwlp.sat.database.mappers.DbLecture;
import org.openslx.bwlp.sat.fileserv.cow.CowSession;
import org.openslx.bwlp.sat.thrift.SessionManager;
import org.openslx.bwlp.sat.util.Constants;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.QuickTimer;

public class CowSessionManager {
    private static final ReadWriteLock SESSION_LOCK = new ReentrantReadWriteLock();
    private static final Map<String, CowSession> SESSIONS = new HashMap<String, CowSession>();

    public static CowSession get(String id) {
        Lock lock = SESSION_LOCK.readLock();
        lock.lock();
        try {
            CowSession cowSession = SESSIONS.get(id);
            return cowSession;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean add(String id, CowSession session) {
        Lock lock = SESSION_LOCK.writeLock();
        lock.lock();
        try {
            if (SESSIONS.containsKey(id)) {
                boolean bl = false;
                return bl;
            }
            SESSIONS.put(id, session);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActiveCount() {
        int cnt = 0;
        Lock lock = SESSION_LOCK.readLock();
        lock.lock();
        try {
            for (CowSession s : SESSIONS.values()) {
                if (!s.isActive()) continue;
                ++cnt;
            }
        }
        finally {
            lock.unlock();
        }
        return cnt;
    }

    public static String create(String cowid, DbLecture.LaunchData ld, String sessionType) throws RuntimeException {
        UserInfo user = SessionManager.get(cowid);
        if (user == null) {
            throw new RuntimeException("Unknown user");
        }
        SessionManager.remove(cowid);
        if (CowSessionManager.getActiveCount() > Constants.MAX_UPLOADS) {
            throw new RuntimeException("Too many active CoW sessions");
        }
        String sessionId = UUID.randomUUID().toString();
        CowSession session = new CowSession(ld.imagePath, ld.configuration, ld.imageBaseId, ld.vmName, ld.restricted, user, sessionType);
        if (session.getError() != null) {
            throw new RuntimeException(session.getError());
        }
        CowSessionManager.add(sessionId, session);
        return sessionId;
    }

    static {
        QuickTimer.scheduleAtFixedDelay(new QuickTimer.Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fire() {
                Lock lock = SESSION_LOCK.writeLock();
                lock.lock();
                try {
                    Iterator iterator = SESSIONS.values().iterator();
                    while (iterator.hasNext()) {
                        CowSession s = (CowSession)iterator.next();
                        if (!s.timedout()) continue;
                        s.abort();
                        iterator.remove();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }, 3600577L, 3601010L);
    }
}

