/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.openslx.bwlp.thrift.iface.UserInfo;

public class Mail {
    private static final MessageDigest md;
    public final String id;
    public final String userId;
    public final String message;

    public Mail(String id, String userId, String message) {
        this.id = id;
        this.userId = userId;
        this.message = message;
    }

    public Mail(UserInfo recipient, String message) {
        this(Mail.hash(recipient, message), recipient.userId, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hash(UserInfo recipient, String message) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            md.update(recipient.userId.getBytes(StandardCharsets.UTF_8));
            md.update(message.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(md.digest());
        }
    }

    static {
        MessageDigest tmp;
        try {
            tmp = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            tmp = null;
        }
        md = tmp;
    }
}

