/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import java.sql.SQLException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.mappers.DbConfiguration;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbImagePermissions;
import org.openslx.bwlp.sat.database.mappers.DbLecture;
import org.openslx.bwlp.sat.database.mappers.DbLecturePermissions;
import org.openslx.bwlp.sat.database.mappers.DbUser;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.mail.Mail;
import org.openslx.bwlp.sat.mail.MailQueue;
import org.openslx.bwlp.sat.mail.MailTemplate;
import org.openslx.bwlp.sat.mail.MailTemplatePlain;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.bwlp.thrift.iface.ShareMode;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.Util;

public class MailGenerator {
    private static final Logger LOGGER = LogManager.getLogger(MailGenerator.class);

    public static void lectureAutoUpdate(List<LectureSummary> lectures, LocalImageVersion newVersion) throws SQLException {
        String uploaderName;
        String imageName;
        if (!MailGenerator.hasMailConfig()) {
            return;
        }
        try {
            ImageDetailsRead image = DbImage.getImageDetails(null, newVersion.imageBaseId);
            imageName = image.imageName;
        }
        catch (SQLException | TNotFoundException e) {
            LOGGER.warn("Could not get image details for image version " + newVersion.imageVersionId);
            imageName = "(unbekannt)";
        }
        try {
            DbUser.User u = DbUser.getCached(newVersion.uploaderId);
            uploaderName = Formatter.userFullName(u.ui) + " <" + u.ui.eMail + ">";
        }
        catch (TNotFoundException e) {
            LOGGER.warn("Could not get uploading user of new image version " + newVersion.imageVersionId);
            uploaderName = "(unbekannt)";
        }
        for (LectureSummary lecture : lectures) {
            List<UserInfo> relevantUsers = MailGenerator.getUserToMail(lecture);
            MailTemplate template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.LECTURE_UPDATED);
            HashMap<String, String> templateArgs = new HashMap<String, String>();
            templateArgs.put("lecture", lecture.lectureName);
            templateArgs.put("image", imageName);
            templateArgs.put("created", Formatter.date(newVersion.createTime));
            templateArgs.put("uploader", uploaderName);
            String msg = template.format(templateArgs);
            for (UserInfo user : relevantUsers) {
                if (newVersion.uploaderId.equals(user.userId)) continue;
                MailQueue.queue(new Mail(user, MailGenerator.wordWrap(msg)));
            }
        }
    }

    public static void lectureForcedUpdate(List<LectureSummary> lectures, LocalImageVersion newVersion) throws SQLException {
        if (!MailGenerator.hasMailConfig()) {
            return;
        }
        for (LectureSummary lecture : lectures) {
            List<UserInfo> relevantUsers = MailGenerator.getUserToMail(lecture);
            MailTemplate template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.LECTURE_FORCED_UPDATE);
            HashMap<String, String> templateArgs = new HashMap<String, String>();
            templateArgs.put("lecture", lecture.lectureName);
            templateArgs.put("created", Formatter.date(newVersion.createTime));
            templateArgs.put("date", Formatter.date(newVersion.createTime));
            String msg = template.format(templateArgs);
            for (UserInfo user : relevantUsers) {
                MailQueue.queue(new Mail(user, MailGenerator.wordWrap(msg)));
            }
        }
    }

    public static void lectureDeactivated(List<LectureSummary> lectures) {
        if (!MailGenerator.hasMailConfig()) {
            return;
        }
        for (LectureSummary lecture : lectures) {
            ImageDetailsRead image;
            List<UserInfo> relevantUsers = MailGenerator.getUserToMail(lecture);
            try {
                image = DbImage.getImageDetails(null, lecture.imageBaseId);
            }
            catch (SQLException | TNotFoundException e) {
                LOGGER.warn("Could not get image details for image version " + lecture.imageVersionId);
                return;
            }
            MailTemplate template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.LECTURE_DEACTIVATED);
            HashMap<String, String> templateArgs = new HashMap<String, String>();
            templateArgs.put("lecture", lecture.lectureName);
            templateArgs.put("image", image.imageName);
            String msg = template.format(templateArgs);
            for (UserInfo user : relevantUsers) {
                MailQueue.queue(new Mail(user, MailGenerator.wordWrap(msg)));
            }
        }
    }

    public static void sendImageVersionDeleted(String imageBaseId, LocalImageVersion oldLocal, LocalImageVersion newLocal) {
        MailTemplate template;
        ImageDetailsRead image;
        if (!MailGenerator.hasMailConfig()) {
            return;
        }
        try {
            image = DbImage.getImageDetails(null, imageBaseId);
        }
        catch (SQLException | TNotFoundException e) {
            LOGGER.warn("Version Deleted for image=" + imageBaseId + " failed", (Throwable)e);
            return;
        }
        ImageVersionDetails oldVersion = null;
        ImageVersionDetails newVersion = null;
        for (ImageVersionDetails version : image.versions) {
            if (oldLocal != null && version.versionId.equals(oldLocal.imageVersionId)) {
                oldVersion = version;
            }
            if (newLocal == null || !version.versionId.equals(newLocal.imageVersionId)) continue;
            newVersion = version;
        }
        HashMap<String, String> templateArgs = new HashMap<String, String>();
        if (oldVersion == newVersion) {
            return;
        }
        templateArgs.put("image", image.imageName);
        if (newVersion == null) {
            template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.VM_DELETED_LAST_VERSION);
        } else {
            String uploaderName;
            template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.VM_DELETED_OLD_VERSION);
            try {
                DbUser.User uploader = DbUser.getCached(newVersion.uploaderId);
                uploaderName = Formatter.userFullName(uploader.ui) + " <" + uploader.ui.eMail + ">";
            }
            catch (SQLException | TNotFoundException e) {
                uploaderName = "(unbekannt)";
            }
            templateArgs.put("uploader", uploaderName);
            templateArgs.put("new_created", Formatter.date(newVersion.createTime));
            if (oldVersion != null) {
                templateArgs.put("old_created", Formatter.date(oldVersion.createTime));
            }
        }
        List<UserInfo> relevantUsers = MailGenerator.getUserToMail(image);
        for (UserInfo user : relevantUsers) {
            MailQueue.queue(new Mail(user, MailGenerator.wordWrap(template.format(templateArgs))));
        }
    }

    public static void sendImageDeletionReminder(LocalImageVersion version, int days, boolean mailForced) {
        List<LectureSummary> lectures;
        MailTemplate template;
        boolean isCurrentlyLatest;
        ImageDetailsRead image;
        if (!MailGenerator.hasMailConfig()) {
            return;
        }
        try {
            image = DbImage.getImageDetails(null, version.imageBaseId);
        }
        catch (SQLException | TNotFoundException e) {
            LOGGER.warn("Could not get image details for image version " + version.imageVersionId);
            return;
        }
        boolean bl = isCurrentlyLatest = image.latestVersionId == null || image.latestVersionId.equals(version.imageVersionId);
        if (isCurrentlyLatest) {
            template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.VM_CURRENT_VERSION_EXPIRING);
        } else if (mailForced) {
            template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.VM_OLD_VERSION_EXPIRING);
        } else {
            return;
        }
        HashMap<String, String> templateArgs = new HashMap<String, String>();
        templateArgs.put("image", image.imageName);
        templateArgs.put("remaining_days", String.valueOf(days));
        templateArgs.put("created", Formatter.date(version.createTime));
        templateArgs.put("image_expiretime", Formatter.date(version.expireTime));
        String message = MailGenerator.wordWrap(template.format(templateArgs));
        List<UserInfo> relevantUsers = MailGenerator.getUserToMail(image);
        for (UserInfo user : relevantUsers) {
            MailQueue.queue(new Mail(user, message));
        }
        if (!isCurrentlyLatest) {
            return;
        }
        try {
            lectures = DbLecture.getLecturesUsingImageVersion(version.imageVersionId);
        }
        catch (SQLException e) {
            lectures = new ArrayList<LectureSummary>(0);
        }
        for (LectureSummary lecture : lectures) {
            if (lecture.endTime < version.expireTime) continue;
            template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.LECTURE_LINKED_VM_EXPIRING);
            templateArgs.put("lecture", lecture.lectureName);
            message = MailGenerator.wordWrap(template.format(templateArgs));
            relevantUsers = MailGenerator.getUserToMail(lecture);
            for (UserInfo user : relevantUsers) {
                MailQueue.queue(new Mail(user, message));
            }
        }
    }

    public static void sendLectureExpiringReminder(LectureSummary lecture, int days) {
        if (!MailGenerator.hasMailConfig()) {
            return;
        }
        List<UserInfo> relevantUsers = MailGenerator.getUserToMail(lecture);
        MailTemplate template = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.LECTURE_EXPIRING);
        HashMap<String, String> templateArgs = new HashMap<String, String>();
        templateArgs.put("lecture", lecture.lectureName);
        templateArgs.put("remaining_days", String.valueOf(days));
        templateArgs.put("lecture_endtime", Formatter.date(lecture.endTime));
        String message = template.format(templateArgs);
        for (UserInfo user : relevantUsers) {
            MailQueue.queue(new Mail(user, MailGenerator.wordWrap(message)));
        }
    }

    public static boolean isValidMailConfig(MailQueue.MailConfig conf) {
        return conf != null && conf.port != 0 && !Util.isEmptyString(conf.host) && !Util.isEmptyString(conf.senderAddress);
    }

    private static boolean hasMailConfig() {
        MailQueue.MailConfig conf;
        try {
            conf = DbConfiguration.getMailConfig();
        }
        catch (SQLException e) {
            return false;
        }
        return MailGenerator.isValidMailConfig(conf);
    }

    private static List<UserInfo> getUserToMail(LectureSummary lecture) {
        Map<String, LecturePermissions> users;
        try {
            users = DbLecturePermissions.getForLecture(lecture.lectureId, false);
        }
        catch (SQLException e) {
            users = new HashMap<String, LecturePermissions>();
        }
        users.put(lecture.ownerId, new LecturePermissions(true, true));
        ArrayList<UserInfo> list = new ArrayList<UserInfo>(users.size());
        for (Map.Entry<String, LecturePermissions> entry : users.entrySet()) {
            DbUser.User user;
            LecturePermissions perms = entry.getValue();
            if (!perms.admin && !perms.edit) continue;
            try {
                user = DbUser.getCached(entry.getKey());
            }
            catch (TNotFoundException e) {
                LOGGER.warn("UserID " + entry.getKey() + " unknown");
                continue;
            }
            catch (SQLException e) {
                continue;
            }
            if (!user.local.emailNotifications) continue;
            list.add(user.ui);
        }
        return list;
    }

    private static List<UserInfo> getUserToMail(ImageDetailsRead image) {
        Map<String, ImagePermissions> users;
        try {
            users = DbImagePermissions.getForImageBase(image.imageBaseId, false);
        }
        catch (SQLException e) {
            users = new HashMap<String, ImagePermissions>();
        }
        if (image.shareMode == ShareMode.LOCAL || image.shareMode == ShareMode.PUBLISH) {
            users.put(image.ownerId, new ImagePermissions(true, true, true, true));
        }
        ArrayList<UserInfo> list = new ArrayList<UserInfo>(users.size());
        for (Map.Entry<String, ImagePermissions> entry : users.entrySet()) {
            DbUser.User user;
            ImagePermissions perms = entry.getValue();
            if (!perms.admin && !perms.edit) continue;
            try {
                user = DbUser.getCached(entry.getKey());
            }
            catch (TNotFoundException e) {
                LOGGER.warn("UserID " + entry.getKey() + " unknown");
                continue;
            }
            catch (SQLException e) {
                continue;
            }
            if (!user.local.emailNotifications) continue;
            list.add(user.ui);
        }
        return list;
    }

    private static String wordWrap(String input) {
        return MailGenerator.wordWrap(input, 76, "\n  ", Locale.GERMAN);
    }

    private static String wordWrap(String input, int width, String nlString, Locale locale) {
        if (input == null) {
            return "";
        }
        if (width < 5) {
            return input;
        }
        if (width >= input.length()) {
            return input;
        }
        StringBuilder buf = new StringBuilder(input);
        boolean endOfLine = false;
        int lineStart = 0;
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) == '\n') {
                lineStart = i + 1;
                endOfLine = true;
            }
            if (i <= lineStart + width - 1) continue;
            if (endOfLine) {
                buf.insert(i, nlString);
                lineStart = i + nlString.length();
                endOfLine = false;
                continue;
            }
            int limit = i - lineStart - 1;
            BreakIterator breaks = BreakIterator.getLineInstance(locale);
            breaks.setText(buf.substring(lineStart, i));
            int end = breaks.last();
            if (end == limit + 1 && !Character.isWhitespace(buf.charAt(lineStart + end))) {
                end = breaks.preceding(end - 1);
            }
            if (end != -1 && end == limit + 1) {
                buf.replace(lineStart + end, lineStart + end + 1, nlString.substring(0, 1));
                buf.insert(lineStart + end + 1, nlString.substring(1));
                lineStart = lineStart + end + nlString.length() - 1;
                continue;
            }
            if (end != -1 && end != 0) {
                buf.insert(lineStart + end, nlString);
                lineStart = lineStart + end + nlString.length();
                continue;
            }
            buf.insert(i, nlString);
            lineStart = i + nlString.length();
        }
        return buf.toString();
    }
}

