/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.mappers.DbConfiguration;
import org.openslx.bwlp.sat.database.mappers.DbMailQueue;
import org.openslx.bwlp.sat.database.mappers.DbUser;
import org.openslx.bwlp.sat.mail.Mail;
import org.openslx.bwlp.sat.mail.MailGenerator;
import org.openslx.bwlp.sat.mail.MailTemplate;
import org.openslx.bwlp.sat.mail.MailTemplatePlain;
import org.openslx.bwlp.sat.mail.SmtpMailer;
import org.openslx.bwlp.sat.maintenance.MailFlusher;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class MailQueue {
    private static final Logger LOGGER = LogManager.getLogger(MailQueue.class);
    private static final int BATCH_SIZE = 25;
    private static boolean busy = false;

    public static void queue(Mail mail) {
        try {
            DbMailQueue.queue(mail);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() throws InterruptedException {
        Class<MailQueue> clazz = MailQueue.class;
        synchronized (MailQueue.class) {
            if (busy) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            busy = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                SmtpMailer smtpc;
                MailConfig conf;
                List<Mail> queuedMails;
                try {
                    queuedMails = DbMailQueue.getQueued(25);
                }
                catch (SQLException e) {
                    LOGGER.error("Cannot retrieve queued mails from DB");
                    Class<MailQueue> clazz2 = MailQueue.class;
                    synchronized (MailQueue.class) {
                        busy = false;
                        // ** MonitorExit[var2_6] (shouldn't be in output)
                        return;
                    }
                }
                if (queuedMails.isEmpty()) {
                    return;
                }
                try {
                    conf = DbConfiguration.getMailConfig();
                }
                catch (SQLException e) {
                    Object conf2 = null;
                    Class<MailQueue> clazz3 = MailQueue.class;
                    synchronized (MailQueue.class) {
                        busy = false;
                        // ** MonitorExit[var3_11] (shouldn't be in output)
                        return;
                    }
                }
                if (!MailGenerator.isValidMailConfig(conf)) {
                    LOGGER.error("Cannot send mail with no mail config");
                    return;
                }
                try {
                    smtpc = new SmtpMailer(conf.host, conf.port, conf.ssl, conf.senderAddress, conf.serverName, conf.replyTo, conf.username, conf.password, null);
                }
                catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | LoginException e) {
                    LOGGER.error("Could not initialize connection to SMTP server. Mails will not be sent", (Throwable)e);
                    Class<MailQueue> clazz4 = MailQueue.class;
                    synchronized (MailQueue.class) {
                        busy = false;
                        // ** MonitorExit[var4_15] (shouldn't be in output)
                        return;
                    }
                }
                HashMap<String, ArrayList<Mail>> batch = new HashMap<String, ArrayList<Mail>>();
                for (Mail mail : queuedMails) {
                    ArrayList<Mail> list = (ArrayList<Mail>)batch.get(mail.userId);
                    if (list == null) {
                        list = new ArrayList<Mail>();
                        batch.put(mail.userId, list);
                    }
                    list.add(mail);
                }
                int delaySeconds = 2;
                boolean sendOk = true;
                for (List userBatch : batch.values()) {
                    DbUser.User cachedUser;
                    if (userBatch.isEmpty()) continue;
                    try {
                        cachedUser = DbUser.getCached(((Mail)userBatch.get((int)0)).userId);
                    }
                    catch (SQLException | TNotFoundException e) {
                        LOGGER.warn("Cannot get user for id " + ((Mail)userBatch.get((int)0)).userId + ": Sending mails failed.");
                        try {
                            DbMailQueue.markFailed(userBatch);
                        }
                        catch (SQLException sQLException) {}
                        continue;
                    }
                    if (!cachedUser.local.emailNotifications) {
                        try {
                            DbMailQueue.markSent(userBatch);
                        }
                        catch (SQLException e) {}
                        continue;
                    }
                    StringBuilder sb = new StringBuilder();
                    for (Mail mail : userBatch) {
                        if (sb.length() != 0) {
                            sb.append('\n');
                        }
                        sb.append("* ");
                        sb.append(mail.message);
                    }
                    sendOk = MailQueue.sendMail(conf, smtpc, cachedUser.ui, sb.toString());
                    LOGGER.debug("Sending mail to " + cachedUser.ui.eMail + ": " + (sendOk ? "success" : "failure"));
                    try {
                        if (sendOk) {
                            DbMailQueue.markSent(userBatch);
                        } else {
                            DbMailQueue.markFailed(userBatch);
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    Thread.sleep(delaySeconds * 1000);
                    ++delaySeconds;
                }
                smtpc.close();
                if (queuedMails.size() == 25 && sendOk) {
                    MailQueue.callAgainInOneMinute();
                }
            }
            finally {
                Class<MailQueue> clazz5 = MailQueue.class;
                synchronized (MailQueue.class) {
                    busy = false;
                    // ** MonitorExit[var14_35] (shouldn't be in output)
                }
            }
            return;
        }
    }

    private static void callAgainInOneMinute() {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                MailFlusher.start();
            }
        }, TimeUnit.MINUTES.toMillis(1L));
    }

    private static boolean sendMail(MailConfig conf, SmtpMailer smtpc, UserInfo user, String message) {
        MailTemplate wrapper = DbConfiguration.getMailTemplate(MailTemplatePlain.Template.GENERAL_WRAPPER);
        HashMap<String, String> templateArgs = new HashMap<String, String>();
        templateArgs.put("first_name", user.firstName);
        templateArgs.put("last_name", user.lastName);
        templateArgs.put("sender_name", conf.serverName);
        templateArgs.put("messages", message);
        String fullMessage = wrapper.format(templateArgs);
        if (!Util.isEmptyString(conf.replyTo)) {
            fullMessage = fullMessage + "\n\nBei weiteren Fragen wenden Sie sich bitte an den Support unter\n" + conf.replyTo;
        }
        if (fullMessage.contains("\r\n")) {
            fullMessage = fullMessage.replace("\r\n", "\n");
        }
        if (fullMessage.contains("\n")) {
            fullMessage = fullMessage.replace("\n", "\r\n");
        }
        return smtpc.send(user.eMail, "[bwLehrpool] Hinweise zu Ihren VMs/Veranstaltungen", fullMessage, "<sat.bwlehrpool.de>");
    }

    public static class MailConfig {
        public String host;
        public int port;
        public SmtpMailer.EncryptionMode ssl;
        public String senderAddress;
        public String replyTo;
        public String password;
        public String username;
        public String serverName;
    }
}

