/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class MailTemplate {
    private ArrayList<String> snippets = new ArrayList();
    private ArrayList<String> identifiers = new ArrayList();
    private String raw;

    public MailTemplate(String raw_template) {
        this.raw = raw_template;
        this.parseTemplate(raw_template);
    }

    public String format(Map<String, String> vars) {
        boolean progress;
        Iterator<String> it_snippets = this.snippets.iterator();
        Iterator<String> it_identifiers = this.identifiers.iterator();
        StringBuilder sb = new StringBuilder();
        do {
            progress = false;
            if (it_snippets.hasNext()) {
                sb.append(it_snippets.next());
                progress = true;
            }
            if (!it_identifiers.hasNext()) continue;
            sb.append(vars.get(it_identifiers.next()));
            progress = true;
        } while (progress);
        return sb.toString();
    }

    private boolean validVarChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '_';
    }

    private void parseTemplate(String raw) {
        String snippet;
        int i = 0;
        while (true) {
            int end;
            int len = raw.length();
            int begin = raw.indexOf("%", i);
            if (begin != -1) {
                for (end = begin + 1; end < len && this.validVarChar(raw.charAt(end)); ++end) {
                }
            }
            if (begin == -1 || end >= len) break;
            snippet = raw.substring(i, begin);
            String identifier = raw.substring(begin + 1, end);
            this.snippets.add(snippet);
            this.identifiers.add(identifier);
            if (raw.charAt(end) == '%') {
                i = end + 1;
                continue;
            }
            i = end;
        }
        snippet = raw.substring(i);
        this.snippets.add(snippet);
    }

    public String getRaw() {
        return this.raw;
    }
}

