/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import java.util.HashMap;
import org.openslx.bwlp.sat.mail.MailTemplate;
import org.openslx.bwlp.sat.mail.MailTemplatePlain;

public class MailTemplateConfiguration {
    private static final MailTemplatePlain[] defaultTemplates = new MailTemplatePlain[]{new MailTemplatePlain(MailTemplatePlain.Template.LECTURE_UPDATED, "Wird an die Verantwortlichen einer Veranstaltung gesendet, wenn die verkn\u00fcpfte VM aktualisiert wurde.", "Die zur Veranstaltung '%lecture%' geh\u00f6rige VM wurde aktualisiert.", new String[]{"image", "created", "uploader"}, new String[]{"lecture"}, 1), new MailTemplatePlain(MailTemplatePlain.Template.LECTURE_DEACTIVATED, "Wird versendet, wenn eine Veranstaltung unerwartet deaktiviert werden musste.", "Die Veranstaltung '%lecture%' musste deaktiviert werden, da die verkn\u00fcpfte VM '%image%' gel\u00f6scht oder besch\u00e4digt wurde. Bitte \u00fcberpr\u00fcfen Sie die Veranstaltung und \u00e4ndern Sie ggf. die Verlinkung, damit die Veranstaltung wieder verwendbar ist.", new String[]{"image"}, new String[]{"lecture"}, 1), new MailTemplatePlain(MailTemplatePlain.Template.VM_CURRENT_VERSION_EXPIRING, "Wird versendet, wenn die aktuellste Version einer VM kurz vor dem Ablaufdatum steht.", "Die aktuellste Version der VM '%image%' l\u00e4uft in %remaining_days% Tag(en) ab. Bitte aktualisieren Sie die VM, da verkn\u00fcpfte Veranstaltungen sonst deaktiviert werden.", new String[]{"remaining_days", "created", "image_expiretime"}, new String[]{"image"}, 0), new MailTemplatePlain(MailTemplatePlain.Template.VM_OLD_VERSION_EXPIRING, "Hinweis, dass eine alte Version einer VM abl\u00e4uft.", "Eine alte Version der VM '%image%' l\u00e4uft in %remaining_days% Tag(en) ab (Version vom %created%). Eine aktuellere Version ist vorhanden, diese Nachricht dient nur der Information.", new String[]{"remaining_days", "created", "image_expiretime"}, new String[]{"image"}, 0), new MailTemplatePlain(MailTemplatePlain.Template.LECTURE_LINKED_VM_EXPIRING, "Hinweis, dass die zu einer Veranstaltung geh\u00f6rige VM bald abl\u00e4uft.", "Hinweis zur Veranstaltung '%lecture%': Die verwendete VM '%image%' l\u00e4uft in %remaining_days% Tag(en) ab. Bitte aktualisieren oder wechseln Sie die VM.", new String[]{"remaining_days", "image_expiretime"}, new String[]{"lecture", "image"}, 1), new MailTemplatePlain(MailTemplatePlain.Template.LECTURE_EXPIRING, "Wird versendet, wenn eine Veranstaltung kurz vor dem Enddatum steht.", "Die Veranstaltung '%lecture%' l\u00e4uft in %remaining_days% Tag(en) ab. Verl\u00e4ngern Sie bei Bedarf das Ablaufdatum.", new String[]{"remaining_days", "lecture_endtime"}, new String[]{"lecture"}, 0), new MailTemplatePlain(MailTemplatePlain.Template.VM_DELETED_LAST_VERSION, "Wird versendet, wenn die letzte g\u00fcltige Version einer VM gel\u00f6scht wurde. Die Metadaten der VM bleiben f\u00fcr einige Tage erhalten, falls die Verantwortliche eine neue Version hochladen m\u00f6chte, ohne die Metadaten erneut eingeben zu m\u00fcssen.", "Die letzte verbliebene Version der VM '%image%' wurde gel\u00f6scht. Die Metadaten der VM wurden zur L\u00f6schung vorgemerkt.", new String[0], new String[]{"image"}, 0), new MailTemplatePlain(MailTemplatePlain.Template.VM_DELETED_OLD_VERSION, "Best\u00e4tigung dass eine alte Version der VM gel\u00f6scht wurde", "Eine alte Version der VM '%image%' vom %old_created% wurde gel\u00f6scht\nDie neueste Version ist jetzt vom %new_created% (erstellt von %uploader%)", new String[]{"old_created", "new_created", "uploader"}, new String[]{"image"}, 0), new MailTemplatePlain(MailTemplatePlain.Template.LECTURE_FORCED_UPDATE, "Wird versendet, wenn die VM zu einer Veranstaltung unerwartet nicht mehr verf\u00fcgbar ist, aber eine neuere oder \u00e4ltere Version der VM als Ausweichm\u00f6glichkeit gew\u00e4hlt werden konnte.", "Die verlinkte VM zur Veranstaltung '%lecture%' wurde gel\u00f6scht oder ist besch\u00e4digt. Daher verweist sie jetzt auf die VM-Version vom %created%. Bitte \u00fcberpr\u00fcfen Sie ggf., ob diese VM-Version f\u00fcr Ihren Kurs geeignet ist.", new String[]{"created"}, new String[]{"lecture"}, 1), new MailTemplatePlain(MailTemplatePlain.Template.TEST_MAIL, "Die Test-Email, die in der Mail-Konfiguration verschickt werden kann.", "Test der Mailkonfiguration.\n\n%host%:%port% \nSSL: %ssl%\nLogin: %username%", new String[]{"host", "port", "ssl", "username"}, new String[0], 0), new MailTemplatePlain(MailTemplatePlain.Template.GENERAL_WRAPPER, "Einleitung und Gru\u00dfzeile ausgehender Mails.", "Guten Tag, %first_name% %last_name%,\n\nBitte beachten Sie folgende Hinweise zu Virtuellen Maschinen und Veranstaltungen,\nf\u00fcr die Sie als zust\u00e4ndige Person hinterlegt sind:\n\n%messages%\n\nDies ist eine automatisch generierte Mail. Wenn Sie keine Hinweise dieser Art\nw\u00fcnschen, melden Sie sich bitte mittels der bwLehrpool-Suite an diesem\nSatellitenserver an und deaktivieren Sie in den Einstellungen die\ne-Mail-Benachrichtigungen.\n\n-- \nGeneriert auf %sender_name%", new String[]{"first_name", "last_name", "sender_name"}, new String[]{"messages"}, 0)};
    public static final MailTemplateConfiguration defaultTemplateConfiguration = new MailTemplateConfiguration(defaultTemplates);
    private MailTemplatePlain[] templates;

    public MailTemplate getByName(MailTemplatePlain.Template name) {
        for (int i = 0; i < this.templates.length; ++i) {
            if (this.templates[i].getName() != name) continue;
            return this.templates[i].toMailTemplate();
        }
        return null;
    }

    public MailTemplateConfiguration(MailTemplatePlain[] templates) {
        this.templates = templates;
    }

    public MailTemplateConfiguration merge(MailTemplateConfiguration newconf) {
        HashMap<MailTemplatePlain.Template, MailTemplatePlain> templates = new HashMap<MailTemplatePlain.Template, MailTemplatePlain>();
        for (MailTemplatePlain t : this.templates) {
            if (t.getName() == null) continue;
            templates.put(t.getName(), t);
        }
        for (MailTemplatePlain t : newconf.templates) {
            if (t.getName() == null) continue;
            if (!templates.containsKey((Object)t.getName())) {
                templates.put(t.getName(), t);
                continue;
            }
            ((MailTemplatePlain)templates.get((Object)t.getName())).mergeWithUpdatedVersion(t);
        }
        MailTemplatePlain[] templatesArray = new MailTemplatePlain[templates.size()];
        templates.values().toArray(templatesArray);
        return new MailTemplateConfiguration(templatesArray);
    }

    public int size() {
        return this.templates.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (MailTemplatePlain p : this.templates) {
            sb.append((Object)p.getName());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

