/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import com.google.gson.annotations.SerializedName;
import org.openslx.bwlp.sat.mail.MailTemplate;

public class MailTemplatePlain {
    private Template name;
    private String description;
    private String template;
    @SerializedName(value="optional_variables")
    private String[] optionalVariables;
    @SerializedName(value="mandatory_variables")
    private String[] mandatoryVariables;
    private int version;
    @SerializedName(value="edit_version")
    private int editVersion;
    private boolean original = false;
    @SerializedName(value="original_template")
    private String original_template;

    public MailTemplatePlain(Template name, String description, String template, String[] optionalVariables, String[] mandatoryVariables, int version) {
        this.name = name;
        this.description = description;
        this.original_template = this.template = template;
        this.optionalVariables = optionalVariables;
        this.mandatoryVariables = mandatoryVariables;
        this.version = version;
        this.original = true;
    }

    public Template getName() {
        return this.name;
    }

    public MailTemplate toMailTemplate() {
        return new MailTemplate(this.template);
    }

    public void mergeWithUpdatedVersion(MailTemplatePlain updated) {
        this.description = updated.description;
        this.optionalVariables = updated.optionalVariables;
        this.mandatoryVariables = updated.mandatoryVariables;
        if (this.original || this.template.trim().replace("\r\n", "\n").equals(updated.template.trim().replace("\r\n", "\n"))) {
            this.original = true;
            this.template = updated.template;
            this.editVersion = this.version = updated.version;
            this.original_template = "";
        } else {
            this.version = updated.version;
            this.original_template = updated.template;
        }
    }

    public static enum Template {
        LECTURE_UPDATED,
        LECTURE_DEACTIVATED,
        VM_CURRENT_VERSION_EXPIRING,
        VM_OLD_VERSION_EXPIRING,
        LECTURE_LINKED_VM_EXPIRING,
        LECTURE_EXPIRING,
        VM_DELETED_LAST_VERSION,
        VM_DELETED_OLD_VERSION,
        LECTURE_FORCED_UPDATE,
        TEST_MAIL,
        GENERAL_WRAPPER;

    }
}

