/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.net.smtp.SimpleSMTPHeader;

public class QuotingSmtpHeader
extends SimpleSMTPHeader {
    private static CharsetEncoder asciiEncoder = StandardCharsets.US_ASCII.newEncoder();

    public QuotingSmtpHeader(String fromAddress, String fromDisplayName, String to, String subject) {
        super(QuotingSmtpHeader.buildNamedAddress(fromAddress, fromDisplayName), to, QuotingSmtpHeader.wrapEncoding(subject));
    }

    public QuotingSmtpHeader(String from, String to, String subject) {
        super(from, to, QuotingSmtpHeader.wrapEncoding(subject));
    }

    @Override
    public void addHeaderField(String headerField, String value) {
        super.addHeaderField(headerField, QuotingSmtpHeader.wrapEncoding(value));
    }

    @Override
    public void addCC(String address) {
        super.addCC(QuotingSmtpHeader.wrapEncoding(address));
    }

    private static String wrapEncoding(String input) {
        return QuotingSmtpHeader.wrapEncoding(input, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String wrapEncoding(String input, boolean addQuotesIfSpaces) {
        boolean isAscii;
        CharsetEncoder charsetEncoder = asciiEncoder;
        synchronized (charsetEncoder) {
            isAscii = asciiEncoder.canEncode(input);
        }
        if (isAscii) {
            if (addQuotesIfSpaces && (input.contains(" ") || input.contains("\t"))) {
                return "\"" + input + "\"";
            }
            return input;
        }
        return "=?utf-8?B?" + Base64.getEncoder().encodeToString(input.getBytes(StandardCharsets.UTF_8)) + "?=";
    }

    private static String buildNamedAddress(String address, String name) {
        if (name == null) {
            return address;
        }
        return QuotingSmtpHeader.wrapEncoding(name, true) + " <" + address + ">";
    }
}

