/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.mail;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.security.auth.login.LoginException;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.mail.QuotingSmtpHeader;
import org.openslx.util.Util;

public class SmtpMailer {
    private static final Logger LOGGER = LogManager.getLogger(SmtpMailer.class);
    private final String fromAddress;
    private final String fromName;
    private final String replyTo;
    private final AuthenticatingSMTPClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmtpMailer(String host, int port, EncryptionMode ssl, String fromAddress, String fromName, String replyTo, String username, String password, PrintStream logStream) throws UnknownHostException, SocketException, IOException, LoginException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        InetAddress[] ips = InetAddress.getAllByName(host);
        if (ips == null || ips.length == 0) {
            throw new UnknownHostException(host);
        }
        LOGGER.debug("Mailing via " + host + ", " + (Object)((Object)ssl));
        this.client = ssl == EncryptionMode.EXPLICIT || ssl == EncryptionMode.NONE ? new AuthenticatingSMTPClient("TLSv1.2", false, "UTF-8") : new AuthenticatingSMTPClient("TLSv1.2", true, "UTF-8");
        boolean cleanup = true;
        try {
            if (logStream != null) {
                this.client.addProtocolCommandListener(new PrintCommandListener(logStream));
            }
            this.client.setConnectTimeout(5000);
            this.client.setDefaultTimeout(10000);
            IOException conEx = null;
            for (InetAddress ip : ips) {
                try {
                    this.client.connect(ip, port);
                    if (!SMTPReply.isPositiveCompletion(this.client.getReplyCode())) {
                        this.client.disconnect();
                        continue;
                    }
                    conEx = null;
                    break;
                }
                catch (IOException e) {
                    conEx = e;
                }
            }
            if (conEx != null) {
                throw conEx;
            }
            if (!this.client.elogin("bwlehrpool.sat")) {
                throw new LoginException("SMTP server rejected EHLO");
            }
            if (ssl == EncryptionMode.EXPLICIT) {
                if (!this.client.execTLS()) {
                    throw new LoginException("STARTTLS (explicit TLS) failed");
                }
                this.client.elogin("bwlehrpool.sat");
            }
            if (!Util.isEmptyString(username)) {
                boolean authed = false;
                try {
                    authed = this.client.auth(AuthenticatingSMTPClient.AUTH_METHOD.CRAM_MD5, username, password);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!authed && !this.client.auth(AuthenticatingSMTPClient.AUTH_METHOD.PLAIN, username, password)) {
                    throw new LoginException("Server rejected AUTH command. Invalid username or password?");
                }
            }
            cleanup = false;
            this.fromAddress = fromAddress;
            this.fromName = fromName;
            this.replyTo = replyTo;
        }
        finally {
            if (cleanup) {
                this.cleanup();
            }
        }
    }

    private void cleanup() {
        try {
            this.client.logout();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.client.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void abort() throws IOException {
        if (!this.client.reset()) {
            throw new IOException("Cannot abort current mail transaction");
        }
    }

    public boolean send(String recipient, String subject, String message, String listId) {
        try {
            QuotingSmtpHeader header = new QuotingSmtpHeader(this.fromAddress, this.fromName, recipient, subject);
            if (!Util.isEmptyString(this.replyTo)) {
                ((SimpleSMTPHeader)header).addHeaderField("Reply-To", this.replyTo);
            }
            if (!Util.isEmptyString(listId)) {
                ((SimpleSMTPHeader)header).addHeaderField("List-Id", listId);
                ((SimpleSMTPHeader)header).addHeaderField("Precedence", "bulk");
                ((SimpleSMTPHeader)header).addHeaderField("Auto-Submitted", "auto-generated");
            }
            ((SimpleSMTPHeader)header).addHeaderField("Content-Type", "text/plain; charset=utf-8");
            ((SimpleSMTPHeader)header).addHeaderField("Content-Transfer-Encoding", "8bit");
            if (!this.client.setSender(this.fromAddress)) {
                this.abort();
                return false;
            }
            if (!this.client.addRecipient(recipient)) {
                this.abort();
                return false;
            }
            Writer writer = this.client.sendMessageData();
            if (writer == null) {
                this.abort();
                return false;
            }
            writer.write(header.toString());
            writer.write(message);
            writer.close();
            this.client.completePendingCommand();
            return true;
        }
        catch (IOException e) {
            this.cleanup();
            return false;
        }
    }

    public boolean isConnected() {
        if (!this.client.isConnected()) {
            return false;
        }
        try {
            this.client.sendNoOp();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void close() {
        if (this.client.isConnected()) {
            try {
                this.client.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum EncryptionMode {
        NONE,
        IMPLICIT,
        EXPLICIT;

    }
}

