/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.maintenance;

import java.io.File;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbLog;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.maintenance.Maintenance;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class DeleteOldImages
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DeleteOldImages.class);
    private static final DeleteOldImages instance = new DeleteOldImages();
    private static long blockedUntil = 0L;

    public static synchronized void init() {
        if (blockedUntil != 0L) {
            return;
        }
        blockedUntil = 1L;
        QuickTimer.scheduleAtFixedRate(new QuickTimer.Task(){

            @Override
            public void fire() {
                if (blockedUntil > System.currentTimeMillis()) {
                    return;
                }
                DateTime now = DateTime.now();
                if (now.getHourOfDay() != 3 || now.getMinuteOfHour() > 15) {
                    return;
                }
                DeleteOldImages.start();
            }
        }, TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(5L));
    }

    public static synchronized void start() {
        if (blockedUntil > System.currentTimeMillis()) {
            return;
        }
        if (Maintenance.trySubmit(instance)) {
            blockedUntil = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(12L);
        }
    }

    private DeleteOldImages() {
    }

    @Override
    public void run() {
        List<LocalImageVersion> list;
        LOGGER.info("Looking for old image versions to delete...");
        try {
            DbImage.resetDeleteState();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!FileSystem.isStorageMounted()) {
            LOGGER.warn("Will not execute deletion of old images; store seems to be unmounted!");
            return;
        }
        HashSet<LocalImageVersion> markAsDelete = new HashSet<LocalImageVersion>();
        try {
            list = DbImage.getExpiringLocalImageVersions(0);
            for (LocalImageVersion iv : list) {
                if (!iv.isValid) continue;
                LOGGER.info("Invalidating: " + iv.imageVersionId + " - expired");
            }
            markAsDelete.addAll(list);
        }
        catch (SQLException e) {
            LOGGER.error("Will not be able to clean up old image versions");
        }
        try {
            list = DbImage.getVersionsWithMissingData();
            for (LocalImageVersion iv : list) {
                if (!iv.isValid) continue;
                LOGGER.info("Invalidating: " + iv.imageVersionId + " - osId or virtId is NULL");
            }
            markAsDelete.addAll(list);
        }
        catch (SQLException e) {
            LOGGER.error("Will not be able to clean up invalid image versions");
        }
        try {
            DbImage.markValid(false, false, markAsDelete.toArray(new LocalImageVersion[markAsDelete.size()]));
        }
        catch (SQLException e) {
            LOGGER.error("Could not mark images to be deleted as invalid. Cleanup of old images failed.");
            return;
        }
        int hardDeleteCount = 0;
        long hardDelete = Util.unixTime() - 86400L;
        HashSet<String> markAsDeleteIds = new HashSet<String>();
        for (LocalImageVersion version : markAsDelete) {
            if (version.expireTime >= hardDelete) continue;
            ++hardDeleteCount;
            try {
                DbImage.setDeletion(DbImage.DeleteState.SHOULD_DELETE, version.imageVersionId);
                markAsDeleteIds.add(version.imageVersionId);
            }
            catch (SQLException sQLException) {}
        }
        int baseDeleteCount = 0;
        try {
            baseDeleteCount = DbImage.deleteOrphanedBases();
        }
        catch (SQLException version) {
            // empty catch block
        }
        LOGGER.info("Deletion done. Soft: " + (markAsDelete.size() - hardDeleteCount) + ", hard: " + hardDeleteCount + ", base: " + baseDeleteCount);
        try {
            Set<LocalImageVersion> list2 = DbImage.getAllInvalid();
            for (LocalImageVersion iv : list2) {
                File img;
                if (markAsDeleteIds.contains(iv.imageVersionId) || !(img = FileSystem.composeAbsoluteImagePath(iv)).isFile() || img.isDirectory()) continue;
                DbImage.markValid(true, true, iv);
                if (!DbImage.DeleteState.KEEP.equals((Object)iv.deleteState)) {
                    DbImage.setDeletion(DbImage.DeleteState.KEEP, iv.imageVersionId);
                }
                LOGGER.info("Revived image version " + iv.imageVersionId + ": Was disabled for no good reason");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static StringBuilder hardDeleteImages() {
        List<LocalImageVersion> deletables;
        StringBuilder sb = new StringBuilder();
        try {
            deletables = DbImage.getLocalWithState(DbImage.DeleteState.WANT_DELETE);
        }
        catch (SQLException e2) {
            return null;
        }
        for (LocalImageVersion version : deletables) {
            FileSystem.deleteImageRelatedFiles(version);
            try {
                DbImage.deleteVersionPermanently(version);
            }
            catch (Exception e) {
                DeleteOldImages.writeln(sb, version.imageVersionId, ": Cannot delete image: ", e.getMessage());
            }
            DeleteOldImages.writeln(sb, version.imageVersionId, ": OK");
            DbLog.log(null, version.imageBaseId, "Version " + version.imageVersionId + " (" + Formatter.date(version.createTime) + ") deleted from database and storage.");
        }
        DeleteOldImages.writeln(sb, "Done");
        return sb;
    }

    private static void writeln(StringBuilder sb, String ... parts) {
        for (String s : parts) {
            if (s == null) {
                sb.append("(null)");
                continue;
            }
            sb.append(s);
        }
        sb.append('\n');
    }

    public static void hardDeleteImagesAsync() {
        Maintenance.trySubmit(new Runnable(){

            @Override
            public void run() {
                DeleteOldImages.hardDeleteImages();
            }
        });
    }
}

