/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.maintenance;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.openslx.bwlp.sat.database.mappers.DbLecture;
import org.openslx.bwlp.sat.maintenance.Maintenance;
import org.openslx.util.QuickTimer;

public class DeleteOldLectures
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DeleteOldLectures.class);
    private static final DeleteOldLectures instance = new DeleteOldLectures();
    private static long blockedUntil = 0L;

    public static synchronized void init() {
        if (blockedUntil != 0L) {
            return;
        }
        blockedUntil = 1L;
        QuickTimer.scheduleAtFixedRate(new QuickTimer.Task(){

            @Override
            public void fire() {
                if (blockedUntil > System.currentTimeMillis()) {
                    return;
                }
                DateTime now = DateTime.now();
                if (now.getHourOfDay() != 4 || now.getMinuteOfHour() > 15) {
                    return;
                }
                DeleteOldLectures.start();
            }
        }, TimeUnit.MINUTES.toMillis(6L), TimeUnit.MINUTES.toMillis(7L));
    }

    public static synchronized void start() {
        if (blockedUntil > System.currentTimeMillis()) {
            return;
        }
        if (Maintenance.trySubmit(instance)) {
            blockedUntil = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(12L);
        }
    }

    private DeleteOldLectures() {
    }

    @Override
    public void run() {
        LOGGER.info("Deleting expired lectures...");
        int cnt = 0;
        try {
            cnt = DbLecture.deleteOld(365);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        LOGGER.info("Deleted " + cnt + " lectures");
    }
}

