/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.maintenance;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.openslx.bwlp.sat.database.mappers.DbLog;
import org.openslx.bwlp.sat.database.mappers.DbUser;
import org.openslx.bwlp.sat.maintenance.Maintenance;
import org.openslx.bwlp.sat.util.Formatter;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.QuickTimer;

public class DeleteOldUsers
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DeleteOldUsers.class);
    private static final DeleteOldUsers instance = new DeleteOldUsers();
    private static long blockedUntil = 0L;

    public static synchronized void init() {
        if (blockedUntil != 0L) {
            return;
        }
        blockedUntil = 1L;
        QuickTimer.scheduleAtFixedRate(new QuickTimer.Task(){

            @Override
            public void fire() {
                if (blockedUntil > System.currentTimeMillis()) {
                    return;
                }
                DateTime now = DateTime.now();
                if (now.getHourOfDay() != 1 || now.getMinuteOfHour() > 15) {
                    return;
                }
                DeleteOldUsers.start();
            }
        }, TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(6L));
    }

    public static synchronized void start() {
        if (blockedUntil > System.currentTimeMillis()) {
            return;
        }
        if (Maintenance.trySubmit(instance)) {
            blockedUntil = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(12L);
        }
    }

    @Override
    public void run() {
        List<UserInfo> inactiveUsers;
        LOGGER.info("Deleting inactive users with no remaining lectures or VMs...");
        try {
            inactiveUsers = DbUser.getInactive();
        }
        catch (SQLException e) {
            LOGGER.warn("Cannot get list of old users for deletion");
            return;
        }
        for (UserInfo user : inactiveUsers) {
            try {
                if (!DbUser.deleteUser(user)) continue;
                DbLog.log(null, null, "Deleted inactive user " + Formatter.userFullName(user));
            }
            catch (SQLException sQLException) {}
        }
        LOGGER.info("Done deleting old users");
    }
}

