/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.maintenance;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbImageBlock;
import org.openslx.bwlp.sat.database.models.ImageVersionMeta;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.maintenance.Maintenance;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.filetransfer.util.ChunkStatus;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.filetransfer.util.HashChecker;
import org.openslx.filetransfer.util.StandaloneFileChunk;
import org.openslx.util.ThriftUtil;
import org.openslx.util.TimeoutHashMap;
import org.openslx.util.Util;

public class ImageValidCheck
implements Runnable {
    private static final Logger LOGGER;
    private static final int MAX_CONCURRENT_CHECKS = 1;
    private static Queue<ImageValidCheck> queue;
    private static Map<String, ImageValidCheck> inProgress;
    private static TimeoutHashMap<String, ImageValidCheck> done;
    private final String versionId;
    private final boolean integrity;
    private final boolean updateState;
    private CheckResult result = CheckResult.QUEUED;
    private static final HashChecker hashChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubmitResult check(String versionId, boolean integrity, boolean updateState) {
        if (versionId == null) {
            return SubmitResult.NULL_POINTER_EXCEPTION;
        }
        Map<String, ImageValidCheck> map = inProgress;
        synchronized (map) {
            TimeoutHashMap<String, ImageValidCheck> timeoutHashMap = done;
            synchronized (timeoutHashMap) {
                if (done.containsKey(versionId)) {
                    done.remove(versionId);
                }
            }
            if (inProgress.containsKey(versionId)) {
                return SubmitResult.ALREADY_IN_PROGRESS;
            }
            if (inProgress.size() >= 1) {
                if (queue.size() > 1000) {
                    return SubmitResult.TOO_MANY_QUEUED_JOBS;
                }
                queue.add(new ImageValidCheck(versionId, integrity, updateState));
                return SubmitResult.QUEUED;
            }
            ImageValidCheck check = new ImageValidCheck(versionId, integrity, updateState);
            if (Maintenance.trySubmit(check)) {
                inProgress.put(versionId, check);
                return SubmitResult.QUEUED;
            }
        }
        return SubmitResult.REJECTED_BY_SCHEDULER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForWork() {
        Map<String, ImageValidCheck> map = inProgress;
        synchronized (map) {
            ImageValidCheck check;
            while (inProgress.size() < 1 && !queue.isEmpty() && (check = queue.poll()) != null) {
                if (inProgress.containsKey(check.versionId)) continue;
                if (Maintenance.trySubmit(check)) {
                    inProgress.put(check.versionId, check);
                    continue;
                }
                if (queue.offer(check)) break;
                LOGGER.warn("Dropped queued check for image version " + check.versionId);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CheckResult getStatus(String versionId) {
        ImageValidCheck i;
        Map<String, ImageValidCheck> map = inProgress;
        synchronized (map) {
            i = inProgress.get(versionId);
        }
        if (i != null) {
            return i.result;
        }
        map = done;
        synchronized (map) {
            i = done.get(versionId);
        }
        if (i != null) {
            return i.result;
        }
        return CheckResult.NO_SUCH_JOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CheckResult> getAll() {
        HashMap<String, CheckResult> res = new HashMap<String, CheckResult>();
        Map<String, ImageValidCheck> map = inProgress;
        synchronized (map) {
            for (Map.Entry<String, ImageValidCheck> i : inProgress.entrySet()) {
                res.put(i.getKey(), i.getValue().result);
            }
        }
        map = done;
        synchronized (map) {
            for (Map.Entry<String, ImageValidCheck> i : done.getImmutableSnapshot().entrySet()) {
                res.put(i.getKey(), i.getValue().result);
            }
        }
        return res;
    }

    private ImageValidCheck(String versionId, boolean integrity, boolean updateState) {
        this.versionId = versionId;
        this.integrity = integrity;
        this.updateState = updateState;
    }

    private void setState(CheckResult cr) {
        if (cr.stage > this.result.stage) {
            this.result = cr;
        } else {
            LOGGER.debug("Ingoring state update from " + this.result.name() + " to " + cr.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block60: {
            try {
                LocalImageVersion imageVersion;
                this.setState(CheckResult.WAITING_FOR_STORE);
                if (!FileSystem.waitForStorage()) {
                    LOGGER.warn("Will not check " + this.versionId + ": Storage not online");
                    this.setState(CheckResult.INTERNAL_ERROR);
                    return;
                }
                this.setState(CheckResult.WORKING);
                try {
                    imageVersion = DbImage.getLocalImageData(this.versionId);
                }
                catch (TNotFoundException e) {
                    LOGGER.warn("Cannot check validity of image version - not found: " + this.versionId);
                    this.setState(CheckResult.UNKNOWN_VERSIONID);
                    if (this.result == CheckResult.WORKING) {
                        this.setState(CheckResult.INTERNAL_ERROR);
                    }
                    Map<String, ImageValidCheck> map = inProgress;
                    synchronized (map) {
                        TimeoutHashMap<String, ImageValidCheck> timeoutHashMap = done;
                        synchronized (timeoutHashMap) {
                            ImageValidCheck ivc = inProgress.remove(this.versionId);
                            done.put(this.versionId, ivc);
                        }
                    }
                    ImageValidCheck.checkForWork();
                    return;
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot get local image data", (Throwable)e);
                    this.setState(CheckResult.INTERNAL_ERROR);
                    if (this.result == CheckResult.WORKING) {
                        this.setState(CheckResult.INTERNAL_ERROR);
                    }
                    Map<String, ImageValidCheck> map = inProgress;
                    synchronized (map) {
                        TimeoutHashMap<String, ImageValidCheck> timeoutHashMap = done;
                        synchronized (timeoutHashMap) {
                            ImageValidCheck ivc = inProgress.remove(this.versionId);
                            done.put(this.versionId, ivc);
                        }
                    }
                    ImageValidCheck.checkForWork();
                    return;
                }
                boolean valid = this.checkValid(imageVersion);
                if (valid && this.integrity) {
                    try {
                        valid = this.checkBlockHashes(imageVersion);
                    }
                    catch (IOException e) {
                        LOGGER.warn("IO error for " + this.versionId, (Throwable)e);
                        this.setState(CheckResult.FILE_ACCESS_ERROR);
                        valid = false;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Cannot check block hashes of " + this.versionId, (Throwable)e);
                        this.setState(CheckResult.INTERNAL_ERROR);
                    }
                }
                if (imageVersion.isValid == valid) {
                    if (valid) {
                        this.setState(CheckResult.DONE);
                    }
                    return;
                }
                try {
                    if (this.updateState) {
                        DbImage.markValid(valid, false, imageVersion);
                    }
                    if (valid) {
                        this.setState(CheckResult.DONE);
                    }
                    break block60;
                }
                catch (SQLException e) {
                    this.setState(CheckResult.INTERNAL_ERROR);
                }
                break block60;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (this.result == CheckResult.WORKING) {
                    this.setState(CheckResult.INTERNAL_ERROR);
                }
                Map<String, ImageValidCheck> map = inProgress;
                synchronized (map) {
                    TimeoutHashMap<String, ImageValidCheck> timeoutHashMap = done;
                    synchronized (timeoutHashMap) {
                        ImageValidCheck ivc = inProgress.remove(this.versionId);
                        done.put(this.versionId, ivc);
                    }
                }
                ImageValidCheck.checkForWork();
            }
        }
    }

    private boolean checkBlockHashes(final LocalImageVersion imageVersion) throws IOException, InterruptedException {
        ImageVersionMeta versionDetails;
        try {
            versionDetails = DbImage.getVersionDetails(this.versionId);
        }
        catch (TNotFoundException e) {
            LOGGER.warn("Cannot check hash of image version - not found: " + this.versionId);
            this.setState(CheckResult.UNKNOWN_VERSIONID);
            return false;
        }
        catch (SQLException e) {
            this.setState(CheckResult.INTERNAL_ERROR);
            return false;
        }
        if (versionDetails.sha1sums == null || versionDetails.sha1sums.isEmpty()) {
            LOGGER.info("Image does not have block hashes -- assuming ok");
            return true;
        }
        int numChecked = 0;
        final Semaphore sem = new Semaphore(0);
        final AtomicBoolean fileOk = new AtomicBoolean(true);
        File path = FileSystem.composeAbsoluteImagePath(imageVersion);
        try (RandomAccessFile raf = new RandomAccessFile(path, "r");){
            long startOffset = 0L;
            for (ByteBuffer hash : versionDetails.sha1sums) {
                if (hash == null) {
                    startOffset += 0x1000000L;
                    continue;
                }
                long endOffset = startOffset + 0x1000000L;
                if (endOffset > imageVersion.fileSize) {
                    endOffset = imageVersion.fileSize;
                }
                StandaloneFileChunk chunk = new StandaloneFileChunk(startOffset, endOffset, ThriftUtil.unwrapByteBuffer(hash));
                byte[] buffer = new byte[(int)(endOffset - startOffset)];
                raf.seek(startOffset);
                raf.readFully(buffer);
                hashChecker.queue(chunk, buffer, new HashChecker.HashCheckCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void hashCheckDone(HashChecker.HashResult result, byte[] data, FileChunk chunk) {
                        try {
                            if (result == HashChecker.HashResult.FAILURE) {
                            } else {
                                if (result == HashChecker.HashResult.INVALID) {
                                    fileOk.set(false);
                                    ((StandaloneFileChunk)chunk).overrideStatus(ChunkStatus.MISSING);
                                } else {
                                    ((StandaloneFileChunk)chunk).overrideStatus(ChunkStatus.COMPLETE);
                                }
                                try {
                                    DbImageBlock.asyncUpdate(imageVersion.imageVersionId, chunk);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        finally {
                            sem.release();
                        }
                    }
                }, 3);
                ++numChecked;
                startOffset += 0x1000000L;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        sem.acquire(numChecked);
        if (fileOk.get()) {
            return true;
        }
        this.setState(CheckResult.FILE_CORRUPT);
        return false;
    }

    private boolean checkValid(LocalImageVersion imageVersion) {
        if (imageVersion == null) {
            return false;
        }
        if (imageVersion.expireTime < Util.unixTime()) {
            LOGGER.info(this.versionId + ": expired");
            this.setState(CheckResult.VERSION_EXPIRED);
            return false;
        }
        if (imageVersion.filePath == null || imageVersion.filePath.isEmpty()) {
            LOGGER.info(this.versionId + ": DB does not contain a path");
            this.setState(CheckResult.DATABASE_PATH_MISSING);
            return false;
        }
        File path = FileSystem.composeAbsoluteImagePath(imageVersion);
        if (path == null) {
            LOGGER.info(this.versionId + ": path from DB is not valid");
            this.setState(CheckResult.DATABASE_PATH_INVALID);
            return false;
        }
        if (!path.exists()) {
            LOGGER.info(this.versionId + ": File does not exist (" + path.getAbsolutePath() + ")");
            this.setState(CheckResult.FILE_NOT_FOUND);
            return false;
        }
        if (!path.canRead()) {
            LOGGER.info(this.versionId + ": File exists but not readable (" + path.getAbsolutePath() + ")");
            this.setState(CheckResult.FILE_ACCESS_ERROR);
            return false;
        }
        if (path.length() != imageVersion.fileSize) {
            LOGGER.info(this.versionId + ": File exists but has wrong size (expected: " + imageVersion.fileSize + ", found: " + path.length() + ")");
            this.setState(CheckResult.FILE_SIZE_MISMATCH);
            return false;
        }
        return true;
    }

    static {
        HashChecker hc;
        LOGGER = LogManager.getLogger(ImageValidCheck.class);
        queue = new LinkedList<ImageValidCheck>();
        inProgress = new HashMap<String, ImageValidCheck>();
        done = new TimeoutHashMap(TimeUnit.MINUTES.toMillis(60L));
        long maxMem = Runtime.getRuntime().maxMemory() / 0x100000L;
        int hashQueueLen = maxMem < 1200L ? 1 : 2;
        try {
            hc = new HashChecker("SHA-1", hashQueueLen);
        }
        catch (NoSuchAlgorithmException e) {
            hc = null;
        }
        hashChecker = hc;
    }

    public static enum SubmitResult {
        QUEUED,
        NULL_POINTER_EXCEPTION,
        ALREADY_IN_PROGRESS,
        TOO_MANY_QUEUED_JOBS,
        REJECTED_BY_SCHEDULER;

    }

    public static enum CheckResult {
        QUEUED(0),
        NO_SUCH_JOB(0),
        WAITING_FOR_STORE(1),
        WORKING(2),
        DONE(100),
        VERSION_EXPIRED(100),
        DATABASE_PATH_MISSING(100),
        DATABASE_PATH_INVALID(100),
        FILE_NOT_FOUND(100),
        FILE_ACCESS_ERROR(100),
        FILE_SIZE_MISMATCH(100),
        FILE_CORRUPT(100),
        UNKNOWN_VERSIONID(100),
        INTERNAL_ERROR(100);

        public final int stage;

        private CheckResult(int stage) {
            this.stage = stage;
        }
    }
}

