/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.maintenance;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.bwlp.sat.mail.MailQueue;
import org.openslx.bwlp.sat.maintenance.Maintenance;
import org.openslx.util.QuickTimer;

public class MailFlusher
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(MailFlusher.class);
    private static final MailFlusher instance = new MailFlusher();
    private static long blockedUntil = 0L;

    public static synchronized void init() {
        if (blockedUntil != 0L) {
            return;
        }
        LOGGER.debug("Initializing mail flusher");
        blockedUntil = 1L;
        QuickTimer.scheduleAtFixedRate(new QuickTimer.Task(){

            @Override
            public void fire() {
                if (blockedUntil > System.currentTimeMillis()) {
                    return;
                }
                MailFlusher.start();
            }
        }, TimeUnit.MINUTES.toMillis(6L), TimeUnit.MINUTES.toMillis(10L));
    }

    public static synchronized void start() {
        if (blockedUntil > System.currentTimeMillis()) {
            return;
        }
        if (Maintenance.trySubmit(instance)) {
            blockedUntil = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(10L);
        }
    }

    @Override
    public void run() {
        try {
            MailQueue.flush();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

