/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.maintenance;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Maintenance
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(Maintenance.class);
    private static Set<Maintenance> workers = new HashSet<Maintenance>();
    private static BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(50);
    private static final AtomicInteger ID_CTR = new AtomicInteger();

    private Maintenance() {
        super("Maint-" + ID_CTR.incrementAndGet());
        this.setPriority(3);
    }

    private static synchronized void ensureRunning() {
        if (workers.isEmpty() || queue.size() > 5 && workers.size() < 3) {
            Maintenance worker = new Maintenance();
            worker.start();
            workers.add(worker);
        }
    }

    public static void submit(Runnable job) throws InterruptedException {
        Maintenance.ensureRunning();
        queue.put(job);
    }

    public static boolean trySubmit(Runnable job) {
        Maintenance.ensureRunning();
        return queue.offer(job);
    }

    @Override
    public void run() {
        LOGGER.info("Maintenance Thread started");
        try {
            while (true) {
                Runnable job = queue.take();
                this.runJob(job);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Maintenance Thread was interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void runJob(Runnable job) {
        try {
            job.run();
        }
        catch (Throwable t) {
            LOGGER.warn("Uncaught exception in job '" + job.getClass().getSimpleName() + "'", t);
        }
    }
}

