/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.maintenance;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbLecture;
import org.openslx.bwlp.sat.database.models.LocalImageVersion;
import org.openslx.bwlp.sat.mail.MailGenerator;
import org.openslx.bwlp.sat.maintenance.Maintenance;
import org.openslx.bwlp.sat.util.FileSystem;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class SendExpireWarning
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(SendExpireWarning.class);
    private static final SendExpireWarning instance = new SendExpireWarning();
    private static long blockedUntil = 0L;

    public static synchronized void init() {
        if (blockedUntil != 0L) {
            return;
        }
        blockedUntil = 1L;
        QuickTimer.scheduleAtFixedRate(new QuickTimer.Task(){

            @Override
            public void fire() {
                if (blockedUntil > System.currentTimeMillis()) {
                    return;
                }
                DateTime now = DateTime.now();
                if (now.getHourOfDay() != 3 || now.getMinuteOfHour() > 15) {
                    return;
                }
                SendExpireWarning.start();
            }
        }, TimeUnit.MINUTES.toMillis(4L), TimeUnit.MINUTES.toMillis(5L));
    }

    public static synchronized void start() {
        if (blockedUntil > System.currentTimeMillis()) {
            return;
        }
        if (Maintenance.trySubmit(instance)) {
            blockedUntil = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(12L);
        }
    }

    @Override
    public void run() {
        this.checkImages();
        this.checkLectures();
        LOGGER.info("Done scanning for expired lectures/VMs");
    }

    private void checkLectures() {
        List<LectureSummary> lectures;
        try {
            lectures = DbLecture.getExpiringLectures(15);
        }
        catch (SQLException e) {
            LOGGER.warn("Could not get list of expiring lectures; skipping warning mails");
            return;
        }
        LOGGER.info("Scanning expiring lectures to send mails to users...");
        long now = Util.unixTime();
        for (LectureSummary lecture : lectures) {
            int days = (int)((lecture.endTime - now) / 86400L);
            if ((!lecture.isEnabled || days != 14 && days != 1) && days != 7) continue;
            LOGGER.debug(lecture.lectureName + " expires in " + days);
            MailGenerator.sendLectureExpiringReminder(lecture, days);
        }
    }

    private void checkImages() {
        List<LocalImageVersion> versions;
        if (!FileSystem.isStorageMounted()) {
            LOGGER.warn("Skipping sending warning mails about expiring images - storage seems unmounted");
            return;
        }
        try {
            versions = DbImage.getExpiringLocalImageVersions(15);
        }
        catch (SQLException e) {
            LOGGER.warn("Could not determine expiring versions; skipping warning mails");
            return;
        }
        LOGGER.info("Scanning for expiring images to send mails to users...");
        long now = Util.unixTime();
        for (LocalImageVersion version : versions) {
            boolean mailForced;
            int days = (int)((version.expireTime - now) / 86400L);
            boolean mailNormal = version.isValid && (days == 14 || days == 7 || days == 1) || !version.isValid && days == 3;
            boolean bl = mailForced = version.isValid && days == 1;
            if (!mailNormal && !mailForced) continue;
            LOGGER.debug(version.imageVersionId + " expires in " + days);
            MailGenerator.sendImageDeletionReminder(version, days, mailForced);
        }
    }
}

