/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.permissions;

import java.sql.SQLException;
import java.util.Map;
import org.openslx.bwlp.sat.database.mappers.DbOrganization;
import org.openslx.bwlp.sat.database.mappers.DbUser;
import org.openslx.bwlp.sat.database.models.LocalOrganization;
import org.openslx.bwlp.sat.database.models.LocalUser;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.util.TimeoutHashMap;

public class LocalData {
    private static final Map<String, LocalUser> localUserCache = new TimeoutHashMap<String, LocalUser>(15000L);
    private static final Map<String, LocalOrganization> localOrganizationCache = new TimeoutHashMap<String, LocalOrganization>(15000L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LocalUser getLocalUser(UserInfo user) {
        LocalUser localData;
        Map<String, LocalUser> map = localUserCache;
        synchronized (map) {
            LocalUser local = localUserCache.get(user.userId);
            if (local != null) {
                return local;
            }
        }
        try {
            localData = DbUser.getLocalData(user);
        }
        catch (SQLException e) {
            return null;
        }
        if (localData == null) {
            return null;
        }
        Map<String, LocalUser> map2 = localUserCache;
        synchronized (map2) {
            localUserCache.put(user.userId, localData);
        }
        return localData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LocalOrganization getLocalOrganization(String organizationId) {
        LocalOrganization localData;
        Map<String, LocalOrganization> map = localOrganizationCache;
        synchronized (map) {
            LocalOrganization local = localOrganizationCache.get(organizationId);
            if (local != null) {
                return local;
            }
        }
        try {
            localData = DbOrganization.getLocalData(organizationId);
        }
        catch (SQLException e) {
            return null;
        }
        if (localData == null) {
            return null;
        }
        Map<String, LocalOrganization> map2 = localOrganizationCache;
        synchronized (map2) {
            localOrganizationCache.put(organizationId, localData);
        }
        return localData;
    }
}

