/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.permissions;

import java.sql.SQLException;
import org.openslx.bwlp.sat.RuntimeConfig;
import org.openslx.bwlp.sat.database.mappers.DbImage;
import org.openslx.bwlp.sat.database.mappers.DbLecture;
import org.openslx.bwlp.sat.database.mappers.DbOrganization;
import org.openslx.bwlp.sat.database.models.LocalOrganization;
import org.openslx.bwlp.sat.database.models.LocalUser;
import org.openslx.bwlp.sat.permissions.LocalData;
import org.openslx.bwlp.sat.thrift.cache.OrganizationList;
import org.openslx.bwlp.sat.util.Sanitizer;
import org.openslx.bwlp.thrift.iface.AuthorizationError;
import org.openslx.bwlp.thrift.iface.ImageDetailsRead;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.LectureRead;
import org.openslx.bwlp.thrift.iface.LectureSummary;
import org.openslx.bwlp.thrift.iface.Role;
import org.openslx.bwlp.thrift.iface.ShareMode;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.UserInfo;

public class User {
    private static final ImagePermissions imageSu = new ImagePermissions(true, true, true, true);
    private static final LecturePermissions lectureSu = new LecturePermissions(true, true);
    private static final LecturePermissions lectureNothing = new LecturePermissions(false, false);

    public static boolean isTutor(UserInfo user) {
        return user != null && user.role == Role.TUTOR;
    }

    public static boolean isStudent(UserInfo user) {
        return user != null && user.role == Role.STUDENT;
    }

    public static boolean isSuperUser(UserInfo user) {
        LocalUser localData = LocalData.getLocalUser(user);
        return localData != null && localData.isSuperUser;
    }

    public static AuthorizationError canLogin(UserInfo user) {
        if (!RuntimeConfig.allowStudentDownload() && user.role == Role.STUDENT) {
            return AuthorizationError.ACCOUNT_SUSPENDED;
        }
        LocalUser localData = LocalData.getLocalUser(user);
        if (localData != null) {
            if (localData.canLogin) {
                return null;
            }
            return AuthorizationError.ACCOUNT_SUSPENDED;
        }
        LocalOrganization local = LocalData.getLocalOrganization(user.organizationId);
        if (local == null && OrganizationList.find(user.organizationId) == null) {
            return AuthorizationError.INVALID_ORGANIZATION;
        }
        if (local != null && local.canLogin) {
            return null;
        }
        try {
            if (DbOrganization.getLoginAllowedOrganizations().isEmpty()) {
                DbOrganization.setCanLogin(user.organizationId, true);
                return null;
            }
            return AuthorizationError.ORGANIZATION_SUSPENDED;
        }
        catch (SQLException sQLException) {
            return AuthorizationError.GENERIC_ERROR;
        }
    }

    public static void canCreateImageOrFail(UserInfo user) throws TAuthorizationException {
        if (!User.isTutor(user)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to create new image");
        }
    }

    public static void canEditBaseImageOrFail(UserInfo user, String imageBaseId) throws TInvocationException, TNotFoundException, TAuthorizationException {
        ImageSummaryRead image = User.getImageFromBaseId(user, imageBaseId);
        if (!image.userPermissions.edit) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to edit this image");
        }
    }

    public static void canEditImageVersionOrFail(UserInfo user, String imageVersionId) throws TInvocationException, TNotFoundException, TAuthorizationException {
        try {
            User.canEditBaseImageOrFail(user, DbImage.getBaseIdForVersionId(imageVersionId));
        }
        catch (SQLException e) {
            throw new TInvocationException();
        }
    }

    public static void canDeleteImageVersionOrFail(UserInfo user, String imageVersionId) throws TInvocationException, TNotFoundException, TAuthorizationException {
        ImageDetailsRead imageDetails;
        try {
            imageDetails = DbImage.getImageDetails(user, DbImage.getBaseIdForVersionId(imageVersionId));
        }
        catch (SQLException e) {
            throw new TInvocationException();
        }
        if (imageDetails.shareMode == ShareMode.DOWNLOAD && imageDetails.latestVersionId.equals(imageVersionId)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "Cannot delete latest version of image if auto-download is enabled");
        }
        if (imageDetails.userPermissions.admin) {
            return;
        }
        if (imageDetails.userPermissions.edit) {
            for (ImageVersionDetails version : imageDetails.versions) {
                if (!version.versionId.equals(imageVersionId) || !version.uploaderId.equals(user.userId)) continue;
                return;
            }
        }
        throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to delete this image version");
    }

    public static void canDeleteImageOrFail(ImageDetailsRead imageDetails) throws TAuthorizationException {
        if (imageDetails.userPermissions.admin) {
            return;
        }
        throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to delete this image");
    }

    public static void canDownloadImageVersionOrFail(UserInfo user, String imageBaseId, String imageVersionId) throws TAuthorizationException, TNotFoundException, TInvocationException {
        ImageDetailsRead image;
        try {
            if (imageBaseId == null) {
                imageBaseId = DbImage.getBaseIdForVersionId(imageVersionId);
            }
            image = DbImage.getImageDetails(user, imageBaseId);
        }
        catch (SQLException e) {
            throw new TInvocationException();
        }
        if (image.userPermissions.download) {
            if (User.isTutor(user)) {
                return;
            }
            for (ImageVersionDetails version : image.versions) {
                if (version.isRestricted || !version.versionId.equals(imageVersionId)) continue;
                return;
            }
        }
        throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to download this image version");
    }

    public static void canCreateLectureOrFail(UserInfo user) throws TAuthorizationException {
        if (!User.isTutor(user)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to create new lecture");
        }
    }

    public static boolean canEditImagePermissions(UserInfo user, String imageBaseId) throws TInvocationException, TNotFoundException {
        ImageSummaryRead image = User.getImageFromBaseId(user, imageBaseId);
        return image.userPermissions.admin;
    }

    public static void canEditImagePermissionsOrFail(UserInfo user, String imageBaseId) throws TAuthorizationException, TInvocationException, TNotFoundException {
        if (!User.canEditImagePermissions(user, imageBaseId)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to edit this image's permissions");
        }
    }

    public static void canChangeImageOwnerOrFail(UserInfo user, String imageBaseId) throws TAuthorizationException, TInvocationException, TNotFoundException {
        ImageSummaryRead image = User.getImageFromBaseId(user, imageBaseId);
        if (!image.userPermissions.admin) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to change image owner");
        }
    }

    public static void canEditLectureOrFail(UserInfo user, String lectureId) throws TInvocationException, TNotFoundException, TAuthorizationException {
        User.canEditLectureOrFail(user, User.getLectureFromId(user, lectureId));
    }

    public static void canEditLectureOrFail(UserInfo user, LectureSummary lecture) throws TAuthorizationException {
        if (!lecture.userPermissions.edit) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to edit this image");
        }
    }

    public static boolean canEditLecturePermissions(UserInfo user, String lectureId) throws TNotFoundException, TInvocationException {
        LectureSummary lecture = User.getLectureFromId(user, lectureId);
        return lecture.userPermissions.admin;
    }

    public static void canEditLecturePermissionsOrFail(UserInfo user, String lectureId) throws TAuthorizationException, TNotFoundException, TInvocationException {
        if (!User.canEditLecturePermissions(user, lectureId)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to edit permissions");
        }
    }

    public static void canChangeLectureOwnerOrFail(UserInfo user, LectureSummary lecture) throws TAuthorizationException, TNotFoundException, TInvocationException {
        if (!lecture.userPermissions.admin) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to change lecture owner");
        }
    }

    public static void canLinkToImageOrFail(UserInfo user, String imageVersionId) throws TNotFoundException, TInvocationException, TAuthorizationException {
        if (imageVersionId == null) {
            return;
        }
        ImageSummaryRead image = User.getImageFromVersionId(user, imageVersionId);
        if (!image.userPermissions.link) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to link to this image");
        }
    }

    public static boolean canListImages(UserInfo user) throws TAuthorizationException {
        return User.isTutor(user);
    }

    public static void canListImagesOrFail(UserInfo user) throws TAuthorizationException {
        if (!User.canListImages(user)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to see list of images");
        }
    }

    public static void canSeeImageDetailsOrFail(UserInfo user) throws TAuthorizationException {
        if (!User.isTutor(user)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to see image details");
        }
    }

    public static void canSeeLectureDetailsOrFail(UserInfo user) throws TAuthorizationException {
        if (!User.isTutor(user)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to see lecture details");
        }
    }

    public static void canDeleteLectureOrFail(UserInfo user, String lectureId) throws TAuthorizationException, TInvocationException, TNotFoundException {
        LectureSummary lecture = User.getLectureFromId(user, lectureId);
        if (!lecture.userPermissions.admin) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "No permission to delete this lecture");
        }
    }

    public static void canChangeImageExpireDateOrFail(UserInfo user) throws TAuthorizationException {
        if (!User.isSuperUser(user)) {
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "Only the super user can change the expire date of images");
        }
    }

    public static void canUploadToMasterOrFail(UserInfo user, ImageSummaryRead imgBase) throws TAuthorizationException {
        if (User.isSuperUser(user)) {
            return;
        }
        if (imgBase.userPermissions.admin) {
            return;
        }
        throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "You need to be image admin to upload to master server");
    }

    public static void canTriggerReplicationOrFail(UserInfo user, String imageVersionId) throws TAuthorizationException, TInvocationException {
        if (User.isTutor(user)) {
            ImageSummaryRead image;
            try {
                image = User.getImageFromVersionId(user, imageVersionId);
            }
            catch (TNotFoundException e) {
                return;
            }
            if (image.shareMode == ShareMode.DOWNLOAD || image.shareMode == ShareMode.FROZEN || image.userPermissions.edit) {
                return;
            }
            throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "You cannot trigger downloading an image to the satellite server that is not in replication mode");
        }
        throw new TAuthorizationException(AuthorizationError.NO_PERMISSION, "Only tutors can trigger image replication");
    }

    public static void setCombinedUserPermissions(ImageSummaryRead image, UserInfo user) {
        if (User.hasAllImagePermissions(user, image.ownerId)) {
            image.userPermissions = imageSu;
            return;
        }
        image.userPermissions = User.calculateUserImagePermissions(user, image.userPermissions, image.defaultPermissions);
    }

    public static void setCombinedUserPermissions(ImageDetailsRead image, UserInfo user) {
        if (User.hasAllImagePermissions(user, image.ownerId)) {
            image.userPermissions = imageSu;
            return;
        }
        image.userPermissions = User.calculateUserImagePermissions(user, image.userPermissions, image.defaultPermissions);
    }

    public static void setCombinedUserPermissions(LectureRead lecture, UserInfo user) {
        if (user == null || user.role == Role.STUDENT) {
            lecture.userPermissions = lectureNothing;
            return;
        }
        if (User.hasAllLecturePermissions(user, lecture.ownerId)) {
            lecture.userPermissions = lectureSu;
            return;
        }
        if (lecture.userPermissions == null) {
            lecture.userPermissions = lecture.defaultPermissions;
        }
        lecture.userPermissions = Sanitizer.handleLecturePermissions(lecture.userPermissions);
    }

    public static void setCombinedUserPermissions(LectureSummary lecture, UserInfo user) {
        if (user == null || user.role == Role.STUDENT) {
            lecture.userPermissions = lectureNothing;
            return;
        }
        if (User.hasAllLecturePermissions(user, lecture.ownerId)) {
            lecture.userPermissions = lectureSu;
            return;
        }
        if (lecture.userPermissions == null) {
            lecture.userPermissions = lecture.defaultPermissions;
        }
        lecture.userPermissions = Sanitizer.handleLecturePermissions(lecture.userPermissions);
    }

    private static boolean hasAllImagePermissions(UserInfo user, String imageOwnerId) {
        if (user != null && user.role == Role.TUTOR) {
            if (user.userId.equals(imageOwnerId)) {
                return true;
            }
            LocalUser localUser = LocalData.getLocalUser(user);
            if (localUser != null && localUser.isSuperUser) {
                return true;
            }
        }
        return false;
    }

    private static ImagePermissions calculateUserImagePermissions(UserInfo user, ImagePermissions userPerms, ImagePermissions defPerms) {
        if (userPerms == null) {
            userPerms = defPerms;
        }
        if (user == null || user.role == Role.STUDENT) {
            if (userPerms.link || userPerms.admin || userPerms.edit) {
                if (userPerms == defPerms) {
                    userPerms = new ImagePermissions(defPerms);
                }
                userPerms.link = false;
                userPerms.edit = false;
                userPerms.admin = false;
            }
        } else {
            userPerms = Sanitizer.handleImagePermissions(userPerms);
        }
        return userPerms;
    }

    private static boolean hasAllLecturePermissions(UserInfo user, String lectureOwnerId) {
        if (user != null && user.role == Role.TUTOR) {
            if (user.userId.equals(lectureOwnerId)) {
                return true;
            }
            LocalUser localUser = LocalData.getLocalUser(user);
            if (localUser != null && localUser.isSuperUser) {
                return true;
            }
        }
        return false;
    }

    private static ImageSummaryRead getImageFromBaseId(UserInfo user, String imageBaseId) throws TNotFoundException, TInvocationException {
        try {
            return DbImage.getImageSummary(user, imageBaseId);
        }
        catch (SQLException e) {
            throw new TInvocationException();
        }
    }

    private static ImageSummaryRead getImageFromVersionId(UserInfo user, String imageVersionId) throws TNotFoundException, TInvocationException {
        try {
            return DbImage.getImageSummary(user, DbImage.getBaseIdForVersionId(imageVersionId));
        }
        catch (SQLException e) {
            throw new TInvocationException();
        }
    }

    private static LectureSummary getLectureFromId(UserInfo user, String lectureId) throws TNotFoundException, TInvocationException {
        try {
            return DbLecture.getLectureSummary(user, lectureId);
        }
        catch (SQLException e) {
            throw new TInvocationException();
        }
    }
}

