/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.sat.thrift;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TFastFramedTransport;
import org.openslx.bwlp.sat.thrift.ServerHandler;
import org.openslx.bwlp.sat.util.Identity;
import org.openslx.bwlp.thrift.iface.SatelliteServer;
import org.openslx.thrifthelper.TBinaryProtocolSafe;

public class BinaryListener
implements Runnable {
    private static final Logger log = LogManager.getLogger(BinaryListener.class);
    private static final int MAX_MSG_LEN = 8000000;
    private final SatelliteServer.Processor<ServerHandler> processor = new SatelliteServer.Processor<ServerHandler>(new ServerHandler());
    private final TProtocolFactory protFactory = new TBinaryProtocolSafe.Factory(true, true);
    private final TServer server;

    public BinaryListener(int port, boolean secure, ExecutorService es) throws TTransportException, NoSuchAlgorithmException, IOException {
        this.server = secure ? this.initSecure(port, es) : this.initNormal(port, es);
    }

    @Override
    public void run() {
        log.info("Starting Listener");
        this.server.serve();
        log.fatal("Listener stopped unexpectedly");
    }

    private TServer initSecure(int port, ExecutorService es) throws NoSuchAlgorithmException, TTransportException, IOException {
        TServerSocket serverTransport;
        SSLContext context = Identity.getSSLContext();
        if (context == null) {
            return null;
        }
        SSLServerSocketFactory sslServerSocketFactory = context.getServerSocketFactory();
        ServerSocket listenSocket = sslServerSocketFactory.createServerSocket();
        listenSocket.setReuseAddress(true);
        listenSocket.bind(new InetSocketAddress(port));
        try {
            serverTransport = new TServerSocket(listenSocket);
        }
        catch (TTransportException e) {
            log.fatal("Could not listen on port " + port);
            throw e;
        }
        TThreadPoolServer.Args args = new TThreadPoolServer.Args(serverTransport);
        args.protocolFactory(this.protFactory);
        args.processor(this.processor);
        args.executorService(es);
        args.stopTimeoutVal(15).stopTimeoutUnit(TimeUnit.SECONDS);
        args.transportFactory(new TFastFramedTransport.Factory(8192, 8000000));
        return new TThreadPoolServer(args);
    }

    private TServer initNormal(int port, ExecutorService es) throws TTransportException {
        TNonblockingServerSocket serverTransport;
        try {
            serverTransport = new TNonblockingServerSocket(port);
            log.info("Listening on port " + port + " (plain handler)");
        }
        catch (TTransportException e) {
            log.info("Could not listen on port " + port + " (plain handler)");
            throw e;
        }
        THsHaServer.Args args = new THsHaServer.Args(serverTransport);
        args.protocolFactory(this.protFactory);
        args.processor(this.processor);
        args.executorService(es);
        args.maxReadBufferBytes = 8000000L;
        return new THsHaServer(args);
    }
}

